/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg.xml;

import org.dcm4chex.rid.mbean.ecg.xml.WaveformScalingInfo;

public class WaveformArea {
    public static final int TYPE_CAL_PULSE = 1;
    public static final int TYPE_WAVEFORM = 2;
    private int type;
    private float leftX;
    private float topY;
    private float width;
    private float height;
    private int waveformIndex = -1;
    private String waveformDescription = null;
    private WaveformScalingInfo scalingInfo;

    private WaveformArea(int type, float x, float y, float w, float h) {
        this.type = type;
        this.leftX = x;
        this.topY = y;
        this.width = w;
        this.height = h;
    }

    private WaveformArea(int type, float x, float y, float w, float h, int idx, String desc, WaveformScalingInfo scale) {
        this(type, x, y, w, h);
        this.waveformIndex = idx;
        this.waveformDescription = desc;
        this.scalingInfo = scale;
    }

    public static WaveformArea getCalPulseArea(float x, float y, float w, float h) {
        return new WaveformArea(1, x, y, w, h);
    }

    public static WaveformArea getWaveformArea(float x, float y, float w, float h, int idx, String desc, WaveformScalingInfo scale) {
        return new WaveformArea(2, x, y, w, h, idx, desc, scale);
    }

    public int getType() {
        return this.type;
    }

    public float getLeftX() {
        return this.leftX;
    }

    public float getTopY() {
        return this.topY;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public String getWaveformDescription() {
        return this.waveformDescription;
    }

    public int getWaveformIndex() {
        return this.waveformIndex;
    }

    public WaveformScalingInfo getScalingInfo() {
        return this.scalingInfo;
    }
}

