/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg.xml;

import org.dcm4chex.rid.mbean.ecg.xml.WaveformArea;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformScalingInfo;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformTemplate;

public class TwelveLeadTemplate
implements WaveformTemplate {
    public static final float MIN_WIDTH = 1000.0f;
    public static final float MIN_HEIGHT = 1000.0f;
    public static final float CAL_PULSE_WIDTH = 120.0f;
    public static final WaveformScalingInfo SCALING_INFO = new WaveformScalingInfo(250.0f, null, 100.0f, "mV");
    private float width;
    private float height;
    private WaveformArea[] calPulseAreas = new WaveformArea[6];
    private WaveformArea[] wfAreas = new WaveformArea[12];

    public TwelveLeadTemplate(float w, float h) {
        if (w < 1000.0f | h < 1000.0f) {
            throw new IllegalArgumentException("Template size too small ( " + w + " x " + h + " )! Min size: " + 1000.0f + " x " + 1000.0f);
        }
        this.width = w;
        this.height = h;
        this.initAreas();
    }

    private void initAreas() {
        float lineHeight = this.height / 6.0f;
        float wfWidth = (this.width - 120.0f) / 2.0f;
        float rightWaveformX = 120.0f + wfWidth;
        float topY = 0.0f;
        int i = 0;
        while (i < 6) {
            this.calPulseAreas[i] = WaveformArea.getCalPulseArea(0.0f, topY, 120.0f, lineHeight);
            this.wfAreas[i] = WaveformArea.getWaveformArea(120.0f, topY, wfWidth, lineHeight, i, null, SCALING_INFO);
            this.wfAreas[i + 6] = WaveformArea.getWaveformArea(rightWaveformX, topY, wfWidth, lineHeight, i + 6, null, SCALING_INFO);
            ++i;
            topY += lineHeight;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public WaveformArea[] getAreas() {
        WaveformArea[] all = new WaveformArea[18];
        System.arraycopy(this.calPulseAreas, 0, all, 0, 6);
        System.arraycopy(this.wfAreas, 0, all, 6, 12);
        return all;
    }

    public WaveformArea[] getCalPulseAreas() {
        return this.calPulseAreas;
    }

    public WaveformArea[] getWaveformAreas() {
        return this.wfAreas;
    }

    public String getFooterText() {
        return "25mm/sec 10mm/mV";
    }
}

