/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg.xml;

import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dcm4chex.rid.mbean.ecg.WaveFormChannel;
import org.dcm4chex.rid.mbean.ecg.WaveformGroup;
import org.dcm4chex.rid.mbean.ecg.WaveformInfo;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformArea;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformScalingInfo;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformTemplate;
import org.dcm4chex.rid.mbean.ecg.xml.WaveformTemplateFactory;
import org.dcm4chex.rid.mbean.xml.XMLResponseObject;
import org.dcm4chex.rid.mbean.xml.XMLUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGCreator
implements XMLResponseObject {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat DATETIME_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final float PIX_PER_SEC = 250.0f;
    private static final NumberFormat cmFormatter = new DecimalFormat("##.##cm", new DecimalFormatSymbols(new Locale("en", "us")));
    private static Logger log = Logger.getLogger((String)SVGCreator.class.getName());
    private TransformerHandler th = null;
    private XMLUtil util = null;
    private String width = "26.60cm";
    private String height = "20.3cm";
    private int viewBoxY1 = 0;
    private int viewBoxX1 = 0;
    private float viewBoxWidth = 2660.0f;
    private float viewBoxHeight = 2030.0f;
    private float graphicXOffset = 0.0f;
    private float graphicYOffset = 0.0f;
    private int graphicWidthCm = 25;
    private int graphicHeightCm = 19;
    private int graphicWidth = this.graphicWidthCm * 100;
    private int graphicHeight = this.graphicHeightCm * 100;
    private WaveformGroup waveForms;
    private WaveformInfo info;
    private String nameSpace = null;
    private float scaling = 0.28169f;
    WaveformTemplate wfTemplate;
    private static final String[] WF_COLORS = new String[]{"black", "green", "red", "blue"};

    public SVGCreator(WaveformGroup wfgrp, WaveformInfo wfInfo, Float width, Float height) {
        this.waveForms = wfgrp;
        this.info = wfInfo;
        if (width != null) {
            this.setPageWidth(width.floatValue());
        } else {
            float prefWidth = 250.0f / wfgrp.getSampleFreq() * (float)wfgrp.getNrOfSamples();
            prefWidth *= 2.0f;
            prefWidth += 110.0f;
            if (log.isDebugEnabled()) {
                log.debug((Object)("calculated width:" + prefWidth));
            }
            if (prefWidth > this.viewBoxWidth) {
                this.setPageWidth(prefWidth / 100.0f);
            }
        }
        if (height != null) {
            this.height = cmFormatter.format(height);
            this.viewBoxHeight = height.floatValue() * 100.0f;
            this.graphicHeightCm = height.intValue();
            this.graphicHeight = this.graphicHeightCm * 100;
        }
    }

    private void setPageWidth(float width) {
        this.width = cmFormatter.format(width);
        this.viewBoxWidth = width * 100.0f;
        this.graphicWidthCm = new Float(width).intValue();
        this.graphicWidth = this.graphicWidthCm * 100;
        float delta = this.viewBoxWidth - (float)this.graphicWidth;
        this.graphicXOffset = delta / 2.0f;
    }

    public int getViewBoxX1() {
        return this.viewBoxX1;
    }

    public void setViewBoxX1(int viewBoxX1) {
        this.viewBoxX1 = viewBoxX1;
    }

    public float getViewBoxWidth() {
        return this.viewBoxWidth;
    }

    public void setViewBoxWidth(float width) {
        this.viewBoxWidth = width;
    }

    public int getViewBoxY1() {
        return this.viewBoxY1;
    }

    public void setViewBoxY1(int viewBoxY1) {
        this.viewBoxY1 = viewBoxY1;
    }

    public float getViewBoxHeight() {
        return this.viewBoxHeight;
    }

    public void setViewBoxHeight(float height) {
        this.viewBoxHeight = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void toXML(OutputStream out) throws TransformerConfigurationException, SAXException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.th = tf.newTransformerHandler();
        this.th.getTransformer().setOutputProperty("indent", "yes");
        this.th.setResult(new StreamResult(out));
        this.nameSpace = null;
        this.th.startDocument();
        this.toXML();
        this.th.endDocument();
        try {
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not create XML.", (Throwable)e);
        }
    }

    public void embedXML(TransformerHandler th) throws TransformerConfigurationException, SAXException {
        this.th = th;
        this.nameSpace = "svg";
        if (log.isDebugEnabled()) {
            log.debug((Object)"embedXML called!");
        }
        this.toXML();
    }

    protected void setXMLUtil(XMLUtil util) {
        this.util = util;
    }

    private void toXML() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"toXML called!");
        }
        this.util = new XMLUtil(this.th, this.nameSpace);
        this.addSVGStart();
        this.addTitleAndDesc();
        if (this.info != null) {
            this.addTextSegment();
            this.addHeaderSeparator();
            this.addShortmeasSegment();
            this.addSeveritySegment();
            this.addInterpContinue();
            this.addLeftstatementSegment();
            this.addRightstatementSegment();
            this.addInterpSeparator();
        }
        this.wfTemplate = WaveformTemplateFactory.getInstance(this.waveForms, (this.graphicWidthCm - 1) * 100, (this.graphicHeightCm - 1) * 100);
        this.addFooter();
        this.addG("scaling", "translate(" + this.graphicXOffset * this.scaling + "," + (this.graphicYOffset + 100.0f) * this.scaling + "), scale(" + this.scaling + ")", null, null, null);
        this.addDefs();
        this.addGrid(this.graphicWidthCm, this.graphicHeightCm);
        if (log.isDebugEnabled()) {
            log.debug((Object)"grid added!");
        }
        this.addGraphic(this.graphicWidthCm, this.graphicHeightCm);
        if (log.isDebugEnabled()) {
            log.debug((Object)"graph added!");
        }
        this.util.endElement("g");
        this.util.endElement("svg");
    }

    private void addTitleAndDesc() throws SAXException {
        this.util.startElement("title", EMPTY_ATTRIBUTES);
        this.util.addValue("TITLE");
        this.util.endElement("title");
        this.util.startElement("desc", EMPTY_ATTRIBUTES);
        this.util.addValue("Description");
        this.util.endElement("desc");
    }

    private void addTextSegment() throws SAXException {
        this.addG("textSegment", "translate(0,30)", null, "40", null);
        this.addText("20", "0", "10", null, null, "2");
        this.addText("20", "25", "10", null, null, "");
        this.addText("140", "0", "10", null, null, this.info.getAcquisDate());
        this.addText("140", "25", "10", null, null, this.info.getBirthday());
        this.addText("210", "0", "10", null, null, this.info.getAcquisTime());
        this.addText("210", "25", "10", null, null, this.info.getSex());
        this.addText("300", "0", "14", null, null, this.info.getPatientName());
        this.addText("300", "25", "10", null, null, "0/0");
        this.addText("330", "25", "10", null, null, this.info.getPatientSize());
        this.addText("400", "25", "10", null, null, this.info.getPatientWeight());
        Properties props = new Properties();
        props.setProperty("text-anchor", "end");
        this.addText("700", "15", "10", "30", props, "Department:");
        this.addText("700", "30", "10", "30", props, "Room:");
        this.addText("700", "50", "10", "30", props, "Operator:");
        this.util.endElement("g");
        this.graphicYOffset += 240.0f;
    }

    private void addHeaderSeparator() throws SAXException {
        this.addPath("headerSeperator", "fill:none; stroke:black", "5", "M 0 90 H " + this.viewBoxWidth * this.scaling);
    }

    private void addShortmeasSegment() {
    }

    private void addSeveritySegment() {
    }

    private void addInterpContinue() {
    }

    private void addLeftstatementSegment() {
    }

    private void addRightstatementSegment() {
    }

    private void addInterpSeparator() {
    }

    private void addFooter() throws SAXException {
        this.addG("footer", "translate(0," + (this.graphicYOffset + (float)this.graphicHeight + 150.0f) * this.scaling + ")", "black", "40", null);
        float endX = (this.graphicXOffset + (float)this.graphicWidth - 60.0f) * this.scaling;
        Properties props = new Properties();
        props.setProperty("id", "filtertext");
        props.setProperty("text-anchor", "end");
        this.addText(String.valueOf(endX), "0", null, null, props, this.waveForms.getFilterText());
        String footer = this.wfTemplate.getFooterText();
        if (footer != null) {
            this.addText(String.valueOf(endX - (float)(footer.length() * 50)), "0", null, null, null, footer);
        }
        this.util.endElement("g");
    }

    protected void addDefs() throws SAXException {
        this.util.startElement("defs", EMPTY_ATTRIBUTES);
        this.addPath("1mmXd", "fill:none; stroke:red", null, "M 0 0 V " + this.graphicHeight);
        this.addPath("1mmYd", "fill:none; stroke:red", null, "M 0 0 H " + this.graphicWidth);
        this.addG("1cmY", null, null, null, null);
        String s1 = "M 0 ";
        String s2 = " H " + this.graphicWidth;
        float step = 10.0f;
        int i = 0;
        while (i < 4) {
            this.addPath("1mmY", "fill:none; stroke:pink", null, s1 + step + s2);
            this.addPath("1mmY", "fill:none; stroke:pink", null, s1 + (step + 50.0f) + s2);
            ++i;
            step += 10.0f;
        }
        this.util.endElement("g");
        this.addG("1cmX", null, null, null, null);
        step = 10.0f;
        s1 = "M ";
        s2 = " 0 V " + this.graphicHeight;
        i = 0;
        while (i < 4) {
            this.addPath("1mmX", "fill:none; stroke:pink", null, s1 + step + s2);
            this.addPath("1mmX", "fill:none; stroke:pink", null, s1 + (step + 50.0f) + s2);
            ++i;
            step += 10.0f;
        }
        this.util.endElement("g");
        this.util.endElement("defs");
    }

    protected void addGrid(int width, int height) throws SAXException {
        this.addG("Xlines", null, null, null, null);
        float step = 0.0f;
        int i = 0;
        while (i < width) {
            this.addUse("#1cmX", "translate(" + step + ",0)", null);
            ++i;
            step += 100.0f;
        }
        this.util.endElement("g");
        this.addG("Ylines", null, null, null, null);
        this.addUse("#1mmYd", "translate(0,0)", null);
        step = 0.0f;
        i = 0;
        while (i < height) {
            this.addUse("#1cmY", "translate(0," + step + ")", null);
            this.addUse("#1mmYd", "translate(0," + (step + 50.0f) + ")", null);
            this.addUse("#1mmYd", "translate(0," + (step + 100.0f) + ")", null);
            ++i;
            step += 100.0f;
        }
        this.util.endElement("g");
        this.addG("Xlinesd", null, null, null, null);
        this.addUse("#1mmXd", "translate(0,0)", null);
        step = 50.0f;
        i = 0;
        while (i < width) {
            this.addUse("#1mmXd", "translate(" + step + ",0)", null);
            this.addUse("#1mmXd", "translate(" + (step + 50.0f) + ",0)", null);
            ++i;
            step += 100.0f;
        }
        this.util.endElement("g");
    }

    private void addGraphic(int width, int height) throws SAXException {
        WaveformArea area;
        int i;
        WaveformArea[] calPulseAreas = this.wfTemplate.getCalPulseAreas();
        WaveformArea[] wfAreas = this.wfTemplate.getWaveformAreas();
        if (calPulseAreas != null) {
            for (i = 0; i < calPulseAreas.length; ++i) {
                area = calPulseAreas[i];
                this.addCalPulse(i, area.getLeftX() + 10.0f, area.getTopY(), area.getHeight());
            }
        }
        if (wfAreas != null) {
            for (i = 0; i < wfAreas.length; ++i) {
                area = wfAreas[i];
                this.addWaveform(area);
            }
        }
    }

    private void addCalPulse(int row, float xOffset, float topPos, float height) throws SAXException {
        float baseLineY = topPos + height / 2.0f;
        this.addG("calpulse row" + row, "translate(" + (this.graphicXOffset + xOffset) + "," + baseLineY + ")", null, null, null);
        this.addPath("calpulse", "fill:none; stroke:black", "3", "M 0 0 H 25 V -100 H 75 V 0 H 100");
        this.util.endElement("g");
    }

    private void addWaveform(WaveformArea area) throws SAXException {
        int lead = area.getWaveformIndex();
        WaveFormChannel channel = this.waveForms.getChannel(lead);
        WaveformScalingInfo scalingInfo = this.prepareScalingInfo(channel, area);
        float topPos = area.getTopY();
        float baseLineY = topPos + area.getHeight() * scalingInfo.getZeroLine();
        if (log.isDebugEnabled()) {
            log.debug((Object)("topPos:" + topPos + ", baseLineY:" + baseLineY + ", scalingInfo:" + scalingInfo));
        }
        channel.reset();
        this.addG("lead" + lead, "translate(" + (this.graphicXOffset + area.getLeftX()) + "," + baseLineY + ")", null, null, null);
        this.addPath("lead" + lead, "fill:none;stroke:" + WF_COLORS[lead % WF_COLORS.length], "5", this.getWaveFormString(channel, area, scalingInfo));
        this.util.endElement("g");
        this.addG("lead" + lead, "translate(" + (this.graphicXOffset + area.getLeftX()) + "," + ((double)topPos + (double)area.getHeight() * 0.5) + ")", null, null, null);
        this.addText("0", "-100", "30", "green", null, channel.getChSource());
        this.addPath("waveseparator", "fill:none;stroke:green", "5", "M 0 -90 L 0 -20 M 0 90 L 0 20 ");
        if (scalingInfo.getYScaleDesc() != null) {
            this.addText("0", "-150", "30", "green", null, scalingInfo.getYScaleDesc());
        }
        if (scalingInfo.getXScaleDesc() != null) {
            this.addText(Float.toString(area.getWidth() - 300.0f), Float.toString(topPos + area.getHeight() - 150.0f), "30", "green", null, scalingInfo.getXScaleDesc());
        }
        this.util.endElement("g");
    }

    private String getWaveFormString(WaveFormChannel channel, WaveformArea area, WaveformScalingInfo scalingInfo) {
        float width = area.getWidth();
        StringBuffer sb = new StringBuffer();
        float xDelta = scalingInfo.getPixPerSec() / this.waveForms.getSampleFreq();
        float yDelta = scalingInfo.getPixPerUnit() * -1.0f;
        int len = this.waveForms.getNrOfSamples();
        if (log.isDebugEnabled()) {
            log.debug((Object)("NrOfSamples:" + len));
        }
        if ((float)len * xDelta > width) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("correction: (len*xdelta):" + (float)len * xDelta + ">" + width));
            }
            len = new Float(width / xDelta).intValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("xDelta:" + xDelta + " --> width/xDelta:" + width / xDelta + " len:" + len));
            }
        }
        sb.append("M 0 0 L ");
        float currX = 0.0f;
        for (int i = 0; i < len; ++i) {
            sb.append(currX).append(" ").append(channel.getValue() * yDelta).append(" ");
            currX += xDelta;
        }
        return sb.toString();
    }

    private WaveformScalingInfo prepareScalingInfo(WaveFormChannel channel, WaveformArea area) {
        float pixPerSec = -1.0f;
        float pixPerUnit = -1.0f;
        float zeroLine = 0.5f;
        String xScaleDesc = null;
        String yScaleDesc = null;
        WaveformScalingInfo scalingInfo = area.getScalingInfo();
        if (scalingInfo != null) {
            float f;
            pixPerSec = scalingInfo.getPixPerSec();
            if (f > 0.0f) {
                float f2;
                pixPerUnit = scalingInfo.getPixPerUnit();
                if (f2 > 0.0f) {
                    channel.applyAreaScaling(scalingInfo.getYScaleDesc());
                    return scalingInfo;
                }
            }
            xScaleDesc = scalingInfo.getXScaleDesc();
            yScaleDesc = scalingInfo.getYScaleDesc();
        }
        if (pixPerSec <= 0.0f) {
            int nrOfSamples = channel.getWaveformGroup().getNrOfSamples();
            pixPerSec = area.getWidth() / (float)nrOfSamples * channel.getWaveformGroup().getSampleFreq();
            xScaleDesc = pixPerSec / 10.0f + "mm/sec";
        }
        if (pixPerUnit <= 0.0f) {
            float[] minmax;
            Integer min = channel.getMinValue();
            Integer max = channel.getMaxValue();
            if (min != null && max != null) {
                float sens = channel.getSensitivity();
                minmax = new float[]{min.floatValue() * sens, max.floatValue() * sens};
            } else {
                minmax = channel.calcMinMax(0, channel.getWaveformGroup().getNrOfSamples());
            }
            float unitRange = minmax[1] - minmax[0];
            if (unitRange == 0.0f) {
                unitRange = 1.0f;
            }
            pixPerUnit = area.getHeight() / unitRange;
            yScaleDesc = channel.getUnit() + " (" + pixPerUnit / 10.0f + "mm/" + channel.getUnit() + ")";
            zeroLine = minmax[0] > 0.0f && minmax[1] > 0.0f ? minmax[1] / unitRange : (minmax[0] < 0.0f && minmax[1] < 0.0f ? minmax[0] / unitRange : (unitRange + minmax[0]) / unitRange);
        }
        scalingInfo = new WaveformScalingInfo(pixPerSec, xScaleDesc, pixPerUnit, yScaleDesc);
        scalingInfo.setZeroLine(zeroLine);
        return scalingInfo;
    }

    private void addText(String x, String y, String fontSize, String fill, Properties props, String text) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "x", x);
        this.util.addAttribute(attr, "y", y);
        this.util.addAttribute(attr, "fill", fill);
        this.util.addAttribute(attr, "font-size", fontSize);
        this.util.addAttributes(attr, props);
        this.util.startElement("text", attr);
        this.util.addValue(text);
        this.util.endElement("text");
    }

    private void addPath(String id, String style, String strokeWidth, String d) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "id", id);
        this.util.addAttribute(attr, "style", style);
        this.util.addAttribute(attr, "d", d);
        this.util.startElement("path", attr);
        this.util.endElement("path");
    }

    private void addG(String id, String transform, String fill, String fontSize, Properties props) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "id", id);
        this.util.addAttribute(attr, "transform", transform);
        this.util.addAttribute(attr, "fill", fill);
        this.util.addAttribute(attr, "fontSize", fontSize);
        this.util.addAttributes(attr, props);
        this.util.startElement("g", attr);
    }

    private void addUse(String xlinkHref, String transform, Properties props) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "xlink:href", xlinkHref);
        this.util.addAttribute(attr, "transform", transform);
        this.util.addAttributes(attr, props);
        this.util.startElement("use", attr);
        this.util.endElement("use");
    }

    protected void addSVGStart() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.util.addAttribute(attr, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.util.addAttribute(attr, "width", this.width);
        this.util.addAttribute(attr, "height", this.height);
        this.util.addAttribute(attr, "viewBox", this.getViewBoxString());
        this.util.addAttribute(attr, "preserveAspectRatio", "xMinYMin splice");
        this.util.startElement("svg", attr);
    }

    private String getViewBoxString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.viewBoxX1).append(" ").append(this.viewBoxY1);
        sb.append(this.viewBoxWidth).append(" ").append(this.viewBoxHeight);
        return null;
    }
}

