/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg.xml;

import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dcm4chex.rid.mbean.ECGSupport;
import org.dcm4chex.rid.mbean.ecg.WaveformGroup;
import org.dcm4chex.rid.mbean.ecg.WaveformInfo;
import org.dcm4chex.rid.mbean.ecg.xml.SVGCreator;
import org.dcm4chex.rid.mbean.xml.XMLResponseObject;
import org.dcm4chex.rid.mbean.xml.XMLUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FOPCreator
implements XMLResponseObject {
    private static final NumberFormat cmFormatter = new DecimalFormat("##.##cm", new DecimalFormatSymbols(new Locale("en", "us")));
    private static Logger log = Logger.getLogger((String)ECGSupport.class.getName());
    private TransformerHandler th;
    private XMLUtil util;
    private Float pageHeight;
    private Float pageWidth;
    private Float graphHeight;
    private Float graphWidth;
    private WaveformGroup[] waveformGroups;
    private WaveformInfo info;

    public FOPCreator(WaveformGroup[] wfgrps, WaveformInfo wfInfo, Float width, Float height) {
        this.waveformGroups = wfgrps;
        this.info = wfInfo;
        this.pageWidth = width;
        this.pageHeight = height;
        this.graphHeight = new Float(this.pageHeight.floatValue() - 4.0f);
        this.graphWidth = new Float(this.pageWidth.floatValue() - 2.0f);
        if (log.isDebugEnabled()) {
            log.debug((Object)("page (h*w):" + this.pageHeight + "*" + this.pageWidth));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("graph (h*w):" + this.graphHeight + "*" + this.graphWidth));
        }
    }

    public void toXML(OutputStream out) throws TransformerConfigurationException, SAXException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.th = tf.newTransformerHandler();
        this.th.getTransformer().setOutputProperty("indent", "yes");
        this.th.setResult(new StreamResult(out));
        this.th.startDocument();
        this.toXML();
        this.th.endDocument();
        try {
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not create XML.", (Throwable)e);
        }
    }

    public void embedXML(TransformerHandler th) throws TransformerConfigurationException, SAXException {
        this.th = th;
        this.toXML();
    }

    private void toXML() throws SAXException, TransformerConfigurationException {
        this.util = new XMLUtil(this.th);
        this.util.startElement("fo:root", "xmlns:fo", "http://www.w3.org/1999/XSL/Format");
        this.addLayoutMasterSet();
        this.util.startElement("fo:page-sequence", "master-reference", "page");
        this.addHeader();
        this.util.startElement("fo:flow", "flow-name", "xsl-region-body");
        int len = this.waveformGroups.length;
        for (int i = 0; i < len; ++i) {
            this.addGraphicHeader(this.waveformGroups[i]);
            this.addGraphic(this.waveformGroups[i]);
            this.addGraphicFooter(this.waveformGroups[i]);
        }
        this.addFooter();
        this.util.endElement("fo:flow");
        this.util.endElement("fo:page-sequence");
        this.util.endElement("fo:root");
    }

    private void addTestPage() throws SAXException {
        this.util.startElement("fo:page-sequence", "master-reference", "test");
        this.util.startElement("fo:flow", "flow-name", "xsl-region-body");
        this.util.startElement("fo:block", XMLUtil.EMPTY_ATTRIBUTES);
        this.util.startElement("fo:instream-foreign-object", "xmlns:svg", "http://www.w3.org/2000/svg");
        SVGCreator creator = new SVGCreator(null, null, this.graphWidth, this.graphHeight);
        creator.setXMLUtil(new XMLUtil(this.th, "svg"));
        creator.addSVGStart();
        creator.addDefs();
        creator.addGrid(this.pageWidth.intValue(), this.pageHeight.intValue());
        this.util.endElement("svg:svg");
        this.util.endElement("fo:instream-foreign-object");
        this.util.endElement("fo:block");
        this.util.endElement("fo:flow");
        this.util.endElement("fo:page-sequence");
    }

    private void addLayoutMasterSet() throws SAXException {
        this.util.startElement("fo:layout-master-set", XMLUtil.EMPTY_ATTRIBUTES);
        AttributesImpl attr = this.util.newAttribute("master-name", "page");
        this.util.addAttribute(attr, "page-height", cmFormatter.format(this.pageHeight));
        this.util.addAttribute(attr, "page-width", cmFormatter.format(this.pageWidth));
        this.util.addAttribute(attr, "margin-left", "5mm");
        this.util.addAttribute(attr, "margin-right", "5mm");
        this.util.addAttribute(attr, "margin-top", "10mm");
        this.util.addAttribute(attr, "margin-bottom", "0mm");
        this.util.startElement("fo:simple-page-master", attr);
        this.util.startElement("fo:region-body", "margin-top", "1cm");
        this.util.endElement("fo:region-body");
        this.util.startElement("fo:region-before", "extent", "1cm");
        this.util.endElement("fo:region-before");
        this.util.startElement("fo:region-after", "extent", "0.5cm");
        this.util.endElement("fo:region-after");
        this.util.endElement("fo:simple-page-master");
        AttributesImpl attr2 = this.util.newAttribute("master-name", "test");
        this.util.addAttribute(attr2, "page-height", cmFormatter.format(this.pageHeight));
        this.util.addAttribute(attr2, "page-width", cmFormatter.format(this.pageWidth));
        this.util.addAttribute(attr2, "margin-left", "0mm");
        this.util.addAttribute(attr2, "margin-right", "0mm");
        this.util.addAttribute(attr2, "margin-top", "0mm");
        this.util.addAttribute(attr2, "margin-bottom", "0mm");
        this.util.startElement("fo:simple-page-master", attr2);
        this.util.startElement("fo:region-body", "margin-top", "0cm");
        this.util.endElement("fo:region-body");
        this.util.startElement("fo:region-before", "extent", "0cm");
        this.util.endElement("fo:region-before");
        this.util.startElement("fo:region-after", "extent", "0cm");
        this.util.endElement("fo:region-after");
        this.util.endElement("fo:simple-page-master");
        this.util.endElement("fo:layout-master-set");
    }

    private void addHeader() throws SAXException {
        this.util.startElement("fo:static-content", "flow-name", "xsl-region-before");
        AttributesImpl attr = this.util.newAttribute("font-size", "12pt");
        this.util.addAttribute(attr, "text-align", "center");
        this.util.addAttribute(attr, "font-weight", "bold");
        this.util.startElement("fo:block", attr);
        this.util.addValue(this.info.getPatientName());
        this.util.endElement("fo:block");
        AttributesImpl attr1 = this.util.newAttribute("font-size", "10pt");
        this.util.addAttribute(attr1, "text-align", "center");
        this.util.startElement("fo:block", attr1);
        this.util.addValue("(" + this.info.getPatientID() + ")");
        this.util.endElement("fo:block");
        this.util.endElement("fo:static-content");
    }

    private void addGraphicHeader(WaveformGroup group) throws SAXException {
        AttributesImpl attr = this.util.newAttribute("font-size", "10pt");
        this.util.startElement("fo:block", attr);
        this.addTable("none", new String[]{"15mm", "40mm", "20mm", "40mm", "15mm", "25mm", "50mm", "20mm", "3mm", "20mm"}, new String[]{"left", "right", "left", "left", "left", "left", "left", "right", "left", "left"}, new String[][]{{"", "Acquis. Date:", this.info.getAcquisDate(), this.info.getAcquisTime(), null, "CONFIRMED", null, "Department:", null, ""}, {null, null, null, null, null, null, null, "Room:", null, ""}, {null, "Birth Date:", this.info.getBirthday(), this.info.getSex(), "0/0", this.info.getPatientSize(), this.info.getPatientWeight(), "Operator:", null, ""}});
        this.util.endElement("fo:block");
    }

    private void addGraphic(WaveformGroup group) throws TransformerConfigurationException, SAXException {
        this.util.startElement("fo:block", XMLUtil.EMPTY_ATTRIBUTES);
        this.util.startElement("fo:instream-foreign-object", "xmlns:svg", "http://www.w3.org/2000/svg");
        SVGCreator creator = new SVGCreator(group, null, this.graphWidth, this.graphHeight);
        creator.embedXML(this.th);
        this.util.endElement("fo:instream-foreign-object");
        this.util.endElement("fo:block");
    }

    private void addGraphicFooter(WaveformGroup group) throws SAXException {
        AttributesImpl attr = this.util.newAttribute("font-size", "10pt");
        this.util.addAttribute(attr, "text-align", "center");
        this.util.startElement("fo:block", attr);
        if (group.getNrOfChannels() == 12) {
            this.util.singleElement("fo:inline", null, "25mm/sec");
            this.util.singleElement("fo:inline", null, "10mm/mV");
        }
        this.util.singleElement("fo:inline", null, group.getFilterText());
        this.util.endElement("fo:block");
    }

    private void addTable(String border, String[] columnWidths, String[] textAligns, String[][] data) throws SAXException {
        AttributesImpl tblAttr = this.util.newAttribute("border-style", border);
        this.util.addAttribute(tblAttr, "table-layout", "fixed");
        this.util.startElement("fo:table", tblAttr);
        AttributesImpl colAttr = this.util.newAttribute("column-number", border);
        for (int i = 0; i < columnWidths.length; ++i) {
            this.util.singleElement("fo:table-column", this.util.newAttribute("column-width", columnWidths[i]), null);
        }
        this.util.startElement("fo:table-body", null);
        int rows = data.length;
        int cols = data[0].length;
        AttributesImpl cellAttr = this.util.newAttribute("border-style", "none");
        for (int row = 0; row < rows; ++row) {
            this.util.startElement("fo:table-row", null);
            for (int col = 0; col < cols; ++col) {
                this.util.startElement("fo:table-cell", cellAttr);
                this.util.singleElement("fo:block", this.util.newAttribute("text-align", textAligns[col]), data[row][col]);
                this.util.endElement("fo:table-cell");
            }
            this.util.endElement("fo:table-row");
        }
        this.util.endElement("fo:table-body");
        this.util.endElement("fo:table");
    }

    private void addFooter() {
    }
}

