/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.dcm4che.data.Dataset;

public class WaveformInfo {
    private Dataset dataset;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");

    public WaveformInfo(Dataset ds) {
        this.dataset = ds;
    }

    public String getPatientName() {
        String s = this.dataset.getString(0x100010);
        return s == null ? "" : s.replace('^', ' ');
    }

    public String getPatientID() {
        String s = this.dataset.getString(0x100020);
        return s == null ? "" : s;
    }

    public String getAcquisTime() {
        Date d = this.dataset.getDate(524330);
        if (d == null) {
            d = this.dataset.getDate(524338);
        }
        if (d == null) {
            return "??:??:??";
        }
        return timeFormatter.format(d);
    }

    public String getAcquisDate() {
        Date d = this.dataset.getDate(524330);
        if (d == null) {
            d = this.dataset.getDate(524322);
        }
        return this.getDateString(d);
    }

    public String getBirthday() {
        Date d = this.dataset.getDate(0x100030);
        return this.getDateString(d);
    }

    public String getSex() {
        String sex = this.dataset.getString(0x100040);
        if (sex != null) {
            if ("M".equalsIgnoreCase(sex)) {
                return "Male";
            }
            if ("F".equalsIgnoreCase(sex)) {
                return "Female";
            }
        }
        return "Other";
    }

    public String getPatientSize() {
        return this.dataset.getFloat(0x101020, 0.0f) * 100.0f + " cm";
    }

    public String getPatientWeight() {
        return this.dataset.getFloat(0x101030, 0.0f) + " kg";
    }

    private String getDateString(Date d) {
        if (d == null) {
            return "????-??-??";
        }
        return dateFormatter.format(d);
    }
}

