/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg;

import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.rid.mbean.ecg.WaveForm16Buffer;
import org.dcm4chex.rid.mbean.ecg.WaveForm8Buffer;
import org.dcm4chex.rid.mbean.ecg.WaveFormBuffer;
import org.dcm4chex.rid.mbean.ecg.WaveFormChannel;

public class WaveformGroup {
    private int grpIndex;
    private int nrOfChannels;
    private int nrOfSamples;
    private int bitsAlloc;
    private float sampleFreq;
    private String muxGrpLabel;
    private String sampleInterpretation;
    private WaveFormChannel[] channels = null;
    private ByteBuffer data = null;
    private String cuid;
    private static Logger log = Logger.getLogger((String)WaveformGroup.class.getName());

    public WaveformGroup(String cuid, DcmElement elem, int grpIndex, float fCorr) {
        this.cuid = cuid;
        if (elem == null) {
            throw new NullPointerException("WaveFormSequence missing!");
        }
        Dataset ds = elem.getItem(grpIndex);
        this.grpIndex = grpIndex;
        this.nrOfChannels = ds.getInt(3801093, 0);
        this.nrOfSamples = ds.getInt(3801104, 0);
        this.sampleFreq = ds.getFloat(3801114, 0.0f);
        this.muxGrpLabel = ds.getString(3801120);
        this.bitsAlloc = ds.getInt(1409290244, 0);
        this.sampleInterpretation = ds.getString(1409290246);
        this.data = ds.getByteBuffer(1409290256);
        if (this.nrOfSamples < 1) {
            int nrOfSamples_recalc = this.data.limit() / this.nrOfChannels;
            if (this.bitsAlloc > 8) {
                nrOfSamples_recalc /= this.bitsAlloc / 8;
            }
            log.warn((Object)("NumberOfWaveformSamples (" + this.nrOfSamples + ") not valid! Recalc with WaveformData:" + nrOfSamples_recalc));
            this.nrOfSamples = nrOfSamples_recalc;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Recalculated NumberOfWaveformSamples is " + this.nrOfSamples + "! ( WaveformData.size:" + this.data.limit() + " nrOfChannels:" + this.nrOfChannels + " bitsAlloc:" + this.bitsAlloc + " )"));
            }
        }
        this.prepareChannels(ds.get(3801600), fCorr);
    }

    public String getCUID() {
        return this.cuid;
    }

    public int getNrOfSamples() {
        return this.nrOfSamples;
    }

    public int getNrOfChannels() {
        return this.nrOfChannels;
    }

    public int getBitsAlloc() {
        return this.bitsAlloc;
    }

    public float getSampleFreq() {
        return this.sampleFreq;
    }

    public WaveFormChannel getChannel(int idx) {
        return this.channels[idx];
    }

    public String getFilterText() {
        if (this.channels[0].getLowFreq() != null) {
            return this.channels[0].getLowFreq() + "-" + this.channels[0].getHighFreq() + " Hz";
        }
        return "No Filter!";
    }

    private void prepareChannels(DcmElement chDefs, float fCorr) {
        int len = chDefs.countItems();
        this.channels = new WaveFormChannel[len];
        for (int i = 0; i < len; ++i) {
            WaveFormChannel ch;
            this.channels[i] = ch = new WaveFormChannel(this, chDefs.getItem(i), this.getWaveFormBuffer(i), fCorr);
        }
    }

    private WaveFormBuffer getWaveFormBuffer(int idx) {
        if (this.bitsAlloc == 8) {
            return new WaveForm8Buffer(this.data, idx, this.nrOfChannels, this.sampleInterpretation);
        }
        if (this.bitsAlloc == 16) {
            return new WaveForm16Buffer(this.data, idx, this.nrOfChannels, this.sampleInterpretation);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("WaveFormGroup(").append(this.grpIndex).append("):").append(this.muxGrpLabel);
        sb.append(" channels:").append(this.nrOfChannels).append(" samples:").append(this.nrOfSamples);
        sb.append(" sampleFreq:").append(this.sampleFreq).append(" channelDefs:").append(this.channels);
        return sb.toString();
    }
}

