/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg;

import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.rid.mbean.ecg.WaveFormBuffer;
import org.dcm4chex.rid.mbean.ecg.WaveformGroup;

public class WaveFormChannel {
    private WaveformGroup wfGrp;
    private int chNr;
    private String chSource;
    private int bitsStored;
    private Integer minValue;
    private Integer maxValue;
    private String label;
    private String status;
    private float sensitivity;
    private float channelSensitivity;
    private String sensitivityUnit;
    private float sensitivityCorrection;
    private float fCorr;
    private float pixPerUnit;
    private WaveFormBuffer buffer;
    private Float lowFreq;
    private Float highFreq;
    private static Logger log = Logger.getLogger((String)WaveFormChannel.class.getName());

    public WaveFormChannel(WaveformGroup grp, Dataset ch, WaveFormBuffer buffer, float fCorr) {
        this.wfGrp = grp;
        this.fCorr = fCorr;
        this.chNr = ch.getInt(3801602, -1);
        this.chSource = ch.get(3801608).getItem().getString(524548);
        try {
            this.bitsStored = ch.getInt(3801626, -1);
        }
        catch (UnsupportedOperationException x) {
            this.bitsStored = ch.getFloat(3801626).intValue();
        }
        this.minValue = ch.getInteger(1409286416);
        this.maxValue = ch.getInteger(1409286418);
        this.label = ch.getString(3801603);
        this.status = ch.getString(3801605);
        this.sensitivity = this.channelSensitivity = ch.getFloat(3801616, 1.0f);
        this.sensitivityCorrection = ch.getFloat(3801618, 1.0f);
        this.sensitivityUnit = this.getSensitivityUnit(ch, "");
        if (fCorr != 1.0f) {
            this.sensitivity *= fCorr;
        }
        this.sensitivity *= this.sensitivityCorrection;
        this.lowFreq = ch.getFloat(3801632);
        this.highFreq = ch.getFloat(3801633);
        this.buffer = buffer;
        if (log.isDebugEnabled()) {
            this.logInfo();
        }
    }

    public WaveformGroup getWaveformGroup() {
        return this.wfGrp;
    }

    private String getSensitivityUnit(Dataset ch, String def) {
        Dataset ds;
        DcmElement sensSeq = ch.get(3801617);
        if (sensSeq != null && (ds = sensSeq.getItem()) != null) {
            if ("UCUM".equals(ds.getString(524546))) {
                return ds.getString(524544);
            }
            return ds.getString(524548);
        }
        return def;
    }

    public String getChSource() {
        return this.chSource;
    }

    public String getLabel() {
        return this.label;
    }

    public Float getLowFreq() {
        return this.lowFreq;
    }

    public Float getHighFreq() {
        return this.highFreq;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public int getRawValue() {
        return this.buffer.getValue();
    }

    public int getRawValue(int sampleNr) {
        return this.buffer.getValue(sampleNr);
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public String getUnit() {
        return this.sensitivityUnit;
    }

    public void reset() {
        this.buffer.reset();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("WaveFormChannel: chNr").append(this.chNr).append(" label:").append(this.label);
        sb.append(" bitsStored:").append(this.bitsStored).append(" min:").append(this.minValue).append(" max:").append(this.maxValue);
        sb.append(" status:").append(this.status);
        return sb.toString();
    }

    private void logInfo() {
        log.debug((Object)("WaveFormchannel: chNr:" + this.chNr));
        log.debug((Object)("   chSource:" + this.chSource));
        log.debug((Object)("   bitsStored:" + this.bitsStored));
        log.debug((Object)("   minValue:" + this.minValue));
        log.debug((Object)("   maxValue:" + this.maxValue));
        log.debug((Object)("   status:" + this.status));
        log.debug((Object)("   lowFreq:" + this.lowFreq));
        log.debug((Object)("   highFreq:" + this.highFreq));
        log.debug((Object)("   sensitivityUnit:" + this.sensitivityUnit));
        log.debug((Object)("   calculated sensitivity:" + this.sensitivity));
        log.debug((Object)("      ChannelSensitivity:" + this.channelSensitivity));
        log.debug((Object)("      sensitivityCorrection:" + this.sensitivityCorrection));
        log.debug((Object)("      fCorr:" + this.fCorr));
        log.debug((Object)("   Buffer:" + this.buffer));
    }

    public float getValue() {
        return (float)this.getRawValue() * this.sensitivity;
    }

    public float[] calcMinMax(int start, int end) {
        int min;
        int max = min = this.buffer.getValue(start);
        for (int i = start + 1; i < end; ++i) {
            int value = this.buffer.getValue(i);
            if (value < min) {
                min = value;
                continue;
            }
            if (value <= max) continue;
            max = value;
        }
        this.buffer.reset();
        return new float[]{(float)min * this.sensitivity, (float)max * this.sensitivity};
    }

    public void applyAreaScaling(String unit) {
        float f2;
        float f1;
        if (this.sensitivityUnit != null && unit != null && !this.sensitivityUnit.equals(unit) && (f1 = this.getUnitFactor(this.sensitivityUnit)) != (f2 = this.getUnitFactor(unit))) {
            this.sensitivity *= f1 / f2;
            log.debug((Object)("Sensitivity corrected! Units: (source:" + this.sensitivityUnit + " area:" + unit + " -> new value:" + this.sensitivity));
        }
    }

    private float getUnitFactor(String unit) {
        if (unit.length() < 2) {
            return 1.0f;
        }
        switch (unit.charAt(0)) {
            case 'u': {
                return 1.0E-6f;
            }
            case 'm': {
                return 0.001f;
            }
            case 'k': {
                return 1000.0f;
            }
            case 'M': {
                return 1000000.0f;
            }
            case 'G': {
                return 1.0E9f;
            }
            case 'n': {
                return 1.0E-9f;
            }
            case 'p': {
                return 1.0E-12f;
            }
            case 'd': {
                return 0.1f;
            }
            case 'c': {
                return 0.01f;
            }
        }
        return 1.0f;
    }
}

