/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean.ecg;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.dcm4chex.rid.mbean.ecg.WaveFormBuffer;

public class WaveForm16Buffer
implements WaveFormBuffer {
    ShortBuffer buffer;
    int leadNr;
    int nrOfLeads;
    int offset = 0;
    String sampleIterpretation;

    public WaveForm16Buffer(ByteBuffer bBuf, int leadNr, int nrOfLeads, String sampleIterpretation) {
        this.buffer = bBuf.asShortBuffer();
        this.leadNr = leadNr;
        this.nrOfLeads = nrOfLeads;
        this.offset = leadNr;
        this.sampleIterpretation = sampleIterpretation;
    }

    public int getValue() {
        short v = this.buffer.get(this.offset);
        this.offset += this.nrOfLeads;
        return v;
    }

    public int getValue(int sampleNr) {
        this.offset = sampleNr * this.nrOfLeads + this.leadNr;
        return this.getValue();
    }

    public void reset() {
        this.offset = this.leadNr;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("WaveForm8Buffer:").append(this.leadNr).append(" of ").append(this.nrOfLeads);
        sb.append(" leads, sampleIterpretation:").append(this.sampleIterpretation).append("buffersize:").append(this.buffer.limit());
        return sb.toString();
    }
}

