/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.FinderException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.PersonName;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.util.ISO8601DateFormat;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.DataExportMessage;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4chee.docstore.Availability;
import org.dcm4chee.docstore.BaseDocument;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.jdbc.RetrieveStudyDatesCmd;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileDataSource;
import org.dcm4chex.archive.util.HomeFactoryException;
import org.dcm4chex.rid.common.RIDRequestObject;
import org.dcm4chex.rid.common.RIDResponseObject;
import org.dcm4chex.rid.mbean.BasicRIDResponseObject;
import org.dcm4chex.rid.mbean.ConceptNameCodeConfig;
import org.dcm4chex.rid.mbean.ECGSupport;
import org.dcm4chex.rid.mbean.RIDService;
import org.dcm4chex.rid.mbean.RIDStorageDelegate;
import org.dcm4chex.rid.mbean.RIDStreamResponseObjectImpl;
import org.dcm4chex.rid.mbean.RIDTransformResponseObjectImpl;
import org.dcm4chex.rid.mbean.xml.IHEDocumentList;
import org.jboss.mx.util.MBeanServerLocator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIDSupport {
    private static final String CARDIOLOGY = "Cardiology";
    private static final String RADIOLOGY = "Radiology";
    private static final String ENCAPSED_PDF_CARDIOLOGY = "encapsed_PDF_Cardiology";
    private static final String ENCAPSED_PDF_RADIOLOGY = "encapsed_PDF_Radiology";
    public static final String ENCAPSED_PDF_ECG = "encapsed_PDF_ECG";
    public static final String SUMMARY = "SUMMARY";
    public static final String SUMMARY_RADIOLOGY = "SUMMARY-RADIOLOGY";
    public static final String SUMMARY_CARDIOLOGY = "SUMMARY-CARDIOLOGY";
    public static final String SUMMARY_CARDIOLOGY_ECG = "SUMMARY-CARDIOLOGY-ECG";
    public static final String SUMMARY_LABORATORY = "SUMMARY-LABORATORY";
    public static final String SUMMARY_SURGERY = "SUMMARY-SURGERY";
    public static final String SUMMARY_EMERGENCY = "SUMMARY-EMERGENCY";
    public static final String SUMMARY_DISCHARGE = "SUMMARY-DISCHARGE";
    public static final String SUMMARY_ICU = "SUMMARY-ICU";
    public static final String SUMMARY_RX = "SUMMARY-RX";
    public static final String CONTENT_TYPE_XHTML = "text/xhtml";
    public static final String CONTENT_TYPE_XML = "text/xml";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_JPEG = "image/jpeg";
    public static final String CONTENT_TYPE_PDF = "application/pdf";
    public static final String CONTENT_TYPE_DICOM = "application/dicom";
    public static final String CUID_GRP_SR = "SR";
    public static final String CUID_GRP_ECG = "ECG";
    public static final String CUID_GRP_DOC = "DOC";
    private static Logger log = Logger.getLogger((String)RIDSupport.class.getName());
    private static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    private static final String FOBSR_XSL_URI = "fobsr.xsl";
    private final FopFactory fopFactory = FopFactory.newInstance();
    private static MBeanServer server;
    private Map<String, String> ecgSopCuids = new TreeMap<String, String>();
    private Map<String, String> srSopCuids = new TreeMap<String, String>();
    private Map<String, String> docSopCuids = new TreeMap<String, String>();
    private Map<String, String> cuidsForSummaryAll;
    private Map<String, Map<String, String>> sopCuidGroups = new HashMap<String, Map<String, String>>();
    private Map<String, String> docTitlePatterns;
    private Map<String, String> summaryTitles;
    private String ridSummaryXsl;
    private boolean useXSLInstruction;
    private String wadoURL;
    private ObjectName queryRetrieveScpName;
    private ObjectName auditLogName;
    private ECGSupport ecgSupport = null;
    private Dataset patientDS = null;
    private RIDService service;
    private ConceptNameCodeConfig conceptNameCodeConfig = new ConceptNameCodeConfig();
    private boolean useOrigFile = false;
    private RIDStorageDelegate storage;
    private String srImageRows;
    private String codeCfgString;
    private static final DcmObjectFactory dof;

    public RIDSupport(RIDService service) {
        this.service = service;
        server = service.getServer();
        if (server == null) {
            server = MBeanServerLocator.locate();
        }
    }

    private ECGSupport getECGSupport() {
        if (this.ecgSupport == null) {
            this.ecgSupport = new ECGSupport(this);
        }
        return this.ecgSupport;
    }

    public ConceptNameCodeConfig getConceptNameCodeConfig() {
        return this.conceptNameCodeConfig;
    }

    public Map<String, String> getDocTitlePatterns() {
        return this.docTitlePatterns;
    }

    public void setDocTitlePatterns(Map<String, String> docTitlePatterns) {
        this.docTitlePatterns = docTitlePatterns;
    }

    public Map getECGSopCuids() {
        if (this.ecgSopCuids == null) {
            this.setDefaultECGSopCuids();
        }
        return this.ecgSopCuids;
    }

    public void setECGSopCuids(Map sopCuids) {
        if (sopCuids != null && !sopCuids.isEmpty()) {
            this.ecgSopCuids = sopCuids;
        } else {
            this.setDefaultECGSopCuids();
        }
        this.sopCuidGroups.put(CUID_GRP_ECG, this.ecgSopCuids);
    }

    private InstanceLocal getInstanceLocalByIUID(String instUid) throws HomeFactoryException, FinderException, IOException, NamingException {
        Properties jndiProps = this.getJndiProperties();
        InitialContext ctx = new InitialContext(jndiProps);
        InstanceLocalHome ih = (InstanceLocalHome)PortableRemoteObject.narrow((Object)ctx.lookup("ejb/Instance"), InstanceLocalHome.class);
        InstanceLocal inst = ih.findBySopIuid(instUid);
        return inst;
    }

    private Properties getJndiProperties() throws IOException {
        Properties jndiProps = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        jndiProps.load(cl.getResourceAsStream("ejb-jndi.properties"));
        return jndiProps;
    }

    private void setDefaultECGSopCuids() {
        this.ecgSopCuids.clear();
        this.ecgSopCuids.put("TwelveLeadECGWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.1.1");
        this.ecgSopCuids.put("GeneralECGWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.1.2");
        this.ecgSopCuids.put("AmbulatoryECGWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.1.3");
        this.ecgSopCuids.put("HemodynamicWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.2.1");
        this.ecgSopCuids.put("CardiacElectrophysiologyWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.3.1");
    }

    public Map getSRSopCuids() {
        return this.srSopCuids;
    }

    public void setSRSopCuids(Map cuids) {
        if (cuids != null && !cuids.isEmpty()) {
            this.srSopCuids = cuids;
            this.sopCuidGroups.put(CUID_GRP_SR, this.srSopCuids);
        }
    }

    public Map<String, String> getEncapsulatedDocumentSopCuids() {
        return this.docSopCuids;
    }

    public void setEncapsulatedDocumentSopCuids(Map<String, String> cuids) {
        if (cuids == null) {
            this.docSopCuids.clear();
        } else {
            this.docSopCuids = cuids;
        }
        this.sopCuidGroups.put(CUID_GRP_DOC, this.docSopCuids);
    }

    public Map<String, Map<String, String>> getSopCuidGroups() {
        return this.sopCuidGroups;
    }

    public void updateSopCuidGroups(Map<String, Map<String, String>> grps) {
        this.sopCuidGroups.putAll(grps);
    }

    public Map<String, String> getCuidsForSummaryAll() {
        return this.cuidsForSummaryAll;
    }

    public void setCuidsForSummaryAll(Map<String, String> cuidsForSummaryAll) {
        this.cuidsForSummaryAll = cuidsForSummaryAll;
    }

    public Map<String, String> getSummaryTitles() {
        if (this.summaryTitles == null) {
            this.setDefaultSummaryTitles();
        }
        return this.summaryTitles;
    }

    public void setSummaryTitles(Map<String, String> summaryTitles) {
        this.summaryTitles = summaryTitles;
    }

    public String getWadoURL() {
        return this.wadoURL;
    }

    public void setWadoURL(String wadoURL) {
        this.wadoURL = wadoURL;
    }

    public String getRIDSummaryXsl() {
        return this.ridSummaryXsl;
    }

    public void setRIDSummaryXsl(String ridSummaryXsl) {
        this.ridSummaryXsl = ridSummaryXsl;
    }

    public boolean isUseXSLInstruction() {
        return this.useXSLInstruction;
    }

    public void setUseXSLInstruction(boolean useXSLInstruction) {
        this.useXSLInstruction = useXSLInstruction;
    }

    public boolean isUseOrigFile() {
        return this.useOrigFile;
    }

    public void setUseOrigFile(boolean useOrigFile) {
        this.useOrigFile = useOrigFile;
    }

    public String getSrImageRows() {
        return this.srImageRows;
    }

    public void setSrImageRows(String srImageRows) {
        if (srImageRows != null) {
            Integer.parseInt(srImageRows);
        }
        this.srImageRows = srImageRows;
    }

    public ObjectName getQueryRetrieveScpName() {
        return this.queryRetrieveScpName;
    }

    public void setQueryRetrieveScpName(ObjectName name) {
        this.queryRetrieveScpName = name;
    }

    protected MBeanServer getMBeanServer() {
        return server;
    }

    public void setAuditLoggerName(ObjectName name) {
        this.auditLogName = name;
    }

    public ObjectName getAuditLoggerName() {
        return this.auditLogName;
    }

    public RIDResponseObject getRIDSummary(RIDRequestObject reqObj) throws SQLException, IOException, TransformerConfigurationException, SAXException {
        String contentType = this.checkContentType(reqObj, new String[]{CONTENT_TYPE_HTML, CONTENT_TYPE_XML});
        if (contentType == null) {
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 406, "Client doesnt support text/xml, text/html or text/xhtml !");
        }
        String reqType = reqObj.getRequestType();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Summary request type:" + reqObj.getRequestType()));
        }
        String[] pat = this.splitPatID(reqObj.getParam("patientID"));
        Dataset patDS = null;
        try {
            patDS = this.getContentManager().getPatientByID(pat[0], pat[1]);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (patDS == null) {
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 404, "Patient with patientID=" + reqObj.getParam("patientID") + " not found!");
        }
        IHEDocumentList docList = new IHEDocumentList();
        this.initDocList(docList, reqObj, patDS);
        try {
            String pattern;
            Map<String, List<Dataset>> conceptNames = this.conceptNameCodeConfig.getConceptNameCodes(reqType);
            if (conceptNames == null) {
                log.warn((Object)("No conceptCodeNames for info request type!:" + reqType));
            } else {
                this.fillDocList(pat[0], pat[1], docList, conceptNames);
            }
            if (this.useXSLInstruction) {
                docList.setXslFile(this.ridSummaryXsl);
            }
            if (SUMMARY_CARDIOLOGY_ECG.equals(reqType)) {
                this.fillDocListWithCuids(pat[0], pat[1], docList, this.ecgSopCuids, null);
                return new RIDTransformResponseObjectImpl(docList, CONTENT_TYPE_XML, 200, null);
            }
            if (SUMMARY.equals(reqType) && this.cuidsForSummaryAll != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add SOP Class UIDs for SUMMARY (all):" + this.cuidsForSummaryAll.keySet()));
                }
                this.fillDocListWithCuids(pat[0], pat[1], docList, this.cuidsForSummaryAll, null);
            }
            if (this.docTitlePatterns != null && (pattern = this.docTitlePatterns.get(ConceptNameCodeConfig.getSummaryID(reqType))) != null) {
                this.fillDocListWithCuids(pat[0], pat[1], docList, this.docSopCuids, pattern);
            }
            if (docList.size() < 1) {
                log.info((Object)"No documents found: patientDS:");
                log.info((Object)this.patientDS);
                if (this.patientDS != null) {
                    PersonName pn = this.patientDS.getPersonName(0x100010);
                    if (pn != null) {
                        log.info((Object)("family:" + pn.get(0)));
                        log.info((Object)("givenName:" + pn.get(1)));
                    }
                    docList.setQueryDS(this.patientDS);
                }
            }
            if (!contentType.equals(CONTENT_TYPE_XML)) {
                docList.setXslt(this.ridSummaryXsl);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ContentType:" + contentType));
            }
            return new RIDTransformResponseObjectImpl(docList, contentType, 200, null);
        }
        catch (Exception x) {
            log.error((Object)"Building RID Summary failed!", (Throwable)x);
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 500, "Creation of Summary failed! Reason:" + x.getMessage());
        }
    }

    protected String checkContentType(RIDRequestObject reqObj, String[] types) {
        List allowed = reqObj.getAllowedContentTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" check against:" + allowed));
        }
        if (allowed == null) {
            log.debug((Object)("No accept header field! use content type:" + types[0]));
            return types[0];
        }
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            String s = types[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)(" check " + s + ":" + allowed.contains(s) + " ," + s.substring(0, s.indexOf("/")) + "/*: " + allowed.contains(s.substring(0, s.indexOf("/")) + "/*")));
            }
            if (!allowed.contains(s) && !allowed.contains(s.substring(0, s.indexOf("/")) + "/*")) continue;
            return s;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" check */*:" + allowed.contains("*/*")));
        }
        if (allowed.contains("*/*")) {
            return types[0];
        }
        return null;
    }

    private void initDocList(IHEDocumentList docList, RIDRequestObject reqObj, Dataset patDS) {
        Date udt;
        Date ldt;
        String reqURL = reqObj.getRequestURL();
        docList.setReqURL(reqURL);
        docList.setDocSopCuids(this.docSopCuids.values());
        int pos = reqURL.indexOf(63);
        if (pos != -1) {
            reqURL = reqURL.substring(0, pos);
        }
        docList.setDocRIDUrl(reqURL.substring(0, reqURL.lastIndexOf("/")));
        docList.setQueryDS(patDS);
        String docCode = reqObj.getRequestType();
        docList.setDocCode(docCode);
        docList.setDocDisplayName(this.getSummaryTitles().get(ConceptNameCodeConfig.getSummaryID(docCode)));
        String mrr = reqObj.getParam("mostRecentResults");
        if (mrr != null) {
            docList.setMostRecentResults(Integer.parseInt(mrr));
        }
        if ((ldt = RIDSupport.toDate(reqObj.getParam("lowerDateTime"))) != null) {
            docList.setLowerDateTime(ldt);
        }
        if ((udt = RIDSupport.toDate(reqObj.getParam("upperDateTime"))) != null) {
            docList.setUpperDateTime(udt);
        }
    }

    private void setDefaultSummaryTitles() {
        this.summaryTitles = new HashMap<String, String>();
        this.summaryTitles.put("A", "List of all reports");
        this.summaryTitles.put("R", "List of radiology reports");
        this.summaryTitles.put("C", "List of cardiology reports");
        this.summaryTitles.put(CUID_GRP_ECG, "List of ECG");
        this.summaryTitles.put("L", "List of laboratory reports");
        this.summaryTitles.put("S", "List of surgery reports");
        this.summaryTitles.put("E", "List of emergency reports");
        this.summaryTitles.put("D", "List of discharge reports");
        this.summaryTitles.put("I", "List of intensive care reports");
        this.summaryTitles.put("P", "List of prescription reports");
    }

    private void fillDocList(String pid, String issuer, IHEDocumentList docList, Map<String, List<Dataset>> conceptCodes) throws RemoteException, FinderException, Exception {
        Collection<String> cuids = null;
        HashSet<String> allCuids = null;
        for (Map.Entry<String, List<Dataset>> entry : conceptCodes.entrySet()) {
            if (entry.getKey() == null) {
                if (allCuids == null) {
                    allCuids = new HashSet<String>();
                    for (Map<String, String> map : this.sopCuidGroups.values()) {
                        allCuids.addAll(map.values());
                    }
                }
                cuids = allCuids;
            } else {
                Map<String, String> map = this.sopCuidGroups.get(entry.getKey());
                if (map == null || map.isEmpty()) {
                    log.warn((Object)("SOPClassUID Group not defined or empty! cuidGrpId:" + entry.getKey()));
                    continue;
                }
                cuids = map.values();
            }
            List docs = this.getContentManager().listInstanceInfosByPatientAndSRCode(pid, issuer, entry.getValue(), cuids);
            Iterator iter = docs.iterator();
            while (iter.hasNext()) {
                docList.add((Dataset)iter.next());
            }
        }
    }

    private void fillDocListWithCuids(String pid, String issuer, IHEDocumentList docList, Map<String, String> cuids, String docTitlePattern) throws RemoteException, FinderException, Exception {
        List docs = this.getContentManager().listInstanceInfosByPatientAndSRCode(pid, issuer, null, cuids.values());
        for (Dataset ds : docs) {
            if (docTitlePattern == null) {
                docList.add(ds);
                continue;
            }
            String code = ds.getString(4325392);
            if (code == null || !code.matches(docTitlePattern)) continue;
            docList.add(ds);
        }
    }

    static Date toDate(String dt) {
        if (dt == null || dt.length() == 0) {
            return null;
        }
        try {
            return new ISO8601DateFormat().parse(dt);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public RIDResponseObject getRIDDocument(RIDRequestObject reqObj) {
        String uid = reqObj.getParam("documentUID");
        try {
            Dataset ds = this.getDicomObjectForDocument(uid);
            if (ds != null) {
                RIDResponseObject response;
                log.debug((Object)"Found Dataset:");
                log.debug((Object)ds);
                String cuid = ds.getString(524310);
                if (this.getECGSopCuids().values().contains(cuid)) {
                    response = this.getECGSupport().getECGDocument(reqObj, ds);
                } else if (this.getEncapsulatedDocumentSopCuids().values().contains(cuid)) {
                    response = this.getEncapsulatedDocument(reqObj);
                    this.logExport(reqObj, ds, "XDS Document Retrieve");
                } else {
                    response = this.getDocument(reqObj);
                }
                this.logExport(reqObj, ds, "RID Request");
                return response;
            }
            BaseDocument doc = this.retrieveDocument(uid, reqObj.getParam("preferredContentType"));
            if (doc != null && doc.getAvailability().compareTo(Availability.UNAVAILABLE) < 0) {
                return new RIDStreamResponseObjectImpl(doc.getInputStream(), reqObj.getParam("preferredContentType"), 200, null);
            }
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 404, "Object with documentUID=" + uid + " not found!");
        }
        catch (Exception x) {
            log.error((Object)"Cant get RIDDocument:", (Throwable)x);
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 500, "Cant get Document! Reason: unexpected error:" + x.getMessage());
        }
    }

    private Dataset getDicomObjectForDocument(String uid) throws FinderException, RemoteException, Exception {
        List instances = this.getContentManager().listInstanceInfos(new String[]{uid}, false);
        return instances.isEmpty() ? null : (Dataset)instances.get(0);
    }

    private void logExport(RIDRequestObject reqObj, Dataset ds, String mediaType) {
        try {
            HttpUserInfo userInfo = new HttpUserInfo(reqObj.getRequest(), AuditMessage.isEnableDNSLookups());
            String user = userInfo.getUserId();
            String host = userInfo.getHostName();
            DataExportMessage msg = new DataExportMessage();
            msg.setOutcomeIndicator(AuditEvent.OutcomeIndicator.SUCCESS);
            msg.addExporterProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), false, AuditMessage.getLocalHostName());
            msg.addDataRepository(reqObj.getRequest().getRequestURL().toString());
            msg.addDestinationMedia(host, null, mediaType, user == null, host);
            if (user != null) {
                ActiveParticipant ap = ActiveParticipant.createActivePerson((String)user, null, (String)user, null, (boolean)true);
                msg.addActiveParticipant(ap);
            }
            msg.addPatient(ds.getString(0x100020), ds.getString(0x100010));
            ParticipantObjectDescription desc = new ParticipantObjectDescription();
            ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(ds.getString(524310));
            sopClass.setNumberOfInstances(1);
            desc.addSOPClass(sopClass);
            msg.addStudy(ds.getString(0x20000D), desc);
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    private Dataset getXDSPatientInfo(RIDRequestObject reqObj, InputStream is) {
        String pct = reqObj.getParam("preferredContentType");
        Dataset ds = dof.newDataset();
        if (CONTENT_TYPE_DICOM.equals(pct)) {
            try {
                DataInputStream dis = new DataInputStream(is);
                DcmParser parser = DcmParserFactory.getInstance().newDcmParser((InputStream)dis);
                parser.setDcmHandler(ds.getDcmHandler());
                parser.parseDcmFile(FileFormat.DICOM_FILE, -1);
                log.debug((Object)"parsed Dicom File ds:");
                log.debug((Object)ds);
                return ds;
            }
            catch (Exception x) {
                log.error((Object)"Cant parse dicom stream to get XDSPatientInfo!", (Throwable)x);
            }
        }
        log.debug((Object)"Not a Dicom file! try to get patient infos!");
        if (!ds.containsValue(0x20000D)) {
            ds.putUI(0x20000D);
        }
        if (!ds.containsValue(0x100020)) {
            ds.putLO(0x100020, "UNKNOWN");
        }
        if (!ds.containsValue(0x100010)) {
            ds.putPN(0x100010, "UNKNOWN");
        }
        return ds;
    }

    public BaseDocument retrieveDocument(String objectUID, String contentType) throws IOException {
        BaseDocument doc = this.getStorage().getDocument(objectUID, contentType);
        return doc;
    }

    public BaseDocument getOrCreateDocument(String objectUID, String contentType) throws IOException {
        BaseDocument doc = this.getStorage().getDocument(objectUID, contentType);
        return doc != null ? doc : this.getStorage().createDocument(objectUID, contentType);
    }

    private RIDResponseObject getDocument(RIDRequestObject reqObj) throws Exception {
        String contentType;
        String docUID = reqObj.getParam("documentUID");
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Document UID:" + docUID));
        }
        if ((contentType = reqObj.getParam("preferredContentType")) == null) {
            contentType = CONTENT_TYPE_PDF;
        } else if (contentType.equals(CONTENT_TYPE_JPEG)) {
            if (this.checkContentType(reqObj, new String[]{CONTENT_TYPE_JPEG}) == null) {
                return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 400, "Display actor doesnt accept preferred content type!");
            }
            RIDResponseObject resp = this.handleJPEG(reqObj);
            if (resp != null) {
                return resp;
            }
            contentType = CONTENT_TYPE_PDF;
        } else if (!contentType.equals(CONTENT_TYPE_PDF) && this.getEncapsulatedDocumentSopCuids().isEmpty()) {
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 406, "preferredContentType '" + contentType + "' is not supported! Only 'application/pdf' and 'image/jpeg' are supported !");
        }
        if (this.checkContentType(reqObj, new String[]{CONTENT_TYPE_PDF}) == null) {
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 400, "Display actor doesnt accept preferred content type!");
        }
        BaseDocument doc = this.getStorage().getDocument(docUID, contentType);
        OutputStream out = null;
        try {
            if (doc == null) {
                doc = this.getStorage().createDocument(docUID, contentType);
                File inFile = this.getDICOMFile(docUID);
                if (inFile == null) {
                    this.getStorage().removeDocument(docUID);
                    return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 404, "Object with documentUID=" + docUID + "not found!");
                }
                out = doc.getOutputStream();
                if (!this.useOrigFile) {
                    FileDataSource ds = null;
                    try {
                        ds = (FileDataSource)server.invoke(this.queryRetrieveScpName, "getDatasourceOfInstance", new Object[]{docUID}, new String[]{String.class.getName()});
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to get updated DICOM file", (Throwable)e);
                        return new RIDStreamResponseObjectImpl(null, contentType, 500, "Unexpected error! Cant get updated dicom object");
                    }
                    File tmpFile = File.createTempFile("coerced", "dcm");
                    tmpFile.deleteOnExit();
                    log.debug((Object)("Temporary coerced dicom file:" + tmpFile));
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
                    ds.setWriteFile(true);
                    ds.writeTo((OutputStream)os, null);
                    ((OutputStream)os).close();
                    this.renderSRFile(new FileInputStream(tmpFile), out);
                    tmpFile.delete();
                } else {
                    this.renderSRFile(new FileInputStream(inFile), out);
                }
                out.close();
            }
            InputStream in = doc.getInputStream();
            return new RIDStreamResponseObjectImpl(in, in.available(), contentType, 200, null);
        }
        catch (Exception x) {
            log.error((Object)("Cant get document! docUID:" + docUID), (Throwable)x);
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            this.getStorage().removeDocument(docUID);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOutdated(File outFile, String docUID) {
        Date fileDate = new Date(outFile.lastModified());
        Dataset dsQ = factory.newDataset();
        dsQ.putUI(524312, docUID);
        dsQ.putCS(524370, "IMAGE");
        RetrieveStudyDatesCmd cmd = null;
        try {
            cmd = RetrieveStudyDatesCmd.create((Dataset)dsQ);
            Date[] dates = cmd.getUpdatedTimes(1);
            if (dates != null) {
                boolean bl = dates[0].after(fileDate) || dates[3].after(fileDate);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.error((Object)("Cant get Study date/times! mark " + outFile + " as outdated!"), (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (cmd != null) {
                cmd.close();
            }
        }
    }

    private RIDResponseObject handleJPEG(RIDRequestObject reqObj) throws Exception {
        String instUid = reqObj.getParam("documentUID");
        InstanceLocal inst = this.getInstanceLocalByIUID(instUid);
        SeriesLocal series = inst.getSeries();
        StudyLocal study = series.getStudy();
        String url = this.wadoURL + "?requestType=WADO&contentType=image/jpeg&" + "studyUID=" + study.getStudyIuid() + "&seriesUID=" + series.getSeriesIuid() + "&objectUID=" + instUid;
        return new BasicRIDResponseObject("text/plain", 307, url){

            public void execute(OutputStream out) throws TransformerConfigurationException, SAXException, IOException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    private void renderSRFile(InputStream input, OutputStream out) throws IOException, TransformerException, FOPException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(input));
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        Fop fop = this.newFop(CONTENT_TYPE_PDF, out);
        Templates template = this.service.getTemplate(FOBSR_XSL_URI);
        TransformerHandler th = tf.newTransformerHandler(template);
        if (this.srImageRows != null) {
            Transformer t = th.getTransformer();
            t.setParameter("srImageRows", this.srImageRows);
        }
        th.getTransformer().setParameter("wadoURL", this.wadoURL);
        th.setResult(new SAXResult(fop.getDefaultHandler()));
        DcmParser parser = DcmParserFactory.getInstance().newDcmParser((InputStream)in);
        parser.setSAXHandler2((ContentHandler)th, DictionaryFactory.getInstance().getDefaultTagDictionary(), null, 4000, null);
        parser.parseDcmFile(null, -1);
    }

    public Fop newFop(String mime, OutputStream out) throws FOPException {
        return this.fopFactory.newFop(mime, out);
    }

    public File getDICOMFile(String instanceUID) throws IOException {
        Object dicomObject = null;
        try {
            dicomObject = server.invoke(this.queryRetrieveScpName, "locateInstance", new Object[]{instanceUID}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            log.error((Object)"Failed to get DICOM file", (Throwable)e);
        }
        if (dicomObject == null) {
            return null;
        }
        if (dicomObject instanceof File) {
            return (File)dicomObject;
        }
        if (dicomObject instanceof String) {
            log.info((Object)("Requested DICOM file is not local! You can retrieve it from:" + dicomObject));
        }
        return null;
    }

    private RIDResponseObject getEncapsulatedDocument(RIDRequestObject reqObj) {
        try {
            FileDataSource fds = (FileDataSource)server.invoke(this.queryRetrieveScpName, "getDatasourceOfInstance", new Object[]{reqObj.getParam("documentUID")}, new String[]{String.class.getName()});
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(fds.getFile()));
            Dataset ds = fds.getMergeAttrs();
            String mime = ds.getString(4325394);
            if (mime == null) {
                mime = "application.octet-stream";
            }
            log.debug((Object)("Mime type of encapsulated document:" + mime));
            if (this.checkContentType(reqObj, new String[]{mime}) == null) {
                return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 400, "The Display actor doesnt accept mime type of requested document:" + mime + "!");
            }
            DataInputStream dis = new DataInputStream(is);
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser((InputStream)dis);
            Dataset attrs = dof.newDataset();
            parser.setDcmHandler(attrs.getDcmHandler());
            parser.parseDcmFile(null, 4325393);
            long len = parser.getReadLength();
            log.debug((Object)("read length of encapsulated document:" + len));
            return new RIDStreamResponseObjectImpl(is, len, mime, 200, null);
        }
        catch (Exception x) {
            log.error((Object)"Error getting encapsulated PDF!", (Throwable)x);
            return new RIDStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 500, "Cant get encapsulated PDF document! Reason:" + x.getMessage());
        }
    }

    private String[] splitPatID(String patientID) {
        String[] sa = StringUtils.split((String)patientID, (char)'^');
        String[] pat = new String[]{sa[0], null};
        if (sa.length > 3 && sa[3] != null && sa[3].trim().length() > 0) {
            pat[1] = sa[3];
        }
        return pat;
    }

    public float getWaveformCorrection() {
        return this.service.getWaveformCorrection();
    }

    public void setConceptNameCodes(String cfg) {
        this.conceptNameCodeConfig.setConceptNameCodes(cfg);
        this.codeCfgString = cfg;
    }

    public String getConceptNameCodes() {
        return this.conceptNameCodeConfig.getConceptNameCodes();
    }

    private ContentManager getContentManager() throws Exception {
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        return home.create();
    }

    public File getDICOMFile(String string, String string2, String iuid) {
        return null;
    }

    public RIDStorageDelegate getStorage() {
        if (this.storage == null) {
            this.storage = RIDStorageDelegate.getInstance();
        }
        return this.storage;
    }

    static {
        dof = DcmObjectFactory.getInstance();
    }
}

