/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.log4j.Logger;
import org.dcm4chex.rid.mbean.BasicRIDResponseObject;
import org.xml.sax.SAXException;

public class RIDStreamResponseObjectImpl
extends BasicRIDResponseObject {
    private InputStream stream;
    private static final int BUF_LEN = 65536;
    private long maxLen = -1L;
    private static Logger log = Logger.getLogger((String)RIDStreamResponseObjectImpl.class.getName());

    public RIDStreamResponseObjectImpl(InputStream is, String contentType, int retCode, String errMsg) {
        super(contentType, retCode, errMsg);
        this.stream = is;
    }

    public RIDStreamResponseObjectImpl(InputStream is, long maxLen, String contentType, int retCode, String errMsg) {
        this(is, contentType, retCode, errMsg);
        this.maxLen = maxLen;
    }

    public long length() {
        return this.maxLen;
    }

    public void execute(OutputStream out) throws TransformerConfigurationException, SAXException, IOException {
        if (this.stream != null) {
            InputStream in = this.stream instanceof BufferedInputStream ? this.stream : new BufferedInputStream(this.stream, 65536);
            byte[] buf = new byte[65536];
            long remain = this.maxLen;
            boolean checkLen = this.maxLen > 0L;
            try {
                int len = in.read(buf);
                while (len > 0) {
                    if (checkLen && (long)len > remain) {
                        int idx = len = (int)remain;
                        if (buf[--idx] == 0) {
                            log.debug((Object)"PADDING! chang 0x0 to ' '!");
                            buf[idx] = 32;
                        }
                        out.write(buf, 0, len);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("write last " + len + " bytes!"));
                        }
                        break;
                    }
                    remain -= (long)len;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("write junk of " + len + " bytes!"));
                    }
                    out.write(buf, 0, len);
                    len = in.read(buf);
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                in.close();
                log.info((Object)"InputSTream closed!");
            }
        }
    }
}

