/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.management.ObjectName;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che.dict.UIDs;
import org.dcm4chex.archive.mbean.TemplatesDelegate;
import org.dcm4chex.rid.common.RIDRequestObject;
import org.dcm4chex.rid.common.RIDResponseObject;
import org.dcm4chex.rid.mbean.RIDSupport;
import org.jboss.system.ServiceMBeanSupport;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIDService
extends ServiceMBeanSupport {
    private static final String NONE = "NONE";
    private RIDSupport support = new RIDSupport(this);
    private float waveformCorrection = 1.0f;
    private TemplatesDelegate templates = new TemplatesDelegate((ServiceMBeanSupport)this);

    public float getWaveformCorrection() {
        return this.waveformCorrection;
    }

    public void setWaveformCorrection(float waveformCorrection) {
        this.waveformCorrection = waveformCorrection;
    }

    public String getWadoURL() {
        return this.support.getWadoURL();
    }

    public void setWadoURL(String wadoURL) {
        this.support.setWadoURL(wadoURL);
    }

    public final String getConfigDir() {
        return this.templates.getConfigDir();
    }

    public final void setConfigDir(String path) {
        this.templates.setConfigDir(path);
    }

    public final ObjectName getTemplatesServiceName() {
        return this.templates.getTemplatesServiceName();
    }

    public final void setTemplatesServiceName(ObjectName serviceName) {
        this.templates.setTemplatesServiceName(serviceName);
    }

    public String getRIDSummaryXsl() {
        String s = this.support.getRIDSummaryXsl();
        if (s == null) {
            s = "";
        }
        return s;
    }

    public void setRIDSummaryXsl(String xslFile) {
        if (xslFile != null && xslFile.trim().length() < 1) {
            xslFile = null;
        }
        this.support.setRIDSummaryXsl(xslFile);
    }

    public boolean isUseXSLInstruction() {
        return this.support.isUseXSLInstruction();
    }

    public void setUseXSLInstruction(boolean useXSLInstruction) {
        this.support.setUseXSLInstruction(useXSLInstruction);
    }

    public boolean isUseOrigFile() {
        return this.support.isUseOrigFile();
    }

    public void setUseOrigFile(boolean useOrigFile) {
        this.support.setUseOrigFile(useOrigFile);
    }

    public String getSrImageRows() {
        String rows = this.support.getSrImageRows();
        return rows == null ? NONE : this.support.getSrImageRows();
    }

    public void setSrImageRows(String srImageRows) {
        this.support.setSrImageRows(NONE.equals(srImageRows) ? null : srImageRows);
    }

    public String getECGSopCuids() {
        return this.toString(this.support.getECGSopCuids());
    }

    public void setECGSopCuids(String cuids) {
        this.support.setECGSopCuids(this.toUidMap(cuids));
    }

    public String getSRSopCuids() {
        return this.toString(this.support.getSRSopCuids());
    }

    public void setSRSopCuids(String cuids) {
        this.support.setSRSopCuids(this.toUidMap(cuids));
    }

    public String getEncapsulatedDocumentSopCuids() {
        return this.toString(this.support.getEncapsulatedDocumentSopCuids());
    }

    public void setEncapsulatedDocumentSopCuids(String cuids) {
        this.support.setEncapsulatedDocumentSopCuids(this.toUidMap(cuids));
    }

    public String getCuidsForSummaryAll() {
        return this.toString(this.support.getCuidsForSummaryAll());
    }

    public void setCuidsForSummaryAll(String cuids) {
        this.support.setCuidsForSummaryAll(this.toUidMap(cuids));
    }

    public String getSopCuidGroups() {
        return this.toUidGrpString(this.support.getSopCuidGroups());
    }

    public void setSopCuidGroups(String cuidGrps) {
        this.support.updateSopCuidGroups(this.toUidGrpMap(cuidGrps));
    }

    private Map toUidMap(String cuids) {
        if (NONE.equalsIgnoreCase(cuids)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(cuids, "\r\n;");
        TreeMap<String, String> map = new TreeMap<String, String>();
        boolean i = false;
        while (st.hasMoreTokens()) {
            String uid;
            String name = uid = st.nextToken().trim();
            if (RIDService.isDigit(uid.charAt(0))) {
                if (!UIDs.isValid((String)uid)) {
                    throw new IllegalArgumentException("UID " + uid + " isn't a valid UID!");
                }
            } else {
                uid = UIDs.forName((String)name);
            }
            map.put(name, uid);
        }
        return map;
    }

    private String toString(Map uids) {
        if (uids == null || uids.isEmpty()) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer(uids.size() << 5);
        Iterator iter = uids.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    private String toUidGrpString(Map<String, Map<String, String>> uids) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Map<String, String>> entry : uids.entrySet()) {
            String grpId = entry.getKey();
            for (String uid : entry.getValue().keySet()) {
                sb.append(grpId).append(':').append(uid).append(System.getProperty("line.separator", "\n"));
            }
        }
        return sb.toString();
    }

    private Map<String, Map<String, String>> toUidGrpMap(String cuidGrps) {
        StringTokenizer st = new StringTokenizer(cuidGrps, "\r\n;");
        HashMap<String, Map<String, String>> mapGrps = new HashMap<String, Map<String, String>>();
        boolean i = false;
        while (st.hasMoreTokens()) {
            TreeMap<String, String> map;
            String uid;
            String grp;
            String s = st.nextToken().trim();
            int pos = s.indexOf(58);
            if (pos != -1) {
                grp = s.substring(0, pos);
                if (grp.equals("SR") || grp.equals("ECG") || grp.equals("DOC")) continue;
                uid = s.substring(++pos);
            } else {
                grp = "unknown";
                uid = s;
            }
            String name = uid;
            if (RIDService.isDigit(uid.charAt(0))) {
                if (!UIDs.isValid((String)uid)) {
                    throw new IllegalArgumentException("UID " + uid + " isn't a valid UID!");
                }
            } else {
                uid = UIDs.forName((String)name);
            }
            if ((map = (TreeMap<String, String>)mapGrps.get(grp)) == null) {
                map = new TreeMap<String, String>();
                mapGrps.put(grp, map);
            }
            map.put(name, uid);
        }
        return mapGrps;
    }

    public String getConceptNameCodes() {
        return this.support.getConceptNameCodes();
    }

    public void setConceptNameCodes(String conceptNames) {
        this.support.setConceptNameCodes(conceptNames);
    }

    public String getDocTitlePatterns() {
        Map<String, String> m = this.support.getDocTitlePatterns();
        if (m == null) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> e : m.entrySet()) {
            sb.append((Object)e.getKey()).append('=').append((Object)e.getValue()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    public void setDocTitlePatterns(String docTitlePatterns) {
        HashMap<String, String> m = null;
        if (docTitlePatterns != null && !docTitlePatterns.trim().equalsIgnoreCase(NONE)) {
            m = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(docTitlePatterns, "\r\n;=");
            while (st.hasMoreElements()) {
                m.put(st.nextToken(), st.nextToken());
            }
        }
        this.support.setDocTitlePatterns(m);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public void setAuditLoggerName(ObjectName name) {
        this.support.setAuditLoggerName(name);
    }

    public ObjectName getQueryRetrieveScpName() {
        return this.support.getQueryRetrieveScpName();
    }

    public void setQueryRetrieveScpName(ObjectName name) {
        this.support.setQueryRetrieveScpName(name);
    }

    public ObjectName getAuditLoggerName() {
        return this.support.getAuditLoggerName();
    }

    public RIDResponseObject getRIDSummary(RIDRequestObject reqVO) throws SQLException, TransformerConfigurationException, IOException, SAXException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getRIDSummary:" + reqVO));
        }
        return this.support.getRIDSummary(reqVO);
    }

    public RIDResponseObject getRIDDocument(RIDRequestObject reqVO) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getRIDDocument:" + reqVO));
        }
        return this.support.getRIDDocument(reqVO);
    }

    public DataHandler getDocumentDataHandler(String objectUID, String contentType) throws IOException {
        return this.support.getOrCreateDocument(objectUID, contentType).getDataHandler();
    }

    public Templates getTemplate(String xslFilename) {
        return this.templates.getTemplatesForAET(null, xslFilename);
    }
}

