/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Fop;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chee.docstore.BaseDocument;
import org.dcm4chex.archive.util.FileDataSource;
import org.dcm4chex.rid.common.RIDRequestObject;
import org.dcm4chex.rid.common.RIDResponseObject;
import org.dcm4chex.rid.mbean.RIDStorageDelegate;
import org.dcm4chex.rid.mbean.RIDStreamResponseObjectImpl;
import org.dcm4chex.rid.mbean.RIDSupport;
import org.dcm4chex.rid.mbean.ecg.WaveformGroup;
import org.dcm4chex.rid.mbean.ecg.WaveformInfo;
import org.dcm4chex.rid.mbean.ecg.xml.FOPCreator;
import org.dcm4chex.rid.mbean.ecg.xml.SVGCreator;

public class ECGSupport {
    public static final String CONTENT_TYPE_SVGXML = "image/svg+xml";
    private static Logger log = Logger.getLogger((String)ECGSupport.class.getName());
    private static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    private RIDSupport ridSupport;
    private RIDStorageDelegate storage = RIDStorageDelegate.getInstance();

    public ECGSupport(RIDSupport ridSupport) {
        this.ridSupport = ridSupport;
    }

    public RIDResponseObject getECGDocument(RIDRequestObject reqObj, Dataset ds) {
        String contentType = reqObj.getParam("preferredContentType");
        if (contentType.equals(CONTENT_TYPE_SVGXML) || contentType.equals("image/svg")) {
            contentType = CONTENT_TYPE_SVGXML;
            if (this.ridSupport.checkContentType(reqObj, new String[]{CONTENT_TYPE_SVGXML}) == null) {
                return new RIDStreamResponseObjectImpl(null, "text/html", 400, "Display actor doesnt accept preferred content type!");
            }
        } else if (contentType.equals("application/pdf")) {
            if (this.ridSupport.checkContentType(reqObj, new String[]{"application/pdf"}) == null) {
                return new RIDStreamResponseObjectImpl(null, "text/html", 400, "Display actor doesnt accept preferred content type!");
            }
        } else {
            return new RIDStreamResponseObjectImpl(null, "text/html", 406, "preferredContentType '" + contentType + "' is not supported! Only 'application/pdf' and 'image/svg+xml' are supported !");
        }
        String docUID = reqObj.getParam("documentUID");
        log.info((Object)("get ECG document! docUID:" + docUID));
        BaseDocument doc = this.storage.getDocument(docUID, contentType);
        try {
            if (doc != null) {
                return new RIDStreamResponseObjectImpl(doc.getInputStream(), contentType, 200, null);
            }
        }
        catch (Exception x) {
            log.error((Object)("Getting InputStream for RID Response of document " + docUID + " failed!"), (Throwable)x);
        }
        try {
            Dataset fullDS = this.getDataset(ds);
            doc = this.storage.createDocument(docUID, contentType);
            if (fullDS == null) {
                return new RIDStreamResponseObjectImpl(null, "text/html", 404, "Requested document not found::" + ds.getString(524310));
            }
            if (contentType.equals("application/pdf")) {
                return this.handlePDF(fullDS, doc);
            }
            return this.handleSVG(fullDS, doc);
        }
        catch (Exception e) {
            return new RIDStreamResponseObjectImpl(null, "text/html", 500, "Internal server error:" + e.getMessage());
        }
    }

    private Dataset getDataset(Dataset ds) throws IOException {
        Dataset dsFile;
        String iuid = ds.getString(524312);
        File file = this.ridSupport.getDICOMFile(iuid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DCM file for " + ds.getString(524312) + ":" + file));
        }
        if (file == null) {
            return null;
        }
        if (!this.ridSupport.isUseOrigFile()) {
            FileDataSource dsrc = null;
            try {
                dsrc = (FileDataSource)this.ridSupport.getMBeanServer().invoke(this.ridSupport.getQueryRetrieveScpName(), "getDatasourceOfInstance", new Object[]{iuid}, new String[]{String.class.getName()});
            }
            catch (Exception e) {
                log.error((Object)"Failed to get updated DICOM file", (Throwable)e);
            }
            file = new File(file + ".dcm");
            file.deleteOnExit();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            dsrc.isWriteFile();
            dsrc.writeTo((OutputStream)os, null);
            ((OutputStream)os).close();
            dsFile = this.loadDataset(file);
            file.delete();
        } else {
            dsFile = this.loadDataset(file);
        }
        return dsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset loadDataset(File file) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        Dataset ds = factory.newDataset();
        try {
            ds.readFile((InputStream)bis, null, -1);
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException ignore) {}
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dataset for file " + file + " :" + ds));
        }
        return ds;
    }

    private RIDResponseObject handleSVG(Dataset ds, BaseDocument doc) throws IOException {
        OutputStream out = doc.getOutputStream();
        try {
            DcmElement elem = ds.get(1409286400);
            WaveformGroup wfgrp = new WaveformGroup(ds.getString(524310), elem, 0, this.ridSupport.getWaveformCorrection());
            if (log.isDebugEnabled()) {
                log.debug((Object)wfgrp);
            }
            WaveformInfo wfInfo = new WaveformInfo(ds);
            SVGCreator svgCreator = new SVGCreator(wfgrp, wfInfo, new Float(27.6f), new Float(20.3f));
            svgCreator.toXML(out);
            out.close();
            return new RIDStreamResponseObjectImpl(doc.getInputStream(), CONTENT_TYPE_SVGXML, 200, null);
        }
        catch (Throwable t) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            log.error((Object)"Cant create SVG for Waveform!", t);
            log.error((Object)"Waveform Dataset:");
            log.error((Object)ds);
            return new RIDStreamResponseObjectImpl(null, "text/html", 500, "Error while creating waveform SVG! Reason:" + t.getMessage());
        }
    }

    private RIDResponseObject handlePDF(Dataset ds, BaseDocument doc) throws IOException {
        OutputStream out = doc.getOutputStream();
        OutputStream tmpOut = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("fop_", null);
            tmpFile.deleteOnExit();
            tmpOut = new FileOutputStream(tmpFile);
            DcmElement elem = ds.get(1409286400);
            WaveformGroup[] wfgrps = this.getWaveformGroups(elem, ds.getString(524310));
            WaveformInfo wfInfo = new WaveformInfo(ds);
            FOPCreator fopCreator = new FOPCreator(wfgrps, wfInfo, new Float(28.6f), new Float(20.3f));
            fopCreator.toXML(tmpOut);
            tmpOut.close();
            Fop fop = this.ridSupport.newFop("application/pdf", out);
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.transform(new StreamSource(new FileInputStream(tmpFile)), new SAXResult(fop.getDefaultHandler()));
            out.close();
            tmpFile.delete();
            InputStream in = doc.getInputStream();
            return new RIDStreamResponseObjectImpl(in, in.available(), "application/pdf", 200, null);
        }
        catch (Throwable t) {
            try {
                if (out != null) {
                    out.close();
                }
                if (tmpOut != null) {
                    tmpOut.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            log.error((Object)"Cant create PDF for Waveform!", t);
            log.error((Object)"Waveform Dataset:");
            log.error((Object)ds);
            return new RIDStreamResponseObjectImpl(null, "text/html", 500, "Error while creating waveform PDF! Reason:" + t.getMessage());
        }
    }

    private WaveformGroup[] getWaveformGroups(DcmElement elem, String cuid) {
        float corr = this.ridSupport.getWaveformCorrection();
        int nrOfWFGroups = elem.countItems();
        if (nrOfWFGroups == 1) {
            return new WaveformGroup[]{new WaveformGroup(cuid, elem, 0, corr)};
        }
        ArrayList<WaveformGroup> l = new ArrayList<WaveformGroup>(nrOfWFGroups);
        for (int i = 0; i < nrOfWFGroups; ++i) {
            try {
                l.add(new WaveformGroup(cuid, elem, i, corr));
                continue;
            }
            catch (Exception x) {
                log.warn((Object)("Item " + i + " in Waveform Sequence is not valid! Ignored!!"));
            }
        }
        return l.toArray(new WaveformGroup[l.size()]);
    }
}

