/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.rid.mbean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConceptNameCodeConfig {
    private static final String ALL = "A";
    private static final String RADIOLOGY = "R";
    private static final String CARDIOLOGY = "C";
    private static final String CARDIOLOGY_ECG = "ECG";
    private static final String LABORATORY = "L";
    private static final String SURGERY = "S";
    private static final String EMERGENCY = "E";
    private static final String DISCHARGE = "D";
    private static final String ICU = "I";
    private static final String RX = "P";
    private static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    private Map<String, Map<String, List<Dataset>>> conceptNameCodeLists = new HashMap<String, Map<String, List<Dataset>>>();
    private static final Map<String, String> SUMMARY_ID_MAP = new HashMap<String, String>();

    public static String getSummaryID(String reqType) {
        return SUMMARY_ID_MAP.get(reqType);
    }

    public Map<String, List<Dataset>> getConceptNameCodes(String key) {
        return this.conceptNameCodeLists.get(SUMMARY_ID_MAP.get(key));
    }

    public void setConceptNameCodes(String conceptNames) {
        if (conceptNames == null || conceptNames.trim().length() < 1) {
            this.resetToDefaultCodes();
        } else {
            this.conceptNameCodeLists = this.parseConceptNameCodeString(conceptNames);
        }
    }

    public String getConceptNameCodes() {
        ArrayList<String> cuidList;
        String code;
        TreeMap resultMap = new TreeMap();
        for (Map.Entry<String, Map<String, List<Dataset>>> entry : this.conceptNameCodeLists.entrySet()) {
            String assign = entry.getKey();
            Map<String, List<Dataset>> map = entry.getValue();
            for (Map.Entry<String, List<Dataset>> entryCuidCode : map.entrySet()) {
                String grpID = entryCuidCode.getKey();
                for (Dataset ds : entryCuidCode.getValue()) {
                    code = this.toCodeString(ds);
                    TreeMap<String, ArrayList<String>> cuidMap = (TreeMap<String, ArrayList<String>>)resultMap.get(code);
                    if (cuidMap == null) {
                        cuidMap = new TreeMap<String, ArrayList<String>>();
                        resultMap.put(code, cuidMap);
                    }
                    if ((cuidList = (List)cuidMap.get(assign)) == null) {
                        cuidList = new ArrayList<String>();
                        cuidMap.put(assign, cuidList);
                    }
                    if (grpID == null) continue;
                    cuidList.add(grpID);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : resultMap.entrySet()) {
            code = (String)entry.getKey();
            sb.append(code).append(':');
            for (Map.Entry entryAssign : ((Map)entry.getValue()).entrySet()) {
                sb.append(entryAssign.getKey());
                cuidList = (ArrayList<String>)entryAssign.getValue();
                if (cuidList.size() > 0) {
                    sb.append('(');
                    for (String id : cuidList) {
                        sb.append(id).append(',');
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(')');
                }
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    private void resetToDefaultCodes() {
        this.conceptNameCodeLists.clear();
        HashMap mapAll = new HashMap();
        HashMap<Object, List<Dataset>> mapR = new HashMap<Object, List<Dataset>>();
        mapR.put(null, ConceptNameCodeConfig.getDefaultRadiologyConceptNameCodes());
        mapAll.put(null, ConceptNameCodeConfig.getDefaultRadiologyConceptNameCodes());
        this.conceptNameCodeLists.put(ALL, mapAll);
        this.conceptNameCodeLists.put(RADIOLOGY, mapR);
        HashMap<Object, List<Dataset>> mapC = new HashMap<Object, List<Dataset>>();
        mapC.put(null, ConceptNameCodeConfig.getDefaultCardiologyConceptNameCodes());
        ((List)mapAll.get(null)).addAll(ConceptNameCodeConfig.getDefaultCardiologyConceptNameCodes());
        this.conceptNameCodeLists.put(CARDIOLOGY, mapC);
    }

    public Map<String, Map<String, List<Dataset>>> parseConceptNameCodeString(String conceptNames) {
        HashMap<String, Map<String, List<Dataset>>> map = new HashMap<String, Map<String, List<Dataset>>>();
        if (conceptNames != null && conceptNames.trim().length() > 0) {
            StringTokenizer stLine = new StringTokenizer(conceptNames, "\r\n;");
            while (stLine.hasMoreTokens()) {
                String line = stLine.nextToken();
                int pos = line.indexOf(58);
                StringTokenizer stCode = new StringTokenizer(line.substring(0, pos), "^");
                Dataset code = ConceptNameCodeConfig.createCodeDS(stCode.nextToken(), stCode.hasMoreTokens() ? stCode.nextToken() : "LN", stCode.hasMoreTokens() ? stCode.nextToken() : null);
                StringTokenizer stAssign = new StringTokenizer(line.substring(++pos), ",");
                while (stAssign.hasMoreTokens()) {
                    String assign = stAssign.nextToken();
                    int pos1 = assign.indexOf(40);
                    if (pos1 != -1) {
                        String cuidGrps = assign.substring(++pos1, assign.length() - 1);
                        assign = assign.substring(0, --pos1);
                        StringTokenizer stCuidGrp = new StringTokenizer(cuidGrps, ",");
                        while (stCuidGrp.hasMoreTokens()) {
                            this.addAssign(assign, stCuidGrp.nextToken(), code, map);
                        }
                        continue;
                    }
                    this.addAssign(assign, null, code, map);
                }
            }
            return map;
        }
        return null;
    }

    private void addAssign(String assign, String cuidGrpId, Dataset code, Map<String, Map<String, List<Dataset>>> map) {
        List<Dataset> l;
        Map<String, List<Dataset>> map1 = map.get(assign);
        if (map1 == null) {
            map1 = new HashMap<String, List<Dataset>>();
            map.put(assign, map1);
        }
        if ((l = map1.get(cuidGrpId)) == null) {
            l = new ArrayList<Dataset>();
            map1.put(cuidGrpId, l);
        }
        l.add(code);
    }

    public String toCodeString(Dataset ds) {
        StringBuffer sb = new StringBuffer();
        sb.append(ds.getString(524544)).append('^');
        sb.append(ds.getString(524546));
        if (ds.getString(524548) != null) {
            sb.append('^').append(ds.getString(524548));
        }
        return sb.toString();
    }

    public static List<Dataset> getDefaultCardiologyConceptNameCodes() {
        ArrayList<Dataset> cardiologyConceptNameCodes = new ArrayList<Dataset>();
        cardiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18745-0", "LN", "Cardiac Catheteization Report"));
        cardiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11522-0", "LN", "Echocardiography Report"));
        cardiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("10001", "99SUPP97", "Quantitative Arteriography report"));
        cardiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("122291", "DCM", "CT/MR Cardiovascular Report"));
        cardiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("122292", "DCM", "Quantitative Ventriculography Report"));
        cardiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("125200", "DCM", "Adult Echocardiography Procedure Report"));
        return cardiologyConceptNameCodes;
    }

    public static List<Dataset> getDefaultRadiologyConceptNameCodes() {
        ArrayList<Dataset> radiologyConceptNameCodes = new ArrayList<Dataset>();
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11540-2", "LN", "CT Abdomen Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11538-6", "LN", "CT Chest Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11539-4", "LN", "CT Head Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18747-6", "LN", "CT Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18748-4", "LN", "Diagnostic Imaging Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18760-9", "LN", "Ultrasound Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11541-0", "LN", "MRI Head Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18755-9", "LN", "MRI Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18756-7", "LN", "MRI Spine Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18757-5", "LN", "Nuclear Medicine Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11525-3", "LN", "Ultrasound Obstetric and Gyn Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("18758-3", "LN", "PET Scan Report"));
        radiologyConceptNameCodes.add(ConceptNameCodeConfig.createCodeDS("11528-7", "LN", "Radiology Report"));
        return radiologyConceptNameCodes;
    }

    private static Dataset createCodeDS(String value, String design, String meaning) {
        Dataset ds = factory.newDataset();
        ds.putSH(524544, value);
        ds.putSH(524546, design);
        if (meaning != null) {
            ds.putLO(524548, meaning);
        }
        return ds;
    }

    static {
        SUMMARY_ID_MAP.put("SUMMARY", ALL);
        SUMMARY_ID_MAP.put("SUMMARY-RADIOLOGY", RADIOLOGY);
        SUMMARY_ID_MAP.put("SUMMARY-CARDIOLOGY", CARDIOLOGY);
        SUMMARY_ID_MAP.put("SUMMARY-CARDIOLOGY-ECG", CARDIOLOGY_ECG);
        SUMMARY_ID_MAP.put("SUMMARY-LABORATORY", LABORATORY);
        SUMMARY_ID_MAP.put("SUMMARY-SURGERY", SURGERY);
        SUMMARY_ID_MAP.put("SUMMARY-EMERGENCY", EMERGENCY);
        SUMMARY_ID_MAP.put("SUMMARY-DISCHARGE", DISCHARGE);
        SUMMARY_ID_MAP.put("SUMMARY-ICU", ICU);
        SUMMARY_ID_MAP.put("SUMMARY-RX", RX);
    }
}

