/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation.triggers;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.transaction.Transaction;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.cache.invalidation.InvalidationsTxGrouper;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.system.Registry;
import org.w3c.dom.Element;

public class EntityBeanCacheBatchInvalidatorInterceptor
extends AbstractInterceptor
implements XmlLoadable {
    protected boolean doCacheInvalidations = true;
    protected InvalidationManagerMBean invalMgr = null;
    protected InvalidationGroup ig = null;
    protected EntityContainer container = null;
    public boolean invalidateRelated;

    public void start() throws Exception {
        EntityMetaData emd = (EntityMetaData)this.getContainer().getBeanMetaData();
        this.doCacheInvalidations = emd.doDistributedCacheInvalidations();
        if (this.doCacheInvalidations) {
            String groupName = emd.getDistributedCacheInvalidationConfig().getInvalidationGroupName();
            String imName = emd.getDistributedCacheInvalidationConfig().getInvalidationManagerName();
            this.invalMgr = (InvalidationManagerMBean)Registry.lookup((Object)imName);
            this.ig = this.invalMgr.getInvalidationGroup(groupName);
        }
    }

    public void stop() {
        this.invalMgr = null;
        if (this.ig != null) {
            this.ig.removeReference();
            this.ig = null;
        }
    }

    protected boolean changed(Invocation mi, EntityEnterpriseContext ctx) throws Exception {
        Method method;
        if (ctx.getId() == null) {
            return true;
        }
        if (!(this.container.isReadOnly() || (method = mi.getMethod()) != null && this.container.getBeanMetaData().isMethodReadOnly(method.getName()))) {
            return this.invalidateRelated ? this.container.getPersistenceManager().isModified(ctx) : this.container.getPersistenceManager().isStoreRequired(ctx);
        }
        return false;
    }

    public Object invoke(Invocation mi) throws Exception {
        if (this.doCacheInvalidations) {
            EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
            Object id = ctx.getId();
            Transaction tx = mi.getTransaction();
            if (tx != null && tx.getStatus() != 6) {
                Object retVal = this.getNext().invoke(mi);
                if (this.changed(mi, ctx)) {
                    InvalidationsTxGrouper.registerInvalidationSynchronization(tx, this.ig, (Serializable)id);
                }
                return retVal;
            }
            Object result = this.getNext().invoke(mi);
            if (this.changed(mi, ctx)) {
                InvalidationsTxGrouper.registerInvalidationSynchronization(tx, this.ig, (Serializable)id);
            }
            return result;
        }
        return this.getNext().invoke(mi);
    }

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
    }

    public Container getContainer() {
        return this.container;
    }

    public void importXml(Element element) throws Exception {
        String str = MetaData.getElementAttribute(element, "invalidate-related");
        boolean bl = this.invalidateRelated = str == null ? true : Boolean.valueOf(str);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invalidate-related: " + this.invalidateRelated));
        }
    }
}

