/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.base64;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64Provider
extends CharsetProvider {
    private static final char[] BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] INV_BASE64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private final Charset base64 = new Charset("x-base64", null){

        public boolean contains(Charset cs) {
            return false;
        }

        public CharsetDecoder newDecoder() {
            return new Decoder(this);
        }

        public CharsetEncoder newEncoder() {
            return new Encoder(this);
        }
    };

    @Override
    public Charset charsetForName(String charsetName) {
        return charsetName.equalsIgnoreCase(this.base64.name()) ? this.base64 : null;
    }

    @Override
    public Iterator<Charset> charsets() {
        return Collections.singleton(this.base64).iterator();
    }

    private static final class Encoder
    extends CharsetEncoder {
        private char[] chBuf = new char[4];

        public Encoder(Charset cs) {
            super(cs, 0.75f, 1.0f, new byte[]{0});
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            if (in.hasArray() && out.hasArray()) {
                return this.encodeLoopArray(in, out);
            }
            return this.encodeLoopBuffer(in, out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeLoopArray(CharBuffer in, ByteBuffer out) {
            char[] src = in.array();
            int srcPos = in.arrayOffset() + in.position();
            int srcLimit = in.arrayOffset() + in.limit();
            byte[] dest = out.array();
            int destPos = out.arrayOffset() + out.position();
            int destLimit = out.arrayOffset() + out.limit();
            try {
                while (srcPos + 4 <= srcLimit) {
                    if (destPos + 3 > destLimit) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    destPos += this.invbase64(src, srcPos, dest, destPos);
                    srcPos += 4;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                in.position(srcPos - in.arrayOffset());
                out.position(destPos - out.arrayOffset());
            }
        }

        public CoderResult encodeLoopBuffer(CharBuffer in, ByteBuffer out) {
            char[] chBuf = this.chBuf;
            while (in.remaining() >= 4) {
                if (out.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                in.get(chBuf, 0, 4);
                this.invbase64(out);
            }
            return CoderResult.UNDERFLOW;
        }

        private void invbase64(ByteBuffer out) {
            char[] chBuf = this.chBuf;
            byte b2 = INV_BASE64[chBuf[1]];
            out.put((byte)(INV_BASE64[chBuf[0]] << 2 | b2 >>> 4));
            switch (chBuf[3] == '=' ? (chBuf[2] == '=' ? 2 : 1) : 0) {
                case 0: {
                    byte b3 = INV_BASE64[chBuf[2]];
                    out.put((byte)(b2 << 4 | b3 >>> 2));
                    out.put((byte)(b3 << 6 | INV_BASE64[chBuf[3]]));
                    break;
                }
                case 1: {
                    out.put((byte)(b2 << 4 | INV_BASE64[chBuf[2]] >>> 2));
                }
            }
        }

        private int invbase64(char[] src, int srcPos, byte[] dest, int destPos) {
            byte b2 = INV_BASE64[src[srcPos + 1]];
            dest[destPos] = (byte)(INV_BASE64[src[srcPos]] << 2 | b2 >>> 4);
            switch (src[srcPos + 3] == '=' ? (src[srcPos + 2] == '=' ? 2 : 1) : 0) {
                case 0: {
                    byte b3 = INV_BASE64[src[srcPos + 2]];
                    dest[destPos + 1] = (byte)(b2 << 4 | b3 >>> 2);
                    dest[destPos + 2] = (byte)(b3 << 6 | INV_BASE64[src[srcPos + 3]]);
                    return 3;
                }
                case 1: {
                    dest[destPos + 1] = (byte)(b2 << 4 | INV_BASE64[src[srcPos + 2]] >>> 2);
                    return 2;
                }
            }
            return 1;
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        private byte[] buf = new byte[3];
        private int bufLen;

        protected Decoder(Charset cs) {
            super(cs, 1.3333334f, 4.0f);
        }

        protected void implReset() {
            this.bufLen = 0;
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            if (in.hasArray() && out.hasArray()) {
                return this.decodeLoopArray(in, out);
            }
            return this.decodeLoopBuffer(in, out);
        }

        protected CoderResult implFlush(CharBuffer out) {
            if (this.bufLen > 0) {
                if (out.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                this.base64(out);
            }
            this.bufLen = 0;
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeLoopArray(ByteBuffer in, CharBuffer out) {
            byte[] buf = this.buf;
            byte[] src = in.array();
            int srcPos = in.arrayOffset() + in.position();
            int srcLimit = in.arrayOffset() + in.limit();
            char[] dest = out.array();
            int destPos = out.arrayOffset() + out.position();
            int destLimit = out.arrayOffset() + out.limit();
            try {
                int consume;
                if (this.bufLen > 0 && srcPos + (consume = 3 - this.bufLen) <= srcLimit) {
                    if (destPos + 4 > destLimit) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    System.arraycopy(src, srcPos, buf, this.bufLen, consume);
                    this.bufLen = 0;
                    this.base64(buf, 0, dest, destPos);
                    srcPos += consume;
                    destPos += 4;
                }
                if (this.bufLen == 0) {
                    while (srcPos + 3 <= srcLimit) {
                        if (destPos + 4 > destLimit) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        this.base64(src, srcPos, dest, destPos);
                        srcPos += 3;
                        destPos += 4;
                    }
                }
                while (srcPos < srcLimit) {
                    if (this.bufLen < 2) {
                        buf[this.bufLen++] = src[srcPos++];
                        continue;
                    }
                    if (destPos + 4 > destLimit) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    buf[this.bufLen] = src[srcPos++];
                    this.bufLen = 0;
                    this.base64(buf, 0, dest, destPos);
                    destPos += 4;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                in.position(srcPos - in.arrayOffset());
                out.position(destPos - out.arrayOffset());
            }
        }

        private CoderResult decodeLoopBuffer(ByteBuffer in, CharBuffer out) {
            byte[] buf = this.buf;
            while (in.remaining() + this.bufLen >= 3) {
                if (out.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                in.get(buf, this.bufLen, 3 - this.bufLen);
                this.bufLen = 0;
                this.base64(out);
            }
            while (in.hasRemaining()) {
                if (this.bufLen < 2) {
                    buf[this.bufLen++] = in.get();
                    continue;
                }
                if (out.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                buf[this.bufLen] = in.get();
                this.bufLen = 0;
                this.base64(out);
            }
            return CoderResult.UNDERFLOW;
        }

        private void base64(CharBuffer out) {
            byte[] buf = this.buf;
            byte b1 = buf[0];
            out.put(BASE64[b1 >>> 2 & 0x3F]);
            switch (this.bufLen) {
                case 0: {
                    byte b2 = buf[1];
                    out.put(BASE64[(b1 & 3) << 4 | b2 >>> 4 & 0xF]);
                    byte b3 = buf[2];
                    out.put(BASE64[(b2 & 0xF) << 2 | b3 >>> 6 & 3]);
                    out.put(BASE64[b3 & 0x3F]);
                    return;
                }
                case 1: {
                    out.put(BASE64[(b1 & 3) << 4]);
                    out.put('=');
                    break;
                }
                case 2: {
                    byte b2 = buf[1];
                    out.put(BASE64[(b1 & 3) << 4 | b2 >>> 4 & 0xF]);
                    out.put(BASE64[(b2 & 0xF) << 2]);
                }
            }
            out.put('=');
        }

        private void base64(byte[] src, int srcPos, char[] dest, int destPos) {
            byte b1 = src[srcPos];
            dest[destPos] = BASE64[b1 >>> 2 & 0x3F];
            byte b2 = src[srcPos + 1];
            dest[destPos + 1] = BASE64[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
            byte b3 = src[srcPos + 2];
            dest[destPos + 2] = BASE64[(b2 & 0xF) << 2 | b3 >>> 6 & 3];
            dest[destPos + 3] = BASE64[b3 & 0x3F];
        }
    }
}

