/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.lang.reflect.Method;
import java.security.CodeSource;
import javax.security.jacc.EJBMethodPermission;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.security.JaccHelper;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.remoting.InvokerLocator;
import org.jboss.security.RealmMapping;

public class JaccAuthorizationInterceptor
implements Interceptor {
    public static final String JACC = "JACC";
    public static final String CTX = "ctx";
    private String ejbName;
    private CodeSource ejbCS;
    private RealmMapping realmMapping;

    public JaccAuthorizationInterceptor(String ejbName, CodeSource cs) {
        this.ejbName = ejbName;
        this.ejbCS = cs;
    }

    public String getName() {
        return "JaccAuthorizationInterceptor";
    }

    public void setRealmMapping(RealmMapping ssm) {
        this.realmMapping = ssm;
    }

    public Object invoke(Invocation inv) throws Throwable {
        try {
            this.checkSecurityAssociation((MethodInvocation)inv);
            return inv.invokeNext();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Jacc authorization is only available for method invocations", e);
        }
    }

    private void checkSecurityAssociation(MethodInvocation mi) throws Throwable {
        String contextID = (String)mi.getMetaData((Object)JACC, (Object)CTX);
        SecurityActions.setContextID(contextID);
        Method m = mi.getMethod();
        InvokerLocator locator = (InvokerLocator)mi.getMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR");
        String iface = locator != null ? "Remote" : "Local";
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, iface, m);
        if (this.realmMapping != null) {
            JaccHelper.checkPermission(this.ejbCS, methodPerm, this.realmMapping);
        }
    }
}

