/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.TxPolicy;
import org.jboss.aspects.tx.TxTimeoutReader;
import org.jboss.aspects.tx.TxTimeoutReaderFactory;
import org.jboss.logging.Logger;

public class TxInterceptor {
    private static final Logger log = Logger.getLogger((Class)TxInterceptor.class);
    private static final TxTimeoutReader txTimeoutReader = TxTimeoutReaderFactory.getTxTimeoutReader();

    public static class Mandatory
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;
        protected int timeout;

        public Mandatory(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public Mandatory(TransactionManager tm, TxPolicy policy, int timeout) {
            this.tm = tm;
            this.policy = policy;
            this.timeout = timeout;
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx == null) {
                this.policy.throwMandatory(invocation);
            }
            return this.policy.invokeInCallerTx(invocation, tx);
        }
    }

    public static class RequiresNew
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;
        protected int timeout;

        public RequiresNew(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public RequiresNew(TransactionManager tm, TxPolicy policy, int timeout) {
            this.tm = tm;
            this.policy = policy;
            this.timeout = timeout;
        }

        public String getName() {
            return this.getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Invocation invocation) throws Throwable {
            int oldTimeout = txTimeoutReader.getTransactionTimeOut(this.tm);
            try {
                Transaction tx;
                if (this.timeout != -1 && this.tm != null) {
                    this.tm.setTransactionTimeout(this.timeout);
                }
                if ((tx = this.tm.getTransaction()) != null) {
                    this.tm.suspend();
                    try {
                        Object object = this.policy.invokeInOurTx(invocation, this.tm);
                        return object;
                    }
                    finally {
                        this.tm.resume(tx);
                    }
                }
                Object object = this.policy.invokeInOurTx(invocation, this.tm);
                return object;
            }
            finally {
                if (this.tm != null) {
                    this.tm.setTransactionTimeout(oldTimeout);
                }
            }
        }
    }

    public static class Required
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;
        protected int timeout;

        public Required(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public Required(TransactionManager tm, TxPolicy policy, int timeout) {
            this.tm = tm;
            this.policy = policy;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Invocation invocation) throws Throwable {
            int oldTimeout = txTimeoutReader.getTransactionTimeOut(this.tm);
            try {
                Transaction tx;
                if (this.timeout != -1 && this.tm != null) {
                    this.tm.setTransactionTimeout(this.timeout);
                }
                if ((tx = this.tm.getTransaction()) == null) {
                    Object object = this.policy.invokeInOurTx(invocation, this.tm);
                    return object;
                }
                Object object = this.policy.invokeInCallerTx(invocation, tx);
                return object;
            }
            finally {
                if (this.tm != null) {
                    this.tm.setTransactionTimeout(oldTimeout);
                }
            }
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    public static class Supports
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;
        protected int timeout;

        public Supports(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public Supports(TransactionManager tm, TxPolicy policy, int timeout) {
            this.tm = tm;
            this.policy = policy;
            this.timeout = timeout;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.tm.getTransaction() == null) {
                return this.policy.invokeInNoTx(invocation);
            }
            return this.policy.invokeInCallerTx(invocation, this.tm.getTransaction());
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    public static class NotSupported
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;
        protected int timeout;

        public NotSupported(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public NotSupported(TransactionManager tm, TxPolicy policy, int timeout) {
            this.tm = tm;
            this.policy = policy;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
                try {
                    Object object = this.policy.invokeInNoTx(invocation);
                    return object;
                }
                finally {
                    this.tm.resume(tx);
                }
            }
            return this.policy.invokeInNoTx(invocation);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    public static class Never
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;
        protected int timeout;

        public Never(TransactionManager tm, TxPolicy policy) {
            this(tm, policy, -1);
        }

        public Never(TransactionManager tm, TxPolicy policy, int timeout) {
            this.tm = tm;
            this.policy = policy;
            this.timeout = timeout;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.tm.getTransaction() != null) {
                throw new IllegalStateException("Transaction present on server in Never call");
            }
            return this.policy.invokeInNoTx(invocation);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }
}

