/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.docstore.spi.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.dcm4chee.docstore.Availability;
import org.dcm4chee.docstore.BaseDocument;
import org.dcm4chee.docstore.DataHandlerVO;
import org.dcm4chee.docstore.DocumentStore;
import org.dcm4chee.docstore.Feature;
import org.dcm4chee.docstore.spi.BaseDocumentStorage;
import org.dcm4chee.docstore.util.FileSystemInfo;
import org.jboss.system.server.ServerConfigLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentFileStorage
extends BaseDocumentStorage {
    private static final String UNKNOWN_MIME = "application/octet-stream";
    private static final String DEFAULT_MIME_FILENAME = "default.mime";
    public static final String STORAGE_TYPE = "SimpleFileStorage";
    private static final String DEFAULT_BASE_DIR = "store/docs";
    private static final String HASH_EXTENSION = ".hash";
    private int[] directoryTree = new int[]{347, 331, 317};
    private File baseDir;
    private Availability currentAvailabilty;
    private long minFree = 10000000L;
    private boolean computeHash = true;
    private long lastCheck;
    private int checkIntervall = 600000;
    private static Logger log = LoggerFactory.getLogger(DocumentFileStorage.class);

    public DocumentFileStorage() {
        this(STORAGE_TYPE);
    }

    public DocumentFileStorage(String name) {
        super(name);
        this.addFeature(Feature.CREATE_EMPTY_DOCUMENT);
        this.addFeature(Feature.MULTI_MIME);
        this.addFeature(new Feature("SHA1", "Generation of SHA1 hash"));
    }

    @Override
    public void init(String initString) {
        String basedir = null;
        String s = null;
        try {
            Properties p = this.readInitAsProperties(initString);
            basedir = p.getProperty("BASE_DIR");
            s = p.getProperty("minFree");
            if (s != null) {
                this.minFree = Long.parseLong(s);
            }
            if ((s = p.getProperty("checkIntervall")) != null) {
                this.checkIntervall = Integer.parseInt(s.trim());
            }
            if ((s = p.getProperty("disableHash")) != null && s.equalsIgnoreCase("true")) {
                this.computeHash = false;
            }
            s = p.getProperty("dfCmdName", "dcm4chee.archive:service=dfcmd");
            FileSystemInfo.setDFCmdServiceName(s);
        }
        catch (IOException e) {
            log.error("Cant initialize DocumentFileStorage!", (Throwable)e);
            throw new IllegalArgumentException("Initialization of DocumentFileStorage failed! initString" + initString);
        }
        catch (NumberFormatException e) {
            log.warn("Illegal minFree value! (" + s + ")! Use default:" + this.minFree, (Throwable)e);
        }
        this.setBaseDir(basedir == null ? DEFAULT_BASE_DIR : basedir);
        log.info("DocumentFileStorage initialized! :" + this);
    }

    public void setBaseDir(String dirName) {
        File dir = new File(dirName);
        if (dir.isAbsolute()) {
            this.baseDir = dir;
        } else {
            try {
                File serverHomeDir = ServerConfigLocator.locate().getServerHomeDir();
                this.baseDir = new File(serverHomeDir, dir.getPath());
            }
            catch (Throwable x) {
                log.debug("Error getting Server Home Directory! Use current working directory instead! BaseDir:" + dir.getAbsolutePath());
                this.baseDir = dir;
            }
        }
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Availability getStorageAvailability() {
        log.debug("getStorageAvailability called! currentAvailabilty:" + this.currentAvailabilty);
        return this.currentAvailabilty == null || System.currentTimeMillis() - this.lastCheck > (long)this.checkIntervall ? this.checkAvailabilty() : this.currentAvailabilty;
    }

    public Availability checkAvailabilty() {
        log.debug("checkAvailabilty called! currentAvailabilty:" + this.currentAvailabilty);
        Availability oldAvail = this.currentAvailabilty;
        this.currentAvailabilty = FileSystemInfo.getFileSystemAvailability(this.baseDir, this.minFree);
        if (oldAvail == null || !oldAvail.equals(this.currentAvailabilty)) {
            this.notifyAvailabilityChanged(oldAvail, this.currentAvailabilty);
        }
        log.debug("checkAvailabilty done! currentAvailabilty:" + this.currentAvailabilty);
        this.lastCheck = System.currentTimeMillis();
        return this.currentAvailabilty;
    }

    @Override
    public boolean deleteDocument(String docUID) {
        boolean b = false;
        File docPath = this.getDocumentPath(docUID);
        log.debug("deleteDocument docPath:" + docPath);
        if (docPath.exists()) {
            String[] docFiles = null;
            if (this.getNumberOfListeners() > 0) {
                docFiles = docPath.list();
            }
            b = this.deleteFile(docPath);
            log.debug("docPath deleted?:" + b);
            if (b && docFiles != null) {
                for (String f : docFiles) {
                    log.debug(" docFile:" + f);
                    if (DEFAULT_MIME_FILENAME.equals(f)) continue;
                    this.notifyDeleted(new BaseDocument(docUID, f, null, null, -1L, null));
                }
            }
            this.purgeDocumentPath(docPath.getParentFile());
        }
        return b;
    }

    private boolean deleteFile(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteFile(files[i]);
            }
        }
        log.info("M-DELETE DocumentStorage file:" + f);
        return f.delete();
    }

    private void purgeDocumentPath(File dir) {
        if (dir == null || dir.equals(this.baseDir)) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length == 0) {
            dir.delete();
            this.purgeDocumentPath(dir.getParentFile());
        }
    }

    @Override
    public Availability getAvailabilty(String docUid) {
        File f = this.getDocumentPath(docUid);
        return f.exists() ? Availability.ONLINE : Availability.NONEEXISTENT;
    }

    @Override
    public String getRetrieveURL(String docUid) {
        return null;
    }

    @Override
    public String getStorageType() {
        return STORAGE_TYPE;
    }

    @Override
    public BaseDocument retrieveDocument(String docUid) throws IOException {
        return this.retrieveDocument(docUid, null);
    }

    @Override
    public BaseDocument retrieveDocument(String docUid, String mime) throws IOException {
        log.debug("RetrieveDocument docUid:" + docUid + " mime:" + mime);
        File docPath = this.getDocumentPath(docUid);
        BaseDocument doc = null;
        String[] m = new String[]{mime};
        if (docPath.exists()) {
            File f = this.getDocumentFile(docPath, m);
            log.debug("docFile:" + f + " exists:" + f.exists());
            if (f.exists()) {
                doc = new BaseDocument(docUid, m[0], new DataHandler((DataSource)new FileDataSource(f)), Availability.ONLINE, f.length(), this);
                byte[] ba = this.readFile(this.getHashFile(f));
                if (ba != null) {
                    doc.setHash(new String(ba));
                }
                this.notifyRetrieved(doc);
            }
        }
        return doc;
    }

    @Override
    public BaseDocument createDocument(String docUid, String mime) throws IOException {
        File docFile;
        File docPath;
        File defaultMime;
        if (mime == null || mime.trim().length() < 1) {
            mime = UNKNOWN_MIME;
        }
        if (!(defaultMime = this.getMimeFile(docPath = this.getDocumentPath(docUid))).exists()) {
            this.writeFile(this.getMimeFile(docPath), mime.getBytes());
        }
        if ((docFile = this.getDocumentFile(docPath, new String[]{mime})).exists()) {
            throw new IOException("Create empty document failed! Document already exists! docUid:" + docUid + " mime:" + mime);
        }
        log.debug("M-CREATE: Empty document file created:" + docFile);
        BaseDocument doc = new BaseDocument(docUid, mime, new DataHandler((DataSource)new FileDataSource(docFile)), Availability.UNAVAILABLE, docFile.length(), this);
        this.notifyCreated(doc);
        return doc;
    }

    @Override
    public boolean setHash(BaseDocument doc, String hash) {
        if (hash != null) {
            try {
                File docFile = this.getDocumentFile(this.getDocumentPath(doc.getDocumentUID()), new String[]{doc.getMimeType()});
                if (docFile.exists()) {
                    File hashFile = this.getHashFile(docFile);
                    if (!hashFile.exists()) {
                        this.writeFile(this.getHashFile(docFile), hash.getBytes());
                        return true;
                    }
                    log.error("Hash File already exists for document! docUID:" + doc.getDocumentUID());
                } else {
                    log.error("setHash called for non existing document! docUID:" + doc.getDocumentUID());
                }
            }
            catch (IOException e) {
                log.error("Error write Hash File for docUid:" + doc.getDocumentUID() + "! hash:" + hash, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public BaseDocument[] storeDocuments(Set<DataHandlerVO> dhVOs) throws IOException {
        BaseDocument[] docs = new BaseDocument[dhVOs.size()];
        int i = 0;
        try {
            for (DataHandlerVO vo : dhVOs) {
                docs[i++] = this.storeDocument(vo.getUid(), vo.getDataHandler());
            }
        }
        catch (Exception x) {
            log.error("storeDocuments failed! RollBack " + --i + " Documents!", (Throwable)x);
            for (int j = 0; j < i; ++j) {
                log.debug("   Rollback storeDocuments! (" + j + ") Delete Document:" + docs[j]);
                if (docs[j] == null) continue;
                this.deleteDocument(docs[j].getDocumentUID());
            }
            IOException iox = new IOException("storeDocuments failed!");
            iox.initCause(x);
            throw iox;
        }
        return docs;
    }

    @Override
    public BaseDocument storeDocument(String docUid, DataHandler dh) throws IOException {
        File docPath = this.getDocumentPath(docUid);
        log.debug("#### Document Path:" + docPath);
        log.debug("#### Document Path exist?:" + docPath.exists());
        try {
            String[] mime = new String[]{dh.getContentType()};
            File docFile = this.getDocumentFile(docPath, mime);
            log.debug("#### Document File:" + docFile);
            log.debug("#### Document File exist?:" + docFile.exists());
            if (docFile.exists()) {
                BaseDocument baseDocument = null;
                return baseDocument;
            }
            byte[] digest = this.writeFile(docFile, dh);
            File mimeFile = this.getMimeFile(docPath);
            if (!mimeFile.exists()) {
                this.writeFile(mimeFile, mime[0].getBytes());
            }
            BaseDocument doc = new BaseDocument(docUid, mime[0], new DataHandler((DataSource)new FileDataSource(docFile)), Availability.ONLINE, docFile.length(), this);
            if (digest != null) {
                doc.setHash(DocumentStore.toHexString(digest));
                this.writeFile(this.getHashFile(docFile), doc.getHash().getBytes());
            }
            this.notifyStored(doc);
            BaseDocument baseDocument = doc;
            return baseDocument;
        }
        catch (NoSuchAlgorithmException x) {
            log.error("Store of document " + docUid + " failed! Can't calculate hash value!", (Throwable)x);
            throw new IOException("Store of document " + docUid + " failed! Unknown Hash Algorithm!");
        }
        finally {
            try {
                dh.getInputStream().close();
            }
            catch (Exception ignore) {
                log.warn("Error closing InputStream of DataHandler! Ignored", (Throwable)ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeFile(File f, DataHandler dh) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = null;
        OutputStream out = null;
        if (!f.exists()) {
            log.debug("#### Write File:" + f);
            try {
                f.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(f);
                if (this.computeHash) {
                    md = MessageDigest.getInstance("SHA1");
                    out = new DigestOutputStream(fos, md);
                } else {
                    log.debug("SHA1 feature is disabled!");
                    out = fos;
                }
                dh.writeTo(out);
                log.debug("#### File written:" + f + " exists:" + f.exists());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore) {
                        log.error("Ignored error during close!", (Throwable)ignore);
                    }
                }
            }
        }
        return md == null ? null : md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, byte[] ba) throws IOException {
        FileOutputStream fos = null;
        try {
            f.getParentFile().mkdirs();
            fos = new FileOutputStream(f);
            fos.write(ba);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {
                    log.warn("Cant close FileOutputStream! ignored! reason:" + ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            byte[] ba = new byte[fis.available()];
            fis.read(ba);
            byte[] byArray = ba;
            return byArray;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {
                    log.warn("Cant close FileInputStream! ignored! reason:" + ignore);
                }
            }
        }
    }

    private File getDocumentPath(String docUid) {
        if (this.baseDir == null) {
            this.setBaseDir(DEFAULT_BASE_DIR);
            log.warn("DocumentFileStorage not initialized! Set default Base Directory:" + this.baseDir);
        }
        log.debug("getDocumentPath for " + docUid + " for DocumentStorage " + this.getName() + ". baseDir:" + this.baseDir);
        return new File(this.baseDir, this.getFilepath(docUid));
    }

    private File getDocumentFile(File docPath, String[] mime) throws IOException {
        if (mime[0] == null || mime[0].trim().length() < 1) {
            byte[] ba = this.readFile(this.getMimeFile(docPath));
            mime[0] = ba != null ? new String(ba) : UNKNOWN_MIME;
        }
        String m = mime[0].replace('/', '_');
        return new File(docPath, URLEncoder.encode(m, "UTF-8"));
    }

    private File getMimeFile(File docPath) {
        return new File(docPath.getAbsolutePath(), DEFAULT_MIME_FILENAME);
    }

    private String getFilepath(String uid) {
        if (this.directoryTree == null) {
            return uid;
        }
        StringBuffer sb = new StringBuffer();
        int hash = uid.hashCode();
        for (int i = 0; i < this.directoryTree.length; ++i) {
            if (this.directoryTree[i] == 0) {
                sb.append(Integer.toHexString(hash)).append(File.separatorChar);
                continue;
            }
            int modulo = hash % this.directoryTree[i];
            if (modulo < 0) {
                modulo *= -1;
            }
            sb.append(modulo).append(File.separatorChar);
        }
        sb.append(uid);
        return sb.toString();
    }

    private File getHashFile(File f) {
        return new File(f.getAbsolutePath() + HASH_EXTENSION);
    }

    @Override
    public String toString() {
        return super.toString() + " baseDir:" + this.baseDir + "(minFree:" + this.minFree + ") " + this.getStorageAvailability();
    }
}

