/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.docstore.spi;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.dcm4chee.docstore.Availability;
import org.dcm4chee.docstore.BaseDocument;
import org.dcm4chee.docstore.DocumentStorageListener;
import org.dcm4chee.docstore.Feature;
import org.dcm4chee.docstore.spi.DocumentStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDocumentStorage
implements DocumentStorage {
    private String desc;
    private Set<Feature> features = new HashSet<Feature>();
    private String name;
    private HashSet<DocumentStorageListener> listeners = new HashSet();
    private static Logger log = LoggerFactory.getLogger(BaseDocumentStorage.class);

    public BaseDocumentStorage() {
    }

    public BaseDocumentStorage(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public void setDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public Set<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    @Override
    public boolean hasFeature(Feature feature) {
        return this.features.contains(feature);
    }

    @Override
    public boolean matchFeatures(Set<Feature> features) {
        return this.features.containsAll(features);
    }

    @Override
    public String getRetrieveURL(String docUid) {
        return null;
    }

    @Override
    public void init(String initString) {
    }

    @Override
    public boolean setHash(BaseDocument doc, String hash) {
        log.debug("setHash(BaseDocument doc, String hash) not supported!");
        return false;
    }

    @Override
    public boolean commitDocument(String docUid) {
        log.debug("commitDocument:" + docUid + " ignored (with success status true)!");
        return true;
    }

    @Override
    public boolean deleteDocument(String docUid) {
        log.debug("deleteDocument:" + docUid + " ignored!");
        return false;
    }

    public String toString() {
        return this.getStorageType() + ":" + this.name + "(" + this.desc + ")";
    }

    protected Properties readInitAsProperties(String initString) throws IOException {
        Properties p = new Properties();
        if (initString != null) {
            StringTokenizer st = new StringTokenizer(initString);
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                int pos = s.indexOf(61);
                if (pos == -1) continue;
                p.setProperty(s.substring(0, pos), s.substring(++pos));
            }
        }
        return p;
    }

    @Override
    public boolean addStorageListener(DocumentStorageListener listener) {
        return this.listeners.add(listener);
    }

    protected int getNumberOfListeners() {
        return this.listeners.size();
    }

    protected void notifyStored(BaseDocument doc) {
        for (DocumentStorageListener l : this.listeners) {
            l.documentStored(doc);
        }
    }

    protected void notifyCreated(BaseDocument doc) {
        for (DocumentStorageListener l : this.listeners) {
            l.documentCreated(doc);
        }
    }

    protected void notifyCommitted(BaseDocument doc) {
        for (DocumentStorageListener l : this.listeners) {
            l.documentCommitted(doc);
        }
    }

    protected void notifyDeleted(BaseDocument doc) {
        log.debug("notifyDeleted:" + doc + "\nlisteners" + this.listeners);
        for (DocumentStorageListener l : this.listeners) {
            l.documentDeleted(doc);
        }
    }

    protected void notifyRetrieved(BaseDocument doc) {
        for (DocumentStorageListener l : this.listeners) {
            l.documentRetrieved(doc);
        }
    }

    protected void notifyAvailabilityChanged(Availability oldAvail, Availability newAvail) {
        for (DocumentStorageListener l : this.listeners) {
            l.storageAvailabilityChanged(this, oldAvail, newAvail);
        }
    }
}

