/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.docstore;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.activation.DataHandler;
import org.dcm4chee.docstore.Availability;
import org.dcm4chee.docstore.BaseDocument;
import org.dcm4chee.docstore.DataHandlerVO;
import org.dcm4chee.docstore.DocumentStorageListener;
import org.dcm4chee.docstore.DocumentStorageRegistry;
import org.dcm4chee.docstore.Feature;
import org.dcm4chee.docstore.spi.DocumentStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentStore {
    private static final char[] HEX_STRINGS = "0123456789abcdef".toCharArray();
    private String name;
    private String domain;
    private static HashMap<String, DocumentStore> singletons = new HashMap();
    private Set<DocumentStorage> retrieveDocStorages = new HashSet<DocumentStorage>();
    private static DocumentStorageRegistry registry;
    private static Logger log;

    private DocumentStore(String name, String domain) {
        this.name = name;
        this.domain = domain == null ? name : domain;
        Collection<DocumentStorage> domainStores = registry.getDocumentStorages(domain);
        if (log.isDebugEnabled()) {
            log.debug("Constructor: domainStores(domain=" + domain + "):" + domainStores);
        }
        if (domainStores != null) {
            this.retrieveDocStorages.addAll(domainStores);
        }
    }

    public static void setDocumentStorageRegistry(DocumentStorageRegistry r) {
        if (registry != null) {
            throw new IllegalStateException("DocumentStore already initialized with DocumentStorageRegistry!");
        }
        registry = r;
    }

    public static final DocumentStore getInstance(String name, String domain) {
        return DocumentStore.getInstance(name, domain, null);
    }

    public static final DocumentStore getInstance(String name, String domain, String configUrl) {
        DocumentStore store;
        if (registry == null) {
            registry = new DocumentStorageRegistry();
            registry.config(null);
        }
        if ((store = singletons.get(name)) == null) {
            if (configUrl != null) {
                registry.config(configUrl);
            }
            store = new DocumentStore(name, domain);
            singletons.put(name, store);
        }
        return store;
    }

    public void setRetrieveFeatures(Set<Feature> features) {
        this.retrieveDocStorages.clear();
        for (Set<DocumentStorage> storages : registry.getDocumentStorages(features).values()) {
            this.retrieveDocStorages.addAll(storages);
        }
        if (log.isDebugEnabled()) {
            log.debug("retrieveDocStorages(features=" + features + "):" + this.retrieveDocStorages);
        }
        Collection<DocumentStorage> domainStores = registry.getDocumentStorages(this.domain);
        if (log.isDebugEnabled()) {
            log.debug("setRetrieveFeatures: domainStores(domain=" + this.domain + "):" + domainStores);
        }
        if (domainStores != null) {
            this.retrieveDocStorages.addAll(domainStores);
        }
        if (log.isDebugEnabled()) {
            log.debug("resulting retrieveDocStorages:" + this.retrieveDocStorages);
        }
    }

    public void addStorageListener(DocumentStorageListener listener) {
        Collection<DocumentStorage> domainStores = registry.getDocumentStorages(this.domain);
        if (domainStores != null) {
            for (DocumentStorage store : domainStores) {
                store.addStorageListener(listener);
            }
        } else {
            log.warn("No DocumentStorage in this domain:" + this.domain);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public DocumentStorage getDocStorageFromPool(String pool) {
        return pool == null ? null : this.selectStorageByAvailability(registry.getDocumentStoragesOfPool(pool));
    }

    public DocumentStorage selectDocStorageFromPoolOrDomain(String pool) {
        log.info("pool:" + pool);
        Collection<DocumentStorage> c = null;
        if (pool != null) {
            c = registry.getDocumentStoragesOfPool(pool);
        }
        if (c == null || c.isEmpty()) {
            log.info("domain:" + this.domain);
            c = registry.getDocumentStorages(this.domain);
        }
        log.info("found storages:" + c);
        return this.selectStorageByAvailability(c);
    }

    public DocumentStorage selectStorageByAvailability(Collection<DocumentStorage> storages) {
        if (storages == null || storages.size() < 1) {
            return null;
        }
        DocumentStorage storage = null;
        for (DocumentStorage st : storages) {
            if (storage == null) {
                storage = st;
                continue;
            }
            if (st.getStorageAvailability().compareTo(storage.getStorageAvailability()) >= 0) continue;
            storage = st;
        }
        if (log.isDebugEnabled()) {
            log.debug("selected Storage:" + storage);
        }
        return storage;
    }

    public Set<DocumentStorage> getRetrieveDocStorages() {
        return this.retrieveDocStorages;
    }

    public DocumentStorage getNamedDocStorage(String storageName) {
        return registry.getDocumentStorage(this.domain, storageName);
    }

    public Availability getAvailability(String docUid) {
        log.debug("getAvailability docUid" + docUid);
        Availability bestAvailability = Availability.NONEEXISTENT;
        for (DocumentStorage storage : this.retrieveDocStorages) {
            Availability availability = storage.getAvailabilty(docUid);
            if (availability.compareTo(bestAvailability) >= 0) continue;
            bestAvailability = availability;
        }
        return bestAvailability;
    }

    public BaseDocument getDocument(String docUid, String mime) {
        log.debug("getDocument docUid" + docUid + " mime:" + mime);
        BaseDocument docFound = null;
        for (DocumentStorage storage : this.retrieveDocStorages) {
            try {
                BaseDocument doc = storage.retrieveDocument(docUid, mime);
                if (doc == null) continue;
                log.debug("Document found in " + doc + "! availability:" + doc.getAvailability());
                if (docFound != null && doc.getAvailability().compareTo(docFound.getAvailability()) >= 0) continue;
                docFound = doc;
            }
            catch (IOException x) {
                log.error("Failed to retrieve from storage " + storage.getName() + "! Ignored.", (Throwable)x);
            }
        }
        return docFound;
    }

    public BaseDocument createDocument(String docUid, String mime) throws IOException {
        return this.createDocument(null, docUid, mime);
    }

    public BaseDocument storeDocument(String docUid, DataHandler dh) throws IOException {
        return this.storeDocument(null, docUid, dh);
    }

    public boolean deleteDocument(String docUid) {
        Collection<DocumentStorage> c = registry.getDocumentStorages(this.domain);
        if (c == null) {
            log.warn("Storage domain '" + this.domain + "' does not exist!");
            return false;
        }
        return this.deleteDocumentfromStorages(docUid, c);
    }

    public BaseDocument createDocument(String pool, String docUid, String mime) throws IOException {
        return this.selectDocStorageFromPoolOrDomain(pool).createDocument(docUid, mime);
    }

    public BaseDocument storeDocument(String pool, String docUid, DataHandler dh) throws IOException {
        return this.selectDocStorageFromPoolOrDomain(pool).storeDocument(docUid, dh);
    }

    public BaseDocument[] storeDocuments(String pool, Set<DataHandlerVO> docs) throws IOException {
        DocumentStorage store = this.selectDocStorageFromPoolOrDomain(pool);
        return store.storeDocuments(docs);
    }

    public boolean commitDocument(String pool, String docUid) {
        Set<DocumentStorage> c = registry.getDocumentStoragesOfPool(pool);
        if (c == null) {
            log.warn("Storage pool '" + pool + "' does not exist!");
            return false;
        }
        return this.commitDocumentfromStorages(docUid, c);
    }

    public boolean deleteDocument(String pool, String docUid) {
        Set<DocumentStorage> c = registry.getDocumentStoragesOfPool(pool);
        if (c == null) {
            log.warn("Storage pool '" + pool + "' does not exist!");
            return false;
        }
        return this.deleteDocumentfromStorages(docUid, c);
    }

    private boolean deleteDocumentfromStorages(String docUid, Collection<DocumentStorage> c) {
        boolean deleted = false;
        for (DocumentStorage st : c) {
            deleted |= st.deleteDocument(docUid);
        }
        return deleted;
    }

    public boolean commitDocumentfromStorages(String docUid, Collection<DocumentStorage> c) {
        boolean commited = false;
        for (DocumentStorage st : c) {
            commited |= st.commitDocument(docUid);
        }
        return commited;
    }

    public static final String toHexString(byte[] hash) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            int h = hash[i] & 0xFF;
            sb.append(HEX_STRINGS[h >>> 4]);
            sb.append(HEX_STRINGS[h & 0xF]);
        }
        return sb.toString();
    }

    static {
        log = LoggerFactory.getLogger(DocumentStore.class);
    }
}

