/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.docstore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.imageio.spi.ServiceRegistry;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4chee.docstore.Feature;
import org.dcm4chee.docstore.spi.DocumentStorage;
import org.dcm4chee.docstore.spi.DocumentStorageProviderSPI;
import org.jboss.system.server.ServerConfigLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentStorageRegistry
extends DefaultHandler {
    private static final String CONFIG_URL_PATH = "dcm4chee-docstore/dcm4chee-docstore-cfg.xml";
    private static final String CONFIG_URL = "resource:dcm4chee-docstore/dcm4chee-docstore-cfg.xml";
    private static final String DEFAULT_INITIAL_CONFIG_URL = "resource:conf/dcm4chee-docstore/dcm4chee-docstore-cfg.xml";
    private Map<String, DocumentStorageProviderSPI> docStorageProviders = new HashMap<String, DocumentStorageProviderSPI>();
    private Map<String, Map<String, DocumentStorage>> domainStores = new HashMap<String, Map<String, DocumentStorage>>();
    private Map<String, Set<DocumentStorage>> storePools = new HashMap<String, Set<DocumentStorage>>();
    private String curDomain;
    private Map<String, DocumentStorage> curDomainStores;
    private String storeType;
    private String name;
    private String desc;
    private DocumentStorageProviderSPI provider;
    private DocumentStorage curStore;
    private StringBuilder initStringSB;
    private static Logger log = LoggerFactory.getLogger(DocumentStorageRegistry.class);

    public DocumentStorageRegistry() {
        this.init();
    }

    public void init() {
        Iterator<DocumentStorageProviderSPI> iter = ServiceRegistry.lookupProviders(DocumentStorageProviderSPI.class);
        while (iter.hasNext()) {
            DocumentStorageProviderSPI sp = iter.next();
            this.docStorageProviders.put(sp.getStorageType(), sp);
        }
        log.debug("docStorageProviders:" + this.docStorageProviders);
    }

    public DocumentStorage getDocumentStorageOfType(String type, String name) {
        DocumentStorageProviderSPI sp = this.docStorageProviders.get(type);
        return sp == null ? null : sp.getDocumentStorage(name);
    }

    public Set<String> getAllDocumentStorageProviderNames() {
        return this.docStorageProviders.keySet();
    }

    public DocumentStorage getDocumentStorage(String domain, String name) {
        Map<String, DocumentStorage> map = this.domainStores.get(domain);
        if (map == null) {
            return null;
        }
        if (name == null) {
            return map.size() > 0 ? map.values().iterator().next() : null;
        }
        return map.get(name);
    }

    public Set<String> getDocumentStorageDomains() {
        return this.domainStores.keySet();
    }

    public Collection<DocumentStorage> getDocumentStorages(String domain) {
        Map<String, DocumentStorage> map = this.domainStores.get(domain);
        return map == null ? null : map.values();
    }

    public Map<String, Set<DocumentStorage>> getDocumentStorages(Set<Feature> features) {
        HashMap<String, Set<DocumentStorage>> map = new HashMap<String, Set<DocumentStorage>>();
        if (features == null || features.size() < 1) {
            log.warn("No Feature List specified! Return empty Map!");
            return map;
        }
        for (Map.Entry<String, Map<String, DocumentStorage>> entry : this.domainStores.entrySet()) {
            HashSet<DocumentStorage> l = null;
            for (DocumentStorage store : entry.getValue().values()) {
                if (!store.matchFeatures(features)) continue;
                if (l == null) {
                    l = new HashSet<DocumentStorage>();
                    map.put(entry.getKey(), l);
                }
                l.add(store);
            }
        }
        return map;
    }

    public Set<DocumentStorage> getDocumentStoragesOfPool(String pool) {
        return pool == null ? null : this.storePools.get(pool);
    }

    public void config(String url) {
        if (url == null) {
            url = CONFIG_URL;
        }
        log.info("Start configuration of Document Storage with:" + url);
        try {
            URL cfgUrl = new URL(url);
            try {
                cfgUrl.getContent();
            }
            catch (Exception x) {
                cfgUrl = this.copyDefaultConfigToConf(url);
                url = cfgUrl.toExternalForm();
            }
            SAXParserFactory.newInstance().newSAXParser().parse(url, (DefaultHandler)this);
        }
        catch (Exception x) {
            log.error("Configuration of DocumentStorages failed!", (Throwable)x);
        }
    }

    private URL copyDefaultConfigToConf(String url) throws IOException {
        URL defCfgUrl = new URL(DEFAULT_INITIAL_CONFIG_URL);
        URL cfgDirUrl = ServerConfigLocator.locate().getServerConfigURL();
        File outFile = new File(cfgDirUrl.getPath(), CONFIG_URL_PATH);
        outFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(outFile);
        DataHandler dh = new DataHandler(defCfgUrl);
        dh.writeTo((OutputStream)fos);
        fos.flush();
        fos.close();
        return outFile.toURL();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("DocumentStoreCfg")) {
            log.debug("Root element DocumentStoreCfg found.");
        } else if (qName.equals("StoreDomain")) {
            this.curDomain = attrs.getValue("name");
            this.curDomainStores = new HashMap<String, DocumentStorage>();
        } else if (qName.equals("Store")) {
            String pool;
            this.storeType = attrs.getValue("type");
            this.provider = this.docStorageProviders.get(this.storeType);
            this.name = attrs.getValue("name");
            this.curStore = this.provider.getDocumentStorage(this.name);
            this.curDomainStores.put(this.name, this.curStore);
            this.desc = attrs.getValue("desc");
            if (this.desc != null) {
                this.curStore.setDescription(this.desc);
            }
            if ((pool = attrs.getValue("pool")) != null) {
                Set<DocumentStorage> l = this.storePools.get(pool);
                if (l == null) {
                    l = new HashSet<DocumentStorage>();
                    this.storePools.put(pool, l);
                }
                l.add(this.curStore);
            }
        } else if (qName.equals("Feature")) {
            this.name = attrs.getValue("name");
            this.desc = attrs.getValue("desc");
            this.curStore.addFeature(new Feature(this.name, this.desc));
        } else if (qName.equals("init")) {
            log.debug("init start");
            this.initStringSB = new StringBuilder();
        } else {
            log.debug("unhandled start:" + qName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("DocumentStoreCfg")) {
            log.info("Configuration of Document Storage finished!");
            log.debug("docStorageProviders:" + this.docStorageProviders);
            log.debug("domainStores:" + this.domainStores);
            log.debug("storePools:" + this.storePools);
        } else if (qName.equals("StoreDomain")) {
            if (this.domainStores.put(this.curDomain, this.curDomainStores) != null) {
                log.warn("Storage Configuration for domain " + this.curDomain + " replaced with " + this.curDomainStores);
            }
            this.curDomain = null;
            this.curDomainStores = null;
        } else if (qName.equals("Store")) {
            this.curStore = null;
        } else if (qName.equals("init")) {
            this.curStore.init(this.initStringSB.toString());
            this.initStringSB = null;
            log.debug("init end");
        } else {
            log.debug("unhandled end:" + qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.initStringSB != null) {
            if (log.isDebugEnabled()) {
                log.debug("initString characters:'" + new String(ch, start, length) + "'");
            }
            this.initStringSB.append(new String(ch, start, length));
        }
    }
}

