/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.docstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.dcm4chee.docstore.Availability;
import org.dcm4chee.docstore.spi.DocumentStorage;

public class BaseDocument {
    private String docUid;
    private String mime;
    private DataHandler dh;
    private Availability availability;
    private long size;
    private String hash;
    private DocumentStorage storage;
    private OutputStream out;

    public BaseDocument(String docUid, String mime, DataHandler dh, Availability availability, long size, DocumentStorage storage) {
        this.docUid = docUid;
        this.mime = mime;
        this.dh = dh;
        this.availability = availability;
        this.size = size;
        this.storage = storage;
    }

    public String getDocumentUID() {
        return this.docUid;
    }

    public String getMimeType() {
        return this.mime;
    }

    public long getSize() {
        return this.size;
    }

    public DataHandler getDataHandler() {
        return this.dh;
    }

    public String getHash() {
        return this.hash;
    }

    public InputStream getInputStream() throws IOException {
        return this.dh == null ? null : this.dh.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null && this.dh != null) {
            this.out = this.dh.getOutputStream();
        }
        return this.out;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public DocumentStorage getStorage() {
        return this.storage;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String toString() {
        return "BaseDocument: docUid:" + this.docUid + " mime:" + this.mime + " size:" + this.size + "\nAvailability:" + this.availability + "hash:" + this.hash;
    }
}

