/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.net.URI;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.BindingProvider21;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonClient;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.binding.BindingExt;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.addressing.AddressingClientUtil;
import org.jboss.ws.extensions.wsrm.RMAddressingConstants;
import org.jboss.ws.extensions.wsrm.RMClientSequence;
import org.jboss.ws.extensions.wsrm.RMConstant;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMAckRequested;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequenceResponse;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceAcknowledgement;
import org.jboss.ws.metadata.config.Configurable;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
extends CommonClient
implements org.jboss.ws.extensions.wsrm.api.RMProvider,
BindingProvider21,
Configurable {
    private static Logger log = Logger.getLogger(ClientImpl.class);
    private final ClientEndpointMetaData epMetaData;
    private final HandlerResolver handlerResolver;
    private Map<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor> executorMap = new HashMap<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor>();
    private static UnifiedHandlerMetaData.HandlerType[] HANDLER_TYPES = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
    private RMClientSequence wsrmSequence;

    public final void setWSRMSequence(RMClientSequence wsrmSequence) {
        this.wsrmSequence = wsrmSequence;
    }

    public final RMClientSequence getWSRMSequence() {
        return this.wsrmSequence;
    }

    public ClientImpl(EndpointMetaData epMetaData, HandlerResolver handlerResolver) {
        super(epMetaData);
        this.setTargetEndpointAddress(epMetaData.getEndpointAddress());
        this.epMetaData = (ClientEndpointMetaData)epMetaData;
        this.handlerResolver = handlerResolver;
        this.initBindingHandlerChain(false);
        epMetaData.registerConfigObserver(this);
    }

    private void initBindingHandlerChain(boolean clearExistingHandlers) {
        BindingExt binding = (BindingExt)this.getBindingProvider().getBinding();
        PortInfo portInfo = this.epMetaData.getPortInfo();
        if (this.handlerResolver != null) {
            boolean jbossHandlerResolver = this.handlerResolver instanceof HandlerResolverImpl;
            if (jbossHandlerResolver) {
                HandlerResolverImpl impl = (HandlerResolverImpl)this.handlerResolver;
                impl.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.PRE, clearExistingHandlers);
                impl.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, clearExistingHandlers);
                impl.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.POST, clearExistingHandlers);
                List<Handler> preChain = impl.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.PRE);
                List<Handler> postChain = impl.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.POST);
                binding.setHandlerChain(postChain, UnifiedHandlerMetaData.HandlerType.POST);
                binding.setHandlerChain(preChain, UnifiedHandlerMetaData.HandlerType.PRE);
            }
            List endpointChain = this.handlerResolver.getHandlerChain(portInfo);
            binding.setHandlerChain(endpointChain);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        log.debug((Object)("Configuration change event received. Reconfigure handler chain: " + object));
        this.initBindingHandlerChain(true);
    }

    @Override
    protected boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        BindingExt binding = (BindingExt)this.getBindingProvider().getBinding();
        HandlerChainExecutor executor = new HandlerChainExecutor(this.epMetaData, binding.getHandlerChain(type));
        this.executorMap.put(type, executor);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        return executor.handleMessage(msgContext);
    }

    @Override
    protected boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        return executor != null ? executor.handleMessage(msgContext) : true;
    }

    @Override
    protected boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        return executor != null ? executor.handleFault(msgContext, ex) : true;
    }

    @Override
    protected void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type) {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        HandlerChainExecutor executor = this.executorMap.get(type);
        if (executor != null) {
            executor.close(msgContext);
        }
    }

    @Override
    protected void setInboundContextProperties() {
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        msgContext.put((Object)"javax.xml.ws.binding.attachments.inbound", new HashMap());
        if (msgContext.containsKey((Object)CommonMessageContext.REMOTING_METADATA)) {
            Map remotingMetadata = (Map)msgContext.get((Object)CommonMessageContext.REMOTING_METADATA);
            Integer resposeCode = (Integer)remotingMetadata.get("ResponseCode");
            if (resposeCode != null) {
                msgContext.put((Object)"javax.xml.ws.http.response.code", (Object)resposeCode);
            }
            HashMap<String, List> headers = new HashMap<String, List>();
            for (Map.Entry en : remotingMetadata.entrySet()) {
                if (!(en.getKey() instanceof String) || !(en.getValue() instanceof List)) continue;
                headers.put((String)en.getKey(), (List)en.getValue());
            }
            msgContext.put((Object)"javax.xml.ws.http.response.headers", headers);
        }
    }

    @Override
    protected void setOutboundContextProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        msgContext.put("javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
        msgContext.put("javax.xml.ws.binding.attachments.outbound", (Object)new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(QName opName, Object[] args, Map<String, Object> resContext) throws RemoteException {
        Map wsrmResCtx22;
        LinkedList<QName> outMsgs;
        CommonMessageContext msgContext = new SOAPMessageContextJAXWS();
        MessageContextAssociation.pushMessageContext(msgContext);
        Map reqContext = this.getBindingProvider().getRequestContext();
        if (this.wsrmSequence != null && !RMConstant.PROTOCOL_OPERATION_QNAMES.contains(opName)) {
            if (this.wsrmSequence.getBackPort() != null) {
                Map requestContext = this.getBindingProvider().getRequestContext();
                AddressingProperties addressingProps = (AddressingProperties)requestContext.get("javax.xml.ws.addressing.context.outbound");
                addressingProps.setReplyTo(AddressingBuilder.getAddressingBuilder().newEndpointReference(this.wsrmSequence.getBackPort()));
            }
            HashMap<String, Object> rmRequestContext = new HashMap<String, Object>();
            outMsgs = new LinkedList<QName>();
            this.wsrmSequence.newMessageNumber();
            outMsgs.add(RMProvider.get().getConstants().getSequenceQName());
            outMsgs.add(RMProvider.get().getConstants().getAckRequestedQName());
            if (this.wsrmSequence.isAckRequested()) {
                outMsgs.add(RMProvider.get().getConstants().getSequenceAcknowledgementQName());
            }
            rmRequestContext.put("wsrm.protocolMessages", outMsgs);
            rmRequestContext.put("wsrm.sequenceReference", this.wsrmSequence);
            reqContext.put("wsrm.requestContext", rmRequestContext);
        }
        msgContext.putAll(reqContext);
        try {
            LinkedList<QName> retObj;
            outMsgs = retObj = this.invoke(opName, args, false);
            Object var10_9 = null;
        }
        catch (Exception ex) {
            Map wsrmResCtx22;
            Object var8_30;
            try {
                OperationMetaData opMetaData = this.getOperationMetaData();
                if (opMetaData.isOneWay()) {
                    this.handleOneWayException(opMetaData, ex);
                } else {
                    this.handleRemoteException(opMetaData, ex);
                }
                var8_30 = null;
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Map wsrmResCtx22;
                Object var10_11 = null;
                msgContext = MessageContextAssociation.peekMessageContext();
                if (this.wsrmSequence != null && !RMConstant.PROTOCOL_OPERATION_QNAMES.contains(opName) && (wsrmResCtx22 = (Map)msgContext.get("wsrm.responseContext")) != null) {
                    RMConstants wsrmConstants = RMProvider.get().getConstants();
                    Map mapping = (Map)wsrmResCtx22.get("wsrm.protocolMessagesMapping");
                    QName seq = wsrmConstants.getSequenceQName();
                    if (mapping.keySet().contains(seq)) {
                        RMHelper.handleSequenceHeader((RMSequence)mapping.get(seq), this.wsrmSequence);
                    }
                    QName seqAck = wsrmConstants.getSequenceAcknowledgementQName();
                    if (mapping.keySet().contains(seqAck)) {
                        RMHelper.handleSequenceAcknowledgementHeader((RMSequenceAcknowledgement)mapping.get(seqAck), this.wsrmSequence);
                    }
                    QName ackReq = wsrmConstants.getAckRequestedQName();
                    if (mapping.keySet().contains(ackReq)) {
                        RMHelper.handleAckRequestedHeader((RMAckRequested)mapping.get(ackReq), this.wsrmSequence);
                    }
                }
                for (String key : msgContext.keySet()) {
                    Object value = msgContext.get(key);
                    resContext.put(key, value);
                }
                MessageContextAssociation.popMessageContext();
                throw throwable;
            }
            msgContext = MessageContextAssociation.peekMessageContext();
            if (this.wsrmSequence != null && !RMConstant.PROTOCOL_OPERATION_QNAMES.contains(opName) && (wsrmResCtx22 = (Map)msgContext.get("wsrm.responseContext")) != null) {
                RMConstants wsrmConstants = RMProvider.get().getConstants();
                Map mapping = (Map)wsrmResCtx22.get("wsrm.protocolMessagesMapping");
                QName seq = wsrmConstants.getSequenceQName();
                if (mapping.keySet().contains(seq)) {
                    RMHelper.handleSequenceHeader((RMSequence)mapping.get(seq), this.wsrmSequence);
                }
                QName seqAck = wsrmConstants.getSequenceAcknowledgementQName();
                if (mapping.keySet().contains(seqAck)) {
                    RMHelper.handleSequenceAcknowledgementHeader((RMSequenceAcknowledgement)mapping.get(seqAck), this.wsrmSequence);
                }
                QName ackReq = wsrmConstants.getAckRequestedQName();
                if (mapping.keySet().contains(ackReq)) {
                    RMHelper.handleAckRequestedHeader((RMAckRequested)mapping.get(ackReq), this.wsrmSequence);
                }
            }
            for (String key : msgContext.keySet()) {
                Object value = msgContext.get(key);
                resContext.put(key, value);
            }
            MessageContextAssociation.popMessageContext();
            return var8_30;
        }
        msgContext = MessageContextAssociation.peekMessageContext();
        if (this.wsrmSequence != null && !RMConstant.PROTOCOL_OPERATION_QNAMES.contains(opName) && (wsrmResCtx22 = (Map)msgContext.get("wsrm.responseContext")) != null) {
            RMConstants wsrmConstants = RMProvider.get().getConstants();
            Map mapping = (Map)wsrmResCtx22.get("wsrm.protocolMessagesMapping");
            QName seq = wsrmConstants.getSequenceQName();
            if (mapping.keySet().contains(seq)) {
                RMHelper.handleSequenceHeader((RMSequence)mapping.get(seq), this.wsrmSequence);
            }
            QName seqAck = wsrmConstants.getSequenceAcknowledgementQName();
            if (mapping.keySet().contains(seqAck)) {
                RMHelper.handleSequenceAcknowledgementHeader((RMSequenceAcknowledgement)mapping.get(seqAck), this.wsrmSequence);
            }
            QName ackReq = wsrmConstants.getAckRequestedQName();
            if (mapping.keySet().contains(ackReq)) {
                RMHelper.handleAckRequestedHeader((RMAckRequested)mapping.get(ackReq), this.wsrmSequence);
            }
        }
        for (String key : msgContext.keySet()) {
            Object value = msgContext.get(key);
            resContext.put(key, value);
        }
        MessageContextAssociation.popMessageContext();
        return outMsgs;
    }

    @Override
    protected CommonMessageContext processPivot(CommonMessageContext reqMessageContext) {
        MessageContextJAXWS resMessageContext = MessageContextJAXWS.processPivot(reqMessageContext);
        return resMessageContext;
    }

    private void handleOneWayException(OperationMetaData opMetaData, Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        throw new WebServiceException((Throwable)ex);
    }

    private void handleRemoteException(OperationMetaData opMetaData, Exception ex) {
        String bindingId = opMetaData.getEndpointMetaData().getBindingId();
        if (bindingId.startsWith("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingId.startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            if (ex instanceof SOAPFaultException) {
                throw (SOAPFaultException)ex;
            }
            if (ex instanceof WebServiceException) {
                throw (WebServiceException)ex;
            }
            throw new WebServiceException((Throwable)ex);
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingId)) {
            HTTPException wsEx = new HTTPException(-1);
            wsEx.initCause((Throwable)ex);
            throw wsEx;
        }
        throw new WebServiceException("Unsuported binding: " + bindingId, (Throwable)ex);
    }

    @Override
    public void setTargetEndpointAddress(String endpointAddress) {
        this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
    }

    @Override
    public String getTargetEndpointAddress() {
        return (String)this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    @Override
    protected CommonBindingProvider getCommonBindingProvider() {
        if (this.bindingProvider == null) {
            this.bindingProvider = new BindingProviderImpl(this.getEndpointMetaData());
        }
        return this.bindingProvider;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        return this.getBindingProvider().getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return this.getBindingProvider().getResponseContext();
    }

    public Binding getBinding() {
        return this.getBindingProvider().getBinding();
    }

    public BindingProvider getBindingProvider() {
        return (BindingProvider)this.getCommonBindingProvider();
    }

    public EndpointReference getEndpointReference() {
        throw new NotImplementedException();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        throw new NotImplementedException();
    }

    @Override
    public void setConfigName(String configName, String configFile) {
        EndpointMetaData configProvider = this.getEndpointMetaData();
        configProvider.setConfigName(configName, configFile);
    }

    @Override
    public Set<QName> getHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        BindingExt binding = (BindingExt)this.getBinding();
        for (UnifiedHandlerMetaData.HandlerType type : HANDLER_TYPES) {
            for (Handler bindingHandler : binding.getHandlerChain(type)) {
                if (!(bindingHandler instanceof SOAPHandler)) continue;
                headers.addAll(((SOAPHandler)bindingHandler).getHeaders());
            }
        }
        return headers;
    }

    @Override
    protected boolean shouldMaintainSession() {
        Object bool = this.getRequestContext().get("javax.xml.ws.session.maintain");
        return Boolean.TRUE.equals(bool);
    }

    @Override
    public void createSequence() throws RMException {
        if (this.wsrmSequence != null) {
            throw new IllegalStateException("Sequence already registered with proxy instance");
        }
        try {
            RMClientSequence candidateSequence = new RMClientSequence(this.getEndpointMetaData().getConfig().getRMMetaData());
            String address = this.getEndpointMetaData().getEndpointAddress();
            String action = RMAddressingConstants.CREATE_SEQUENCE_WSA_ACTION;
            AddressingProperties addressingProps = null;
            URI backPort = candidateSequence.getBackPort();
            if (backPort != null) {
                addressingProps = AddressingClientUtil.createDefaultProps(action, address);
                addressingProps.setReplyTo(AddressingBuilder.getAddressingBuilder().newEndpointReference(backPort));
            } else {
                addressingProps = AddressingClientUtil.createAnonymousProps(action, address);
            }
            Map requestContext = this.getBindingProvider().getRequestContext();
            requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProps);
            QName createSequenceQN = RMProvider.get().getConstants().getCreateSequenceQName();
            HashMap<String, Object> rmRequestContext = new HashMap<String, Object>();
            LinkedList<QName> outMsgs = new LinkedList<QName>();
            outMsgs.add(createSequenceQN);
            rmRequestContext.put("wsrm.protocolMessages", outMsgs);
            rmRequestContext.put("wsrm.sequenceReference", candidateSequence);
            requestContext.put("wsrm.requestContext", rmRequestContext);
            this.invoke(createSequenceQN, new Object[0], this.getBindingProvider().getResponseContext());
            Map rmResponseContext = (Map)this.getBindingProvider().getResponseContext().get("wsrm.responseContext");
            RMCreateSequenceResponse createSequenceResponse = (RMCreateSequenceResponse)((Map)rmResponseContext.get("wsrm.protocolMessagesMapping")).get(RMProvider.get().getConstants().getCreateSequenceResponseQName());
            String outboundId = createSequenceResponse.getIdentifier();
            candidateSequence.setClient(this);
            candidateSequence.setOutboundId(outboundId);
            candidateSequence.setBehavior(createSequenceResponse.getIncompleteSequenceBehavior());
            candidateSequence.setDuration(RMHelper.durationToLong(createSequenceResponse.getExpires()));
            this.wsrmSequence = candidateSequence;
        }
        catch (Exception e) {
            throw new RMException("Unable to create WSRM sequence", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSequence() {
        try {
            this.wsrmSequence.close();
            Object var2_1 = null;
            this.wsrmSequence = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.wsrmSequence = null;
            throw throwable;
        }
    }
}

