/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.WSException;
import org.jboss.ws.core.HTTPMessageImpl;

public class HTTPMessageUnMarshaller
implements UnMarshaller {
    private static Logger log = Logger.getLogger(HTTPMessageUnMarshaller.class);
    private static List validResponseCodes = new ArrayList();

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        Integer resCode = (Integer)metadata.get("ResponseCode");
        String resMessage = (String)metadata.get("ResponseCodeMessage");
        if (resCode != null && !validResponseCodes.contains(resCode)) {
            throw new WSException("Invalid HTTP server response [" + resCode + "] - " + resMessage);
        }
        MimeHeaders mimeHeaders = this.getMimeHeaders(metadata);
        HTTPMessageImpl soapMsg = new HTTPMessageImpl(mimeHeaders, inputStream);
        return soapMsg;
    }

    public void setClassLoader(ClassLoader classloader) {
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        return new HTTPMessageUnMarshaller();
    }

    private MimeHeaders getMimeHeaders(Map metadata) {
        log.debug((Object)("getMimeHeaders from: " + metadata));
        MimeHeaders headers = new MimeHeaders();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key == null || !(value instanceof List)) continue;
            for (Object listValue : (List)value) {
                headers.addHeader(key, listValue.toString());
            }
        }
        return headers;
    }

    static {
        validResponseCodes.add(200);
        validResponseCodes.add(202);
        validResponseCodes.add(500);
    }
}

