/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;

public class UserAuthenticationMessage
extends AuditMessage {
    public static final AuditEvent.TypeCode LOGIN = AuditEvent.TypeCode.LOGIN;
    public static final AuditEvent.TypeCode LOGOUT = AuditEvent.TypeCode.LOGOUT;

    public UserAuthenticationMessage(AuditEvent.TypeCode typeCode) {
        super(new AuditEvent(AuditEvent.ID.USER_AUTHENTICATION, AuditEvent.ActionCode.EXECUTE).addEventTypeCode(UserAuthenticationMessage.check(typeCode)));
    }

    private static AuditEvent.TypeCode check(AuditEvent.TypeCode typeCode) {
        if (typeCode == null) {
            throw new NullPointerException("typeCode");
        }
        if (typeCode != AuditEvent.TypeCode.LOGIN && typeCode != AuditEvent.TypeCode.LOGOUT) {
            throw new IllegalArgumentException(typeCode.toString());
        }
        return typeCode;
    }

    public ActiveParticipant addUserPerson(String userID, String altUserID, String userName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, true));
    }

    public ActiveParticipant addNode(String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveNode(hostname, false));
    }

    public void validate() {
        super.validate();
        ActiveParticipant user = this.getRequestingActiveParticipants();
        if (user == null) {
            throw new IllegalStateException("No Requesting User Information");
        }
    }
}

