/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;

public class StudyDeletedMessage
extends AuditMessage {
    public StudyDeletedMessage() {
        super(new AuditEvent(AuditEvent.ID.DICOM_STUDY_DELETED, AuditEvent.ActionCode.DELETE));
    }

    public ActiveParticipant addUserPerson(String userID, String altUserID, String userName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor));
    }

    public ActiveParticipant addUserProcess(String processID, String[] aets, String processName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor));
    }

    public ParticipantObject addPatient(String id, String name) {
        return this.addParticipantObject(ParticipantObject.createPatient(id, name));
    }

    public ParticipantObject addStudy(String uid, ParticipantObjectDescription desc) {
        return this.addParticipantObject(ParticipantObject.createStudy(uid, desc));
    }

    public void validate() {
        super.validate();
        ActiveParticipant user = this.getRequestingActiveParticipants();
        if (user == null) {
            throw new IllegalStateException("No Requesting User");
        }
        ParticipantObject patient = null;
        ParticipantObject study = null;
        for (ParticipantObject po : this.participantObjects) {
            if (ParticipantObject.TypeCodeRole.PATIENT == po.getParticipantObjectTypeCodeRole()) {
                if (patient != null) {
                    throw new IllegalStateException("Multiple Patient identification");
                }
                patient = po;
                continue;
            }
            if (ParticipantObject.TypeCodeRole.REPORT != po.getParticipantObjectTypeCodeRole() || ParticipantObject.IDTypeCode.STUDY_INSTANCE_UID != po.getParticipantObjectIDTypeCode()) continue;
            study = po;
        }
        if (patient == null) {
            throw new IllegalStateException("No Patient identification");
        }
        if (study == null) {
            throw new IllegalStateException("No Study identification");
        }
    }
}

