/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;

public class SecurityAlertMessage
extends AuditMessage {
    public static final AuditEvent.TypeCode NODE_AUTHENTICATION = AuditEvent.TypeCode.NODE_AUTHENTICATION;
    public static final AuditEvent.TypeCode EMERGENCY_OVERRIDE_STARTED = AuditEvent.TypeCode.EMERGENCY_OVERRIDE_STARTED;
    public static final AuditEvent.TypeCode NETWORK_CONFIGURATION = AuditEvent.TypeCode.NETWORK_CONFIGURATION;
    public static final AuditEvent.TypeCode SECURITY_CONFIGURATION = AuditEvent.TypeCode.SECURITY_CONFIGURATION;
    public static final AuditEvent.TypeCode HARDWARE_CONFIGURATION = AuditEvent.TypeCode.HARDWARE_CONFIGURATION;
    public static final AuditEvent.TypeCode SOFTWARE_CONFIGURATION = AuditEvent.TypeCode.SOFTWARE_CONFIGURATION;
    public static final AuditEvent.TypeCode USE_OF_RESTRICTED_FUNCTION = AuditEvent.TypeCode.USE_OF_RESTRICTED_FUNCTION;
    public static final AuditEvent.TypeCode AUDIT_RECORDING_STOPPED = AuditEvent.TypeCode.AUDIT_RECORDING_STOPPED;
    public static final AuditEvent.TypeCode AUDIT_RECORDING_STARTED = AuditEvent.TypeCode.AUDIT_RECORDING_STARTED;
    public static final AuditEvent.TypeCode OBJECT_SECURITY_ATTRIBUTES_CHANGED = AuditEvent.TypeCode.OBJECT_SECURITY_ATTRIBUTES_CHANGED;
    public static final AuditEvent.TypeCode SECURITY_ROLES_CHANGED = AuditEvent.TypeCode.SECURITY_ROLES_CHANGED;
    public static final AuditEvent.TypeCode USER_SECURITY_ATTRIBUTES_CHANGED = AuditEvent.TypeCode.USER_SECURITY_ATTRIBUTES_CHANGED;
    public static final AuditEvent.TypeCode EMERGENCY_OVERRIDE_STOPPED = AuditEvent.TypeCode.EMERGENCY_OVERRIDE_STOPPED;
    public static final AuditEvent.TypeCode REMOTE_SERVICE_OPERATION_STARTED = AuditEvent.TypeCode.REMOTE_SERVICE_OPERATION_STARTED;
    public static final AuditEvent.TypeCode REMOTE_SERVICE_OPERATION_STOPPED = AuditEvent.TypeCode.REMOTE_SERVICE_OPERATION_STOPPED;
    public static final AuditEvent.TypeCode LOCAL_SERVICE_OPERATION_STARTED = AuditEvent.TypeCode.LOCAL_SERVICE_OPERATION_STARTED;
    public static final AuditEvent.TypeCode LOCAL_SERVICE_OPERATION_STOPPED = AuditEvent.TypeCode.LOCAL_SERVICE_OPERATION_STOPPED;

    public SecurityAlertMessage(AuditEvent.TypeCode type) {
        super(new AuditEvent(AuditEvent.ID.SECURITY_ALERT, AuditEvent.ActionCode.EXECUTE).addEventTypeCode(SecurityAlertMessage.check(type)));
    }

    private static AuditEvent.TypeCode check(AuditEvent.TypeCode typeCode) {
        if (typeCode == null) {
            throw new NullPointerException("typeCode");
        }
        return typeCode;
    }

    public ActiveParticipant addReportingPerson(String userID, String altUserID, String userName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, true));
    }

    public ActiveParticipant addReportingProcess(String processID, String[] aets, String processName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, true));
    }

    public ActiveParticipant addPerformingPerson(String userID, String altUserID, String userName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, false));
    }

    public ActiveParticipant addPerformingProcess(String processID, String[] aets, String processName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, false));
    }

    public ActiveParticipant addPerformingNode(String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveNode(hostname, false));
    }

    public ParticipantObject addAlertSubjectWithURI(String uri, String desc) {
        return this.addParticipantObject(ParticipantObject.createAlertSubjectWithURI(uri, desc));
    }

    public ParticipantObject addAlertSubjectWithNodeID(String nodeID, String desc) {
        return this.addParticipantObject(ParticipantObject.createAlertSubjectWithNodeID(nodeID, desc));
    }

    public void validate() {
        super.validate();
        ActiveParticipant user = this.getRequestingActiveParticipants();
        if (user == null) {
            throw new IllegalStateException("No Reporting User");
        }
    }
}

