/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che2.audit.message.Base64Encoder;
import org.dcm4che2.audit.message.BaseElement;
import org.dcm4che2.audit.message.CodeElement;
import org.dcm4che2.audit.message.ParticipantObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantObject
extends BaseElement {
    private final IDTypeCode idTypeCode;
    private Name name;
    private Query query;
    private final ArrayList<Detail> details = new ArrayList();
    private final ArrayList<ParticipantObjectDescription> descs = new ArrayList();

    public ParticipantObject(String id, IDTypeCode idTypeCode) {
        super("ParticipantObjectIdentification");
        if (idTypeCode == null) {
            throw new NullPointerException("idTypeCode");
        }
        this.addAttribute("ParticipantObjectID", id, false);
        this.idTypeCode = idTypeCode;
    }

    public final String getParticipantObjectID() {
        return (String)this.getAttribute("ParticipantObjectID");
    }

    public final IDTypeCode getParticipantObjectIDTypeCode() {
        return this.idTypeCode;
    }

    public final TypeCode getParticipantObjectTypeCode() {
        return (TypeCode)this.getAttribute("ParticipantObjectTypeCode");
    }

    public final ParticipantObject setParticipantObjectTypeCode(TypeCode code) {
        this.addAttribute("ParticipantObjectTypeCode", code, true);
        return this;
    }

    public final TypeCodeRole getParticipantObjectTypeCodeRole() {
        return (TypeCodeRole)this.getAttribute("ParticipantObjectTypeCodeRole");
    }

    public final ParticipantObject setParticipantObjectTypeCodeRole(TypeCodeRole code) {
        this.addAttribute("ParticipantObjectTypeCodeRole", code, true);
        return this;
    }

    public final DataLifeCycle getParticipantObjectDataLifeCycle() {
        return (DataLifeCycle)this.getAttribute("ParticipantObjectDataLifeCycle");
    }

    public final ParticipantObject setParticipantObjectDataLifeCycle(DataLifeCycle code) {
        this.addAttribute("ParticipantObjectDataLifeCycle", code, true);
        return this;
    }

    public final String getParticipantObjectSensitivity() {
        return (String)this.getAttribute("ParticipantObjectSensitivity");
    }

    public final ParticipantObject setParticipantObjectSensitivity(String sensitivity) {
        this.addAttribute("ParticipantObjectSensitivity", sensitivity, true);
        return this;
    }

    public final String getParticipantObjectName() {
        return this.name != null ? this.name.value() : null;
    }

    public final ParticipantObject setParticipantObjectName(String name) {
        if (name == null || name.length() == 0) {
            this.name = null;
        } else {
            if (this.query != null) {
                throw new IllegalStateException("Cannot set ParticipantObjectName and ParticipantObjectQuery");
            }
            this.name = new Name(name);
        }
        return this;
    }

    public final byte[] getParticipantObjectQuery() {
        return this.query != null ? this.query.value() : null;
    }

    public final ParticipantObject setParticipantObjectQuery(byte[] query) {
        if (query == null || query.length == 0) {
            this.query = null;
        } else {
            if (this.name != null) {
                throw new IllegalStateException("Cannot set ParticipantObjectName and ParticipantObjectQuery");
            }
            this.query = new Query(query);
        }
        return this;
    }

    public List<Detail> getParticipantObjectDetails() {
        return Collections.unmodifiableList(this.details);
    }

    public ParticipantObject addParticipantObjectDetail(String type, String value) {
        this.details.add(new Detail(type, value));
        return this;
    }

    public ParticipantObject addParticipantObjectDetail(String type, byte[] value) {
        this.details.add(new Detail(type, value));
        return this;
    }

    public List<ParticipantObjectDescription> getParticipantObjectDescriptions() {
        return Collections.unmodifiableList(this.descs);
    }

    public ParticipantObject addParticipantObjectDescription(ParticipantObjectDescription desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.descs.add(desc);
        return this;
    }

    @Override
    protected boolean isEmpty() {
        return false;
    }

    @Override
    protected void outputContent(Writer out) throws IOException {
        this.idTypeCode.output(out);
        if (this.name != null) {
            this.name.output(out);
        }
        if (this.query != null) {
            this.query.output(out);
        }
        this.outputChilds(out, this.details);
        this.outputChilds(out, this.descs);
    }

    public static ParticipantObject createPatient(String id, String name) {
        ParticipantObject pat = new ParticipantObject(id, IDTypeCode.PATIENT_ID);
        pat.setParticipantObjectTypeCode(TypeCode.PERSON);
        pat.setParticipantObjectTypeCodeRole(TypeCodeRole.PATIENT);
        pat.setParticipantObjectName(name);
        return pat;
    }

    public static ParticipantObject createStudy(String uid, ParticipantObjectDescription desc) {
        ParticipantObject study = new ParticipantObject(uid, IDTypeCode.STUDY_INSTANCE_UID);
        study.setParticipantObjectTypeCode(TypeCode.SYSTEM);
        study.setParticipantObjectTypeCodeRole(TypeCodeRole.REPORT);
        if (desc != null) {
            study.addParticipantObjectDescription(desc);
        }
        return study;
    }

    public static ParticipantObject createDataRepository(String uri) {
        ParticipantObject obj = new ParticipantObject(uri, IDTypeCode.URI);
        obj.setParticipantObjectTypeCode(TypeCode.SYSTEM);
        obj.setParticipantObjectTypeCodeRole(TypeCodeRole.DATA_REPOSITORY);
        return obj;
    }

    public static ParticipantObject createQuerySOPClass(String cuid, String tsuid, byte[] query) {
        ParticipantObject queryObj = new ParticipantObject(cuid, IDTypeCode.SOP_CLASS_UID);
        queryObj.setParticipantObjectTypeCode(TypeCode.SYSTEM);
        queryObj.setParticipantObjectTypeCodeRole(TypeCodeRole.REPORT);
        queryObj.setParticipantObjectQuery(query);
        queryObj.addParticipantObjectDetail("TransferSyntax", tsuid);
        return queryObj;
    }

    public static ParticipantObject createSecurityAuditLog(String uri) {
        ParticipantObject obj = new ParticipantObject(uri, IDTypeCode.URI);
        obj.setParticipantObjectTypeCode(TypeCode.SYSTEM);
        obj.setParticipantObjectTypeCodeRole(TypeCodeRole.SECURITY_RESOURCE);
        obj.setParticipantObjectName("Security Audit Log");
        return obj;
    }

    public static ParticipantObject createAlertSubject(String id, IDTypeCode idTypeCode, String desc) {
        ParticipantObject obj = new ParticipantObject(id, idTypeCode);
        obj.setParticipantObjectTypeCode(TypeCode.SYSTEM);
        obj.addParticipantObjectDetail("AlertDescription", desc);
        return obj;
    }

    public static ParticipantObject createAlertSubjectWithURI(String uri, String desc) {
        return ParticipantObject.createAlertSubject(uri, IDTypeCode.URI, desc);
    }

    public static ParticipantObject createAlertSubjectWithNodeID(String nodeID, String desc) {
        return ParticipantObject.createAlertSubject(nodeID, IDTypeCode.NODE_ID, desc);
    }

    public static class Detail
    extends BaseElement {
        public Detail(String type, byte[] value) {
            super("ParticipantObjectDetail");
            this.addAttribute("type", type, false);
            this.addAttribute("value", (byte[])value.clone(), false);
        }

        public Detail(String type, String value) {
            super("ParticipantObjectDetail");
            this.addAttribute("type", type, false);
            try {
                this.addAttribute("value", value.getBytes("UTF-8"), false);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        public final String getType() {
            return (String)this.getAttribute("type");
        }

        public final byte[] getValue() {
            return (byte[])((byte[])this.getAttribute("value")).clone();
        }

        public final String getValueAsString() {
            try {
                return new String((byte[])this.getAttribute("value"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
    }

    private static class Query
    extends BaseElement {
        private final byte[] value;

        private Query(byte[] value) {
            super("ParticipantObjectQuery");
            if (value.length == 0) {
                throw new IllegalArgumentException("value cannot be empty");
            }
            this.value = (byte[])value.clone();
        }

        public final byte[] value() {
            return (byte[])this.value.clone();
        }

        protected boolean isEmpty() {
            return false;
        }

        protected void outputContent(Writer out) throws IOException {
            out.write(Base64Encoder.encode(this.value));
        }
    }

    private static class Name
    extends BaseElement {
        private final String value;

        private Name(String value) {
            super("ParticipantObjectName");
            if (value.length() == 0) {
                throw new IllegalArgumentException("value cannot be empty");
            }
            this.value = value;
        }

        public final String value() {
            return this.value;
        }

        protected boolean isEmpty() {
            return false;
        }

        protected void outputContent(Writer out) throws IOException {
            Name.outputEscaped(out, this.value, "'");
        }
    }

    public static class DataLifeCycle {
        private final String value;
        public static final DataLifeCycle CREATION = new DataLifeCycle("1");
        public static final DataLifeCycle IMPORT = new DataLifeCycle("2");
        public static final DataLifeCycle AMENDMENT = new DataLifeCycle("3");
        public static final DataLifeCycle VERIFICATION = new DataLifeCycle("4");
        public static final DataLifeCycle TRANSLATION = new DataLifeCycle("5");
        public static final DataLifeCycle ACCESS = new DataLifeCycle("6");
        public static final DataLifeCycle DE_IDENTIFICATION = new DataLifeCycle("7");
        public static final DataLifeCycle AGGREGATION = new DataLifeCycle("8");
        public static final DataLifeCycle REPORT = new DataLifeCycle("9");
        public static final DataLifeCycle EXPORT = new DataLifeCycle("10");
        public static final DataLifeCycle DISCLOSURE = new DataLifeCycle("11");
        public static final DataLifeCycle RECEIPT_OF_DISCLOSURE = new DataLifeCycle("12");
        public static final DataLifeCycle ARCHIVING = new DataLifeCycle("13");
        public static final DataLifeCycle LOGICAL_DELETION = new DataLifeCycle("14");
        public static final DataLifeCycle PHYSICAL_DESTRUCTION = new DataLifeCycle("15");

        private DataLifeCycle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class TypeCodeRole {
        private final String value;
        public static final TypeCodeRole PATIENT = new TypeCodeRole("1");
        public static final TypeCodeRole LOCATION = new TypeCodeRole("2");
        public static final TypeCodeRole REPORT = new TypeCodeRole("3");
        public static final TypeCodeRole RESOURCE = new TypeCodeRole("4");
        public static final TypeCodeRole MASTER_FILE = new TypeCodeRole("5");
        public static final TypeCodeRole USER = new TypeCodeRole("6");
        public static final TypeCodeRole LIST = new TypeCodeRole("7");
        public static final TypeCodeRole DOCTOR = new TypeCodeRole("8");
        public static final TypeCodeRole SUBSCRIBER = new TypeCodeRole("9");
        public static final TypeCodeRole GUARANTOR = new TypeCodeRole("10");
        public static final TypeCodeRole SECURITY_USER_ENTITY = new TypeCodeRole("11");
        public static final TypeCodeRole SECURITY_USER_GROUP = new TypeCodeRole("12");
        public static final TypeCodeRole SECURITY_RESOURCE = new TypeCodeRole("13");
        public static final TypeCodeRole SECURITY_GRANULARITY_DEFINITION = new TypeCodeRole("14");
        public static final TypeCodeRole PROVIDER = new TypeCodeRole("15");
        public static final TypeCodeRole DATA_DESTINATION = new TypeCodeRole("16");
        public static final TypeCodeRole DATA_REPOSITORY = new TypeCodeRole("17");
        public static final TypeCodeRole SCHEDULE = new TypeCodeRole("18");
        public static final TypeCodeRole CUSTOMER = new TypeCodeRole("19");
        public static final TypeCodeRole JOB = new TypeCodeRole("20");
        public static final TypeCodeRole JOB_STREAM = new TypeCodeRole("21");
        public static final TypeCodeRole TABLE = new TypeCodeRole("22");
        public static final TypeCodeRole ROUTING_CRITERIA = new TypeCodeRole("23");
        public static final TypeCodeRole QUERY = new TypeCodeRole("24");

        private TypeCodeRole(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class TypeCode {
        private final String value;
        public static final TypeCode PERSON = new TypeCode("1");
        public static final TypeCode SYSTEM = new TypeCode("2");
        public static final TypeCode ORGANIZATION = new TypeCode("3");
        public static final TypeCode OTHER = new TypeCode("4");

        private TypeCode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class IDTypeCode
    extends CodeElement {
        public static final IDTypeCode MEDIAL_RECORD_NUMBER = new IDTypeCode("1");
        public static final IDTypeCode PATIENT_ID = new IDTypeCode("2");
        public static final IDTypeCode ENCOUNTER_NUMBER = new IDTypeCode("3");
        public static final IDTypeCode ENROLLEE_NUMBER = new IDTypeCode("4");
        public static final IDTypeCode SOCIAL_SECURITY_NUMBER = new IDTypeCode("5");
        public static final IDTypeCode ACCOUNT_NUMBER = new IDTypeCode("6");
        public static final IDTypeCode GUARANTOR_NUMBER = new IDTypeCode("7");
        public static final IDTypeCode REPORT_NAME = new IDTypeCode("8");
        public static final IDTypeCode REPORT_NUMBER = new IDTypeCode("9");
        public static final IDTypeCode SEARCH_CRITERIA = new IDTypeCode("10");
        public static final IDTypeCode USER_IDENTIFIER = new IDTypeCode("11");
        public static final IDTypeCode URI = new IDTypeCode("12");
        public static final IDTypeCode STUDY_INSTANCE_UID = new IDTypeCode("110180", "DCM", "Study Instance UID");
        public static final IDTypeCode SOP_CLASS_UID = new IDTypeCode("110181", "DCM", "SOP Class UID");
        public static final IDTypeCode NODE_ID = new IDTypeCode("110182", "DCM", "Node ID");

        private IDTypeCode(String typeCode) {
            super("ParticipantObjectIDTypeCode", typeCode);
        }

        public IDTypeCode(String code, String codeSystemName, String displayName) {
            super("ParticipantObjectIDTypeCode", code, codeSystemName, displayName);
        }
    }
}

