/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;

public class NetworkEntryMessage
extends AuditMessage {
    public static final AuditEvent.TypeCode ATTACH = AuditEvent.TypeCode.ATTACH;
    public static final AuditEvent.TypeCode DETACH = AuditEvent.TypeCode.DETACH;

    public NetworkEntryMessage(AuditEvent.TypeCode type) {
        super(new AuditEvent(AuditEvent.ID.NETWORK_ENTRY, AuditEvent.ActionCode.EXECUTE).addEventTypeCode(NetworkEntryMessage.check(type)));
    }

    private static AuditEvent.TypeCode check(AuditEvent.TypeCode type) {
        if (type != AuditEvent.TypeCode.ATTACH && type != AuditEvent.TypeCode.DETACH) {
            throw new IllegalArgumentException(type.toString());
        }
        return type;
    }

    public ActiveParticipant addNode(String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveNode(hostname, false));
    }
}

