/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.util.List;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;

public class DataImportMessage
extends AuditMessage {
    public DataImportMessage() {
        super(new AuditEvent(AuditEvent.ID.IMPORT, AuditEvent.ActionCode.CREATE));
    }

    public ActiveParticipant addImporterPerson(String userID, String altUserID, String userName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor)).addRoleIDCode(ActiveParticipant.RoleIDCode.DESTINATION);
    }

    public ActiveParticipant addImporterProcess(String processID, String[] aets, String processName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor).addRoleIDCode(ActiveParticipant.RoleIDCode.DESTINATION));
    }

    public ActiveParticipant addSourceMedia(String mediaID, String mediaUID) {
        return this.addActiveParticipant(ActiveParticipant.createMedia(mediaID, mediaUID).addRoleIDCode(ActiveParticipant.RoleIDCode.SOURCE_MEDIA));
    }

    public ActiveParticipant addSourceMedia(String userID, String altUserID, String userName, boolean requestor, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor)).addRoleIDCode(ActiveParticipant.RoleIDCode.SOURCE_MEDIA);
    }

    public ParticipantObject addPatient(String id, String name) {
        return this.addParticipantObject(ParticipantObject.createPatient(id, name));
    }

    public ParticipantObject addStudy(String uid, ParticipantObjectDescription desc) {
        return this.addParticipantObject(ParticipantObject.createStudy(uid, desc));
    }

    public void validate() {
        super.validate();
        ActiveParticipant importer = null;
        ActiveParticipant source = null;
        ActiveParticipant requestor = null;
        for (ActiveParticipant ap : this.activeParticipants) {
            List<ActiveParticipant.RoleIDCode> roleIDCodeIDs = ap.getRoleIDCodes();
            if (roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.DESTINATION)) {
                importer = ap;
            } else if (roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.SOURCE_MEDIA)) {
                if (source != null) {
                    throw new IllegalStateException("Multiple Source identification");
                }
                source = ap;
            }
            if (!ap.isUserIsRequestor()) continue;
            requestor = ap;
        }
        if (importer == null) {
            throw new IllegalStateException("No Importer identification");
        }
        if (source == null) {
            throw new IllegalStateException("No Source identification");
        }
        if (requestor == null) {
            throw new IllegalStateException("No Requesting User");
        }
    }
}

