/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.Base64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseElement {
    protected final String name;
    private Attr firstAttr;

    public BaseElement(String name) {
        this.name = name;
    }

    public BaseElement(String name, String attr, String val) {
        this.name = name;
        this.addAttribute(attr, val, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addAttribute(String name, Object val, boolean optional) {
        if (val == null || val.equals("")) {
            if (!optional) throw new IllegalArgumentException("missing value for attribute " + name);
            this.removeAttribute(name);
            return;
        } else {
            this.addAttribute(new ObjectAttr(name, val));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addAttribute(String name, Date val, boolean optional) {
        if (val == null) {
            if (!optional) throw new IllegalArgumentException("missing value for attribute " + name);
            this.removeAttribute(name);
            return;
        } else {
            this.addAttribute(new DateAttr(name, val));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addAttribute(String name, byte[] val, boolean optional) {
        if (val == null || val.length == 0) {
            if (!optional) throw new IllegalArgumentException("missing value for attribute " + name);
            this.removeAttribute(name);
            return;
        } else {
            this.addAttribute(new BytesAttr(name, val));
        }
    }

    private void addAttribute(Attr attr) {
        if (this.firstAttr == null) {
            this.firstAttr = attr;
            return;
        }
        Attr cur = this.firstAttr;
        while (!attr.name.equals(cur.name)) {
            if (cur.next == null) {
                cur.next = attr;
                return;
            }
            cur = cur.next;
        }
        cur.val = attr.val;
    }

    private void removeAttribute(String name) {
        if (this.firstAttr == null) {
            return;
        }
        Attr cur = this.firstAttr;
        Attr prev = null;
        while (!name.equals(cur.name)) {
            if (cur.next == null) {
                return;
            }
            prev = cur;
            cur = prev.next;
        }
        if (prev != null) {
            prev.next = cur.next;
        } else {
            this.firstAttr = cur.next;
        }
    }

    protected Object getAttribute(String name) {
        Attr attr = this.firstAttr;
        while (attr != null) {
            if (name.equals(attr.name)) {
                return attr.val;
            }
            attr = attr.next;
        }
        return null;
    }

    public void output(Writer out) throws IOException {
        out.write(60);
        out.write(this.name);
        if (this.firstAttr != null) {
            Attr attr = this.firstAttr;
            while (attr != null) {
                attr.output(out);
                attr = attr.next;
            }
        }
        if (this.isEmpty()) {
            out.write(47);
        } else {
            out.write(62);
            this.outputContent(out);
            out.write(60);
            out.write(47);
            out.write(this.name);
        }
        out.write(62);
    }

    public String toString() {
        return this.toString(64);
    }

    public String toString(int initialSize) {
        StringWriter sw = new StringWriter(initialSize);
        try {
            this.output(sw);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return sw.toString();
    }

    protected boolean isEmpty() {
        return true;
    }

    protected void outputContent(Writer out) throws IOException {
    }

    protected void outputChilds(Writer out, List<? extends BaseElement> childs) throws IOException {
        for (BaseElement baseElement : childs) {
            baseElement.output(out);
        }
    }

    static void outputEscaped(Writer out, String val, String apos) throws IOException {
        char[] cs = val.toCharArray();
        block6: for (int i = 0; i < cs.length; ++i) {
            switch (cs[i]) {
                case '&': {
                    out.write("&amp;");
                    continue block6;
                }
                case '\'': {
                    out.write(apos);
                    continue block6;
                }
                case '<': {
                    out.write("&lt;");
                    continue block6;
                }
                case '>': {
                    out.write("&gt;");
                    continue block6;
                }
                default: {
                    out.write(cs[i]);
                }
            }
        }
    }

    private static class BytesAttr
    extends Attr {
        BytesAttr(String name, byte[] val) {
            super(name, val);
        }

        public void outputVal(Writer out) throws IOException {
            out.write(34);
            out.write(Base64Encoder.encode((byte[])this.val));
            out.write(34);
        }
    }

    private static class DateAttr
    extends Attr {
        DateAttr(String name, Date val) {
            super(name, val);
        }

        public void outputVal(Writer out) throws IOException {
            out.write(34);
            out.write(AuditMessage.toDateTimeStr((Date)this.val));
            out.write(34);
        }
    }

    private static class ObjectAttr
    extends Attr {
        ObjectAttr(String name, Object val) {
            super(name, val);
        }

        public void outputVal(Writer out) throws IOException {
            String str = this.val.toString();
            int quote = 34;
            String apos = "'";
            if (str.indexOf(34) != -1) {
                quote = 39;
                apos = "&apos;";
            }
            out.write(quote);
            BaseElement.outputEscaped(out, str, apos);
            out.write(quote);
        }
    }

    private static abstract class Attr {
        String name;
        Object val;
        Attr next;

        Attr(String name, Object val) {
            this.name = name;
            this.val = val;
        }

        void output(Writer out) throws IOException {
            out.write(32);
            out.write(this.name);
            out.write(61);
            this.outputVal(out);
        }

        abstract void outputVal(Writer var1) throws IOException;
    }
}

