/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.BaseElement;
import org.dcm4che2.audit.message.CodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditSource
extends BaseElement {
    private static AuditSource defAuditSource;
    private final ArrayList<TypeCode> auditSourceTypeCodes = new ArrayList(1);

    public AuditSource(String id) {
        super("AuditSourceIdentification");
        this.setAuditSourceID(id);
    }

    public final void setAuditSourceID(String id) {
        super.addAttribute("AuditSourceID", id, false);
    }

    public final String getAuditSourceID() {
        return (String)this.getAttribute("AuditSourceID");
    }

    public final String getAuditEnterpriseSiteID() {
        return (String)this.getAttribute("AuditEnterpriseSiteID");
    }

    public final AuditSource setAuditEnterpriseSiteID(String id) {
        this.addAttribute("AuditEnterpriseSiteID", id, true);
        return this;
    }

    public final List<TypeCode> getAuditSourceTypeCodes() {
        return Collections.unmodifiableList(this.auditSourceTypeCodes);
    }

    public AuditSource addAuditSourceTypeCode(TypeCode code) {
        if (code == null) {
            throw new NullPointerException();
        }
        this.auditSourceTypeCodes.add(code);
        return this;
    }

    public AuditSource clearAuditSourceTypeCodes() {
        this.auditSourceTypeCodes.clear();
        return this;
    }

    @Override
    protected boolean isEmpty() {
        return this.auditSourceTypeCodes.isEmpty();
    }

    @Override
    protected void outputContent(Writer out) throws IOException {
        this.outputChilds(out, this.auditSourceTypeCodes);
    }

    public static AuditSource getDefaultAuditSource() {
        if (defAuditSource == null) {
            defAuditSource = new AuditSource(AuditMessage.getLocalHostName());
        }
        return defAuditSource;
    }

    public static void setDefaultAuditSource(AuditSource defAuditSource) {
        if (defAuditSource == null) {
            throw new NullPointerException("defAuditSource");
        }
        AuditSource.defAuditSource = defAuditSource;
    }

    public static class TypeCode
    extends CodeElement {
        public static final TypeCode END_USER_DISPLAY_DEVICE = new TypeCode("1");
        public static final TypeCode DATA_ACQUISITION_DEVICE = new TypeCode("2");
        public static final TypeCode WEB_SERVER_PROCESS = new TypeCode("3");
        public static final TypeCode APPLICATION_SERVER_PROCESS = new TypeCode("4");
        public static final TypeCode DATABASE_SERVER_PROCESS = new TypeCode("5");
        public static final TypeCode SECURITY_SERVER = new TypeCode("6");
        public static final TypeCode ISO_LEVEL_1_3_NETWORK_COMPONENT = new TypeCode("7");
        public static final TypeCode ISO_LEVEL_4_6_OPERATING_SOFTWARE = new TypeCode("8");
        public static final TypeCode OTHER = new TypeCode("9");
        private static TypeCode[] TYPE_CODES = new TypeCode[]{END_USER_DISPLAY_DEVICE, DATA_ACQUISITION_DEVICE, WEB_SERVER_PROCESS, APPLICATION_SERVER_PROCESS, DATABASE_SERVER_PROCESS, SECURITY_SERVER, ISO_LEVEL_1_3_NETWORK_COMPONENT, ISO_LEVEL_4_6_OPERATING_SOFTWARE, OTHER};

        private TypeCode(String code) {
            super("AuditSourceTypeCode", code);
        }

        public static TypeCode valueOf(String code) {
            try {
                return TYPE_CODES[Integer.parseInt(code) - 1];
            }
            catch (Exception e) {
                throw new IllegalArgumentException("code:" + code);
            }
        }
    }
}

