/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dcm4che2.audit.message.BaseElement;
import org.dcm4che2.audit.message.CodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditEvent
extends BaseElement {
    private final ID eventID;
    private final ArrayList<TypeCode> eventTypeCodes = new ArrayList(1);

    public AuditEvent(ID eventID, ActionCode action) {
        super("EventIdentification");
        if (eventID == null) {
            throw new NullPointerException();
        }
        this.eventID = eventID;
        this.addAttribute("EventActionCode", action, true);
        this.setEventDateTime(new Date());
        this.setOutcomeIndicator(OutcomeIndicator.SUCCESS);
    }

    public ID getEventID() {
        return this.eventID;
    }

    public ActionCode getEventActionCode() {
        return (ActionCode)this.getAttribute("EventActionCode");
    }

    public Date getEventDateTime() {
        return (Date)this.getAttribute("EventDateTime");
    }

    public AuditEvent setEventDateTime(Date datetime) {
        this.addAttribute("EventDateTime", datetime, false);
        return this;
    }

    public OutcomeIndicator getEventOutcomeIndicator() {
        return (OutcomeIndicator)this.getAttribute("EventOutcomeIndicator");
    }

    public AuditEvent setOutcomeIndicator(OutcomeIndicator outcome) {
        this.addAttribute("EventOutcomeIndicator", outcome, false);
        return this;
    }

    public List<TypeCode> getEventTypeCodes() {
        return Collections.unmodifiableList(this.eventTypeCodes);
    }

    public AuditEvent addEventTypeCode(TypeCode code) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        this.eventTypeCodes.add(code);
        return this;
    }

    @Override
    protected boolean isEmpty() {
        return false;
    }

    @Override
    protected void outputContent(Writer out) throws IOException {
        this.eventID.output(out);
        this.outputChilds(out, this.eventTypeCodes);
    }

    public static class TypeCode
    extends CodeElement {
        public static final TypeCode APPLICATION_START = new TypeCode("110120", "DCM", "Application Start");
        public static final TypeCode APPLICATION_STOP = new TypeCode("110121", "DCM", "Application Stop");
        public static final TypeCode LOGIN = new TypeCode("110122", "DCM", "Login");
        public static final TypeCode LOGOUT = new TypeCode("110123", "DCM", "Logout");
        public static final TypeCode ATTACH = new TypeCode("110124", "DCM", "Attach");
        public static final TypeCode DETACH = new TypeCode("110125", "DCM", "Detach");
        public static final TypeCode NODE_AUTHENTICATION = new TypeCode("110126", "DCM", "Node Authentication");
        public static final TypeCode EMERGENCY_OVERRIDE_STARTED = new TypeCode("110127", "DCM", "Emergency Override Started");
        public static final TypeCode NETWORK_CONFIGURATION = new TypeCode("110128", "DCM", "Network Configuration");
        public static final TypeCode SECURITY_CONFIGURATION = new TypeCode("110129", "DCM", "Security Configuration");
        public static final TypeCode HARDWARE_CONFIGURATION = new TypeCode("110130", "DCM", "Hardware Configuration");
        public static final TypeCode SOFTWARE_CONFIGURATION = new TypeCode("110131", "DCM", "Software Configuration");
        public static final TypeCode USE_OF_RESTRICTED_FUNCTION = new TypeCode("110132", "DCM", "Use of Restricted Function");
        public static final TypeCode AUDIT_RECORDING_STOPPED = new TypeCode("110133", "DCM", "Audit Recording Stopped");
        public static final TypeCode AUDIT_RECORDING_STARTED = new TypeCode("110134", "DCM", "Audit Recording Started");
        public static final TypeCode OBJECT_SECURITY_ATTRIBUTES_CHANGED = new TypeCode("110135", "DCM", "Object Security Attributes Changed");
        public static final TypeCode SECURITY_ROLES_CHANGED = new TypeCode("110136", "DCM", "Security Roles Changed");
        public static final TypeCode USER_SECURITY_ATTRIBUTES_CHANGED = new TypeCode("110137", "DCM", "User security Attributes Changed");
        public static final TypeCode EMERGENCY_OVERRIDE_STOPPED = new TypeCode("110138", "DCM", "Emergency Override Stopped");
        public static final TypeCode REMOTE_SERVICE_OPERATION_STARTED = new TypeCode("110139", "DCM", "Remote Service Operation Started");
        public static final TypeCode REMOTE_SERVICE_OPERATION_STOPPED = new TypeCode("110140", "DCM", "Remote Service Operation Stopped");
        public static final TypeCode LOCAL_SERVICE_OPERATION_STARTED = new TypeCode("110141", "DCM", "Local Service Operation Started");
        public static final TypeCode LOCAL_SERVICE_OPERATION_STOPPED = new TypeCode("110142", "DCM", "Local Service Operation Stopped");

        public TypeCode(String code) {
            super("EventTypeCode", code);
        }

        public TypeCode(String code, String codeSystemName, String displayName) {
            super("EventTypeCode", code, codeSystemName, displayName);
        }
    }

    public static class OutcomeIndicator {
        private final String value;
        public static final OutcomeIndicator SUCCESS = new OutcomeIndicator("0");
        public static final OutcomeIndicator MINOR_FAILURE = new OutcomeIndicator("4");
        public static final OutcomeIndicator SERIOUS_FAILURE = new OutcomeIndicator("8");
        public static final OutcomeIndicator MAJOR_FAILURE = new OutcomeIndicator("12");

        private OutcomeIndicator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class ActionCode {
        public static final ActionCode CREATE = new ActionCode("C");
        public static final ActionCode READ = new ActionCode("R");
        public static final ActionCode UPDATE = new ActionCode("U");
        public static final ActionCode DELETE = new ActionCode("D");
        public static final ActionCode EXECUTE = new ActionCode("E");
        private final String value;

        private ActionCode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class ID
    extends CodeElement {
        public static final ID APPLICATION_ACTIVITY = new ID("110100", "DCM", "Application Activity");
        public static final ID AUDIT_LOG_USED = new ID("110101", "DCM", "Audit Log Used");
        public static final ID BEGIN_TRANSFERRING_DICOM_INSTANCES = new ID("110102", "DCM", "Begin Transferring DICOM Instances");
        public static final ID DICOM_INSTANCES_ACCESSED = new ID("110103", "DCM", "DICOM Instances Accessed");
        public static final ID DICOM_INSTANCES_TRANSFERRED = new ID("110104", "DCM", "DICOM Instances Transferred");
        public static final ID DICOM_STUDY_DELETED = new ID("110105", "DCM", "DICOM Study Deleted");
        public static final ID EXPORT = new ID("110106", "DCM", "Export");
        public static final ID IMPORT = new ID("110107", "DCM", "Import");
        public static final ID NETWORK_ENTRY = new ID("110108", "DCM", "Network Entry");
        public static final ID ORDER_RECORD = new ID("110109", "DCM", "Order Record");
        public static final ID PATIENT_RECORD = new ID("110110", "DCM", "Patient Record");
        public static final ID PROCEDURE_RECORD = new ID("110111", "DCM", "Procedure Record");
        public static final ID QUERY = new ID("110112", "DCM", "Query");
        public static final ID SECURITY_ALERT = new ID("110113", "DCM", "Security Alert");
        public static final ID USER_AUTHENTICATION = new ID("110114", "DCM", "User Authentication");
        public static final ID HEALTH_SERVICE_PROVISION_EVENT = new ID("IHE0001", "IHE", "Health Services Provision Event");
        public static final ID MEDICATION_EVENT = new ID("IHE0002", "IHE", "Medication Event");
        public static final ID PATIENT_CARE_RESOURCE_ASSIGNMENT = new ID("IHE0003", "IHE", "Patient Care Resource Assignment");
        public static final ID PATIENT_CARE_EPISODE = new ID("IHE0004", "IHE", "Patient Care Episode");
        public static final ID PATIENT_CARE_PROTOCOL = new ID("IHE0005", "IHE", "Patient Care Protocol");

        public ID(String code) {
            super("EventID", code);
        }

        public ID(String code, String codeSystemName, String displayName) {
            super("EventID", code, codeSystemName, displayName);
        }
    }
}

