/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.BaseElement;
import org.dcm4che2.audit.message.CodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveParticipant
extends BaseElement {
    private static final Pattern IP4 = Pattern.compile("\\d+(\\.\\d+){3}");
    private static final Pattern IP6 = Pattern.compile("[0-9a-fA-F]*(\\:[0-9a-fA-F]*){7}");
    private static final Pattern TEL_NO = Pattern.compile("(\\++\\d+\\s*)?(\\(\\d+\\)\\s*)?\\d+([-\\s]\\d+)*(X\\d+)?(B\\d+)?(C.*)?");
    private static boolean encodeUserIsRequestorTrue = false;
    private ArrayList<RoleIDCode> roleIDCodes = new ArrayList(1);

    public ActiveParticipant(String userID, boolean userIsRequestor) {
        super("ActiveParticipant");
        if (userID.length() == 0) {
            throw new IllegalArgumentException("userID=\"\"");
        }
        this.addAttribute("UserID", userID, false);
        if (!userIsRequestor || encodeUserIsRequestorTrue) {
            this.addAttribute("UserIsRequestor", userIsRequestor, false);
        }
    }

    public static ActiveParticipant createActivePerson(String userID, String altUserID, String userName, String napID, boolean requestor) {
        ActiveParticipant ap = new ActiveParticipant(userID, requestor);
        ap.setAlternativeUserID(altUserID);
        ap.setUserName(userName);
        ap.setNetworkAccessPointID(napID);
        return ap;
    }

    public static ActiveParticipant createActiveProcess(String processID, String[] aets, String processName, String nodeID, boolean requestor) {
        return ActiveParticipant.createActivePerson(processID, AuditMessage.aetsToAltUserID(aets), processName, nodeID, requestor);
    }

    public static ActiveParticipant createActiveNode(String nodeID, boolean requestor) {
        ActiveParticipant ap = new ActiveParticipant(nodeID, requestor);
        ap.setNetworkAccessPointID(nodeID);
        return ap;
    }

    public static ActiveParticipant createMedia(String mediaID, String mediaUID) {
        ActiveParticipant ap = new ActiveParticipant(mediaID, false);
        ap.setAlternativeUserID(mediaUID);
        return ap;
    }

    public static boolean isEncodeUserIsRequestorTrue() {
        return encodeUserIsRequestorTrue;
    }

    public static void setEncodeUserIsRequestorTrue(boolean enable) {
        encodeUserIsRequestorTrue = enable;
    }

    public String getUserID() {
        return (String)this.getAttribute("UserID");
    }

    public String getAlternativeUserID() {
        return (String)this.getAttribute("AlternativeUserID");
    }

    public ActiveParticipant setAlternativeUserID(String id) {
        this.addAttribute("AlternativeUserID", id, true);
        return this;
    }

    public String getUserName() {
        return (String)this.getAttribute("UserName");
    }

    public ActiveParticipant setUserName(String name) {
        this.addAttribute("UserName", name, true);
        return this;
    }

    public boolean isUserIsRequestor() {
        Boolean requestor = (Boolean)this.getAttribute("UserIsRequestor");
        return requestor == null || requestor != false;
    }

    public String getNetworkAccessPointID() {
        return (String)this.getAttribute("NetworkAccessPointID");
    }

    public NetworkAccessPointTypeCode getNetworkAccessPointTypeCode() {
        return (NetworkAccessPointTypeCode)this.getAttribute("NetworkAccessPointTypeCode");
    }

    public ActiveParticipant setNetworkAccessPointID(String id, NetworkAccessPointTypeCode type) {
        this.addAttribute("NetworkAccessPointID", id, false);
        this.addAttribute("NetworkAccessPointTypeCode", type, false);
        return this;
    }

    public ActiveParticipant setNetworkAccessPointID(String id) {
        this.addAttribute("NetworkAccessPointID", id, true);
        this.addAttribute("NetworkAccessPointTypeCode", NetworkAccessPointTypeCode.valueOf(id), true);
        return this;
    }

    public void setNetworkAccessPointID(InetAddress ip) {
        this.setNetworkAccessPointID(AuditMessage.hostNameOf(ip));
    }

    public List<RoleIDCode> getRoleIDCodes() {
        return Collections.unmodifiableList(this.roleIDCodes);
    }

    public ActiveParticipant addRoleIDCode(RoleIDCode code) {
        if (code == null) {
            throw new NullPointerException();
        }
        this.roleIDCodes.add(code);
        return this;
    }

    @Override
    protected boolean isEmpty() {
        return this.roleIDCodes.isEmpty();
    }

    @Override
    protected void outputContent(Writer out) throws IOException {
        this.outputChilds(out, this.roleIDCodes);
    }

    public static boolean isIP(String id) {
        return IP4.matcher(id).matches() || IP6.matcher(id).matches();
    }

    public static boolean isTelNo(String id) {
        return TEL_NO.matcher(id).matches();
    }

    public static class NetworkAccessPointTypeCode {
        private final String value;
        public static final NetworkAccessPointTypeCode MACHINE_NAME = new NetworkAccessPointTypeCode("1");
        public static final NetworkAccessPointTypeCode IP_ADDRESS = new NetworkAccessPointTypeCode("2");
        public static final NetworkAccessPointTypeCode TEL_NR = new NetworkAccessPointTypeCode("3");

        private NetworkAccessPointTypeCode(String value) {
            this.value = value;
        }

        public static NetworkAccessPointTypeCode valueOf(String id) {
            return id == null || id.length() == 0 ? null : (ActiveParticipant.isIP(id) ? IP_ADDRESS : (ActiveParticipant.isTelNo(id) ? TEL_NR : MACHINE_NAME));
        }

        public String toString() {
            return this.value;
        }
    }

    public static class RoleIDCode
    extends CodeElement {
        public static final RoleIDCode APPLICATION = new RoleIDCode("110150", "DCM", "Application");
        public static final RoleIDCode APPLICATION_LAUNCHER = new RoleIDCode("110151", "DCM", "Application Launcher");
        public static final RoleIDCode DESTINATION = new RoleIDCode("110152", "DCM", "Destination");
        public static final RoleIDCode SOURCE = new RoleIDCode("110153", "DCM", "Source");
        public static final RoleIDCode DESTINATION_MEDIA = new RoleIDCode("110154", "DCM", "Destination Media");
        public static final RoleIDCode SOURCE_MEDIA = new RoleIDCode("110155", "DCM", "Source Media");

        public RoleIDCode(String code) {
            super("RoleIDCode", code);
        }

        public RoleIDCode(String code, String codeSystemName, String displayName) {
            super("RoleIDCode", code, codeSystemName, displayName);
        }
    }
}

