/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.log4j.net;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.dcm4che2.audit.util.SSLUtils;

public class SyslogAppender2
extends AppenderSkeleton {
    private String host = "localhost";
    private int port = 514;
    private String bindAddress = "0.0.0.0";
    private int localPort = 0;
    private Protocol protocol = Protocol.UDP;
    private int sendBuffer = 0;
    private int tcpConnectTimeout = 300;
    private int tcpRetryInterval = 60000;
    private boolean tcpNoDelay = true;
    private boolean tlsEnabled = false;
    private String tlsProtocol = "TLSv1";
    private String[] tlsCiphers = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA"};
    private String keyStoreFile;
    private char[] keyStorePass;
    private char[] keyPass;
    private String keyStoreType = "JKS";
    private String trustStoreFile;
    private char[] trustStorePass;
    private String trustStoreType = "JKS";
    private Facility syslogFacility = Facility.AUTHPRIV;
    private Severity fatalSeverity = Severity.EMERGENCY;
    private Severity errorSeverity = Severity.ERROR;
    private Severity warnSeverity = Severity.WARNING;
    private Severity infoSeverity = Severity.NOTICE;
    private Severity debugSeverity = Severity.DEBUG;
    private String applicationName;
    private String messageID;
    private boolean timestampInUTC = false;
    private boolean prefixMessageWithBOM = true;
    private String hostName;
    private String processID;
    private Calendar calendar;
    private Buffer buf = new Buffer();
    private SocketAddress bindaddr;
    private SocketAddress addr;
    private DatagramSocket ds;
    private SocketFactory socketFactory;
    private Socket sock;
    private OutputStream sockout;
    private long retryConnectAt;
    private static final int[] DIGITS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public void setProtocol(String protocol) {
        this.protocol = Protocol.valueOf(protocol.toUpperCase());
    }

    public int getSendBuffer() {
        return this.sendBuffer;
    }

    public void setSendBuffer(int sendBuffer) {
        this.sendBuffer = sendBuffer;
    }

    public int getTcpConnectTimeout() {
        return this.tcpConnectTimeout;
    }

    public void setTcpConnectTimeout(int tcpConnectTimeout) {
        this.tcpConnectTimeout = tcpConnectTimeout;
    }

    public int getTcpRetryInterval() {
        return this.tcpRetryInterval;
    }

    public void setTcpRetryInterval(int tcpRetryInterval) {
        this.tcpRetryInterval = tcpRetryInterval;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public String getTlsProtocol() {
        return this.tlsProtocol;
    }

    public void setTlsProtocol(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    public String getTlsCiphers() {
        return SyslogAppender2.toString(this.tlsCiphers);
    }

    public void setTlsCiphers(String tlsCiphers) {
        this.tlsCiphers = SyslogAppender2.split(tlsCiphers);
    }

    private static String toString(String[] ss) {
        if (ss.length == 0) {
            return "";
        }
        if (ss.length == 1) {
            return ss[0];
        }
        int iMax = ss.length - 1;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(String.valueOf(ss[i]));
            if (i == iMax) {
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String[] split(String s) {
        StringTokenizer stk = new StringTokenizer(s, " ,");
        int count = stk.countTokens();
        if (count == 0) {
            throw new IllegalArgumentException(s);
        }
        String[] ss = new String[count];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = stk.nextToken();
        }
        return ss;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return new String(this.keyStorePass);
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass.toCharArray();
    }

    public String getKeyPass() {
        return new String(this.keyPass);
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass.toCharArray();
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStorePass() {
        return new String(this.trustStorePass);
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass.toCharArray();
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getSyslogFacility() {
        return this.syslogFacility.toString();
    }

    public void setSyslogFacility(String facility) {
        this.syslogFacility = Facility.valueOf(facility.toUpperCase());
    }

    public String getFatalSeverity() {
        return this.fatalSeverity.toString();
    }

    public void setFatalSeverity(String severity) {
        this.fatalSeverity = Severity.valueOf(severity.toUpperCase());
    }

    public String getErrorSeverity() {
        return this.errorSeverity.toString();
    }

    public void setErrorSeverity(String severity) {
        this.errorSeverity = Severity.valueOf(severity.toUpperCase());
    }

    public String getWarnSeverity() {
        return this.warnSeverity.toString();
    }

    public void setWarnSeverity(String severity) {
        this.warnSeverity = Severity.valueOf(severity.toUpperCase());
    }

    public String getInfoSeverity() {
        return this.infoSeverity.toString();
    }

    public void setInfoSeverity(String severity) {
        this.infoSeverity = Severity.valueOf(severity.toUpperCase());
    }

    public String getDebugSeverity() {
        return this.debugSeverity.toString();
    }

    public void setDebugSeverity(String severity) {
        this.debugSeverity = Severity.valueOf(severity.toUpperCase());
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.hostName = hostname.length() > 0 ? hostname : null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public boolean isTimestampInUTC() {
        return this.timestampInUTC;
    }

    public void setTimestampInUTC(boolean timestampInUTC) {
        this.timestampInUTC = timestampInUTC;
    }

    public boolean isPrefixMessageWithBOM() {
        return this.prefixMessageWithBOM;
    }

    public void setPrefixMessageWithBOM(boolean prefixMessageWithBOM) {
        this.prefixMessageWithBOM = prefixMessageWithBOM;
    }

    public void activateOptions() {
        this.initCalendar();
        this.initProcessID();
        this.initHostName();
        this.initConnection();
    }

    private void initCalendar() {
        this.calendar = this.timestampInUTC ? Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH) : Calendar.getInstance(Locale.ENGLISH);
    }

    private void initProcessID() {
        String s = ManagementFactory.getRuntimeMXBean().getName();
        int atPos = s.indexOf(64);
        this.processID = atPos > 0 ? s.substring(0, atPos) : s;
    }

    private void initHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                this.errorHandler.error("Failed to detect local host name", (Exception)e, 0);
            }
        }
    }

    private void initConnection() {
        this.bindaddr = new InetSocketAddress(this.bindAddress, this.localPort);
        this.addr = new InetSocketAddress(this.host, this.port);
        this.protocol.init(this);
    }

    protected void append(LoggingEvent event) {
        try {
            this.buf.reset();
            this.writeHeader(event);
            this.writeSP();
            this.writeStructuredData();
            this.writeSP();
            if (this.prefixMessageWithBOM) {
                this.writeBOM();
            }
            this.writeString(event.getRenderedMessage());
            this.protocol.send(this);
        }
        catch (IOException e) {
            this.errorHandler.error("Failed to emit message by " + (Object)((Object)this.protocol) + " connection to " + this.host + ":" + this.port, (Exception)e, 1, event);
        }
    }

    private void writeHeader(LoggingEvent event) {
        this.writePRI(event.getLevel());
        this.writeVersion();
        this.writeSP();
        this.writeTimeStamp(event.timeStamp);
        this.writeSP();
        this.writeString(this.hostName);
        this.writeSP();
        this.writeString(this.applicationName);
        this.writeSP();
        this.writeString(this.processID);
        this.writeSP();
        this.writeString(this.messageID);
    }

    private void writeVersion() {
        this.buf.write(49);
    }

    private void writeStructuredData() {
        this.writeNIL();
    }

    private void writeSP() {
        this.buf.write(32);
    }

    private void writeNIL() {
        this.buf.write(45);
    }

    private void writePRI(Level level) {
        this.buf.write(60);
        this.writeNumber(this.buf, this.prival(level));
        this.buf.write(62);
    }

    private int prival(Level level) {
        return this.syslogFacility.ordinal() << 3 | this.severityOf(level).ordinal();
    }

    private Severity severityOf(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return this.fatalSeverity;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return this.errorSeverity;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return this.warnSeverity;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return this.infoSeverity;
        }
        return this.debugSeverity;
    }

    private void writeTimeStamp(long time) {
        this.calendar.setTimeInMillis(time);
        this.writeNumber(this.buf, this.calendar.get(1), 4);
        this.buf.write(45);
        this.writeNumber(this.buf, this.calendar.get(2) + 1, 2);
        this.buf.write(45);
        this.writeNumber(this.buf, this.calendar.get(5), 2);
        this.buf.write(84);
        this.writeNumber(this.buf, this.calendar.get(11), 2);
        this.buf.write(58);
        this.writeNumber(this.buf, this.calendar.get(12), 2);
        this.buf.write(58);
        this.writeNumber(this.buf, this.calendar.get(13), 2);
        this.buf.write(46);
        this.writeNumber(this.buf, this.calendar.get(14), 3);
        if (this.timestampInUTC) {
            this.buf.write(90);
        } else {
            this.writeTimezone((this.calendar.get(15) + this.calendar.get(16)) / 60000);
        }
    }

    private void writeTimezone(int tzoff) {
        if (tzoff < 0) {
            tzoff = -tzoff;
            this.buf.write(45);
        } else {
            this.buf.write(43);
        }
        int hh = tzoff / 60;
        int mm = tzoff - (hh << 6) + (hh << 2);
        this.writeNumber(this.buf, hh, 2);
        this.buf.write(58);
        this.writeNumber(this.buf, mm, 2);
    }

    private void writeString(String s) {
        if (s == null) {
            this.writeNIL();
        } else {
            try {
                this.buf.write(s.getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void writeNumber(OutputStream out, int d) {
        this.writeNumber(out, d, SyslogAppender2.stringSize(d));
    }

    private static int stringSize(int d) {
        if (d < 10) {
            return 1;
        }
        if (d < 100) {
            return 2;
        }
        if (d < 1000) {
            return 3;
        }
        if (d < 10000) {
            return 4;
        }
        d /= 10000;
        int n = 5;
        while (d > 9) {
            d /= 10;
            ++n;
        }
        return n;
    }

    private void writeNumber(OutputStream out, int d, int w) {
        switch (w) {
            case 4: {
                int q = d / 1000;
                this.writeDigit(out, q);
                d -= (q << 10) - (q << 4) - (q << 3);
            }
            case 3: {
                int q = d / 100;
                this.writeDigit(out, q);
                d -= (q << 7) + (q << 2) - (q << 5);
            }
            case 2: {
                int q = d / 10;
                this.writeDigit(out, q);
                d -= (q << 3) + (q << 1);
            }
            case 1: {
                this.writeDigit(out, d);
                break;
            }
            default: {
                int n = 10000;
                w -= 4;
                while (--w > 0) {
                    n = (n << 3) + (n << 1);
                }
                while (n > 1) {
                    int q = d / n;
                    this.writeDigit(out, q);
                    d -= q * n;
                    n /= 10;
                }
                this.writeDigit(out, d);
            }
        }
    }

    private void writeDigit(OutputStream out, int d) {
        try {
            out.write(DIGITS[d]);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void writeBOM() {
        this.buf.write(239);
        this.buf.write(187);
        this.buf.write(191);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SyslogAppender2 syslogAppender2 = this;
        synchronized (syslogAppender2) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.protocol.close(this);
    }

    public boolean requiresLayout() {
        return false;
    }

    private void initDatagramSocket() {
        try {
            this.ds = new DatagramSocket(this.bindaddr);
        }
        catch (SocketException e) {
            this.errorHandler.error("Failed to create datagram socket bound to " + this.bindaddr, (Exception)e, 0);
            return;
        }
        if (this.sendBuffer > 0) {
            try {
                this.ds.setSendBufferSize(this.sendBuffer);
            }
            catch (SocketException e) {
                this.errorHandler.error("Failed to set SO_SNDBUF option to " + this.sendBuffer + " for datagram socket " + this.ds, (Exception)e, 0);
            }
        }
    }

    private void sendDatagramPacket() throws IOException {
        if (this.buf != null) {
            this.buf.writeTo(this.ds);
        }
    }

    private void closeDatagramSocket() {
        this.ds.close();
        this.ds = null;
    }

    private void initSocketFactory() {
        if (this.tlsEnabled) {
            try {
                this.socketFactory = this.getSSLContext().getSocketFactory();
            }
            catch (Exception e) {
                this.errorHandler.error("Failed to configure TLS context from key store " + this.keyStoreFile + " and trust store " + this.trustStoreFile, e, 0);
            }
        } else {
            this.socketFactory = SocketFactory.getDefault();
        }
    }

    private SSLContext getSSLContext() throws Exception {
        KeyStore keystore = SSLUtils.loadKeyStore(this.keyStoreFile, this.keyStorePass, this.keyStoreType);
        KeyStore truststore = SSLUtils.loadKeyStore(this.trustStoreFile, this.trustStorePass, this.trustStoreType);
        return SSLUtils.getSSLContext(keystore, this.keyPass, truststore, null);
    }

    private void writeToSocket() throws IOException {
        if (this.socketFactory == null) {
            return;
        }
        if (this.sock != null) {
            try {
                this.doWriteToSocket();
                return;
            }
            catch (IOException e) {
                this.close();
                this.retryConnectAt = 0L;
            }
        }
        if (this.retryConnectAt > 0L && this.retryConnectAt > System.currentTimeMillis()) {
            return;
        }
        try {
            this.connect();
        }
        catch (IOException e) {
            this.retryConnectAt = System.currentTimeMillis() + (long)this.tcpRetryInterval;
            throw e;
        }
        this.doWriteToSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException {
        Socket tmp = null;
        try {
            SSLSocket sslsock;
            tmp = this.socketFactory.createSocket();
            tmp.setTcpNoDelay(this.tcpNoDelay);
            if (this.sendBuffer > 0) {
                tmp.setSendBufferSize(this.sendBuffer);
            }
            tmp.bind(this.bindaddr);
            if (tmp instanceof SSLSocket) {
                sslsock = (SSLSocket)tmp;
                sslsock.setEnabledProtocols(new String[]{this.tlsProtocol});
                sslsock.setEnabledCipherSuites(this.tlsCiphers);
            }
            tmp.connect(this.addr, this.tcpConnectTimeout);
            if (tmp instanceof SSLSocket) {
                sslsock = (SSLSocket)tmp;
                sslsock.startHandshake();
            }
            this.sockout = new BufferedOutputStream(tmp.getOutputStream());
            this.sock = tmp;
            tmp = null;
        }
        finally {
            if (tmp != null) {
                try {
                    tmp.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void doWriteToSocket() throws IOException {
        this.writeNumber(this.sockout, this.buf.size());
        this.sockout.write(32);
        this.buf.writeTo(this.sockout);
        this.sockout.flush();
    }

    private void closeSocket() {
        try {
            this.sockout.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sockout = null;
        this.sock = null;
    }

    private class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        void writeTo(DatagramSocket ds) throws IOException {
            ds.send(new DatagramPacket(this.buf, this.count, SyslogAppender2.this.addr));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Protocol {
        UDP{

            void init(SyslogAppender2 app) {
                app.initDatagramSocket();
            }

            void send(SyslogAppender2 app) throws IOException {
                app.sendDatagramPacket();
            }

            void close(SyslogAppender2 app) {
                app.closeDatagramSocket();
            }
        }
        ,
        TCP{

            void init(SyslogAppender2 app) {
                app.initSocketFactory();
            }

            void send(SyslogAppender2 app) throws IOException {
                app.writeToSocket();
            }

            void close(SyslogAppender2 app) {
                app.closeSocket();
            }
        };


        abstract void init(SyslogAppender2 var1);

        abstract void send(SyslogAppender2 var1) throws IOException;

        abstract void close(SyslogAppender2 var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Severity {
        EMERGENCY,
        ALERT,
        CRITICAL,
        ERROR,
        WARNING,
        NOTICE,
        INFORMATIONAL,
        DEBUG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Facility {
        KERN,
        USER,
        MAIL,
        DAEMON,
        AUTH,
        SYSLOG,
        LPR,
        NEWS,
        UUCP,
        CRON,
        AUTHPRIV,
        FTP,
        NTP,
        AUDIT,
        ALERT,
        CRON2,
        LOCAL0,
        LOCAL1,
        LOCAL2,
        LOCAL3,
        LOCAL4,
        LOCAL5,
        LOCAL6,
        LOCAL7;

    }
}

