/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.log4j.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.dcm4che2.audit.log4j.helpers.SyslogWriter;

public class SyslogAppender
extends AppenderSkeleton {
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final int PRI_EMERGENCY = 0;
    public static final int PRI_ALERT = 1;
    public static final int PRI_CRITICAL = 2;
    public static final int PRI_ERROR = 3;
    public static final int PRI_WARNING = 4;
    public static final int PRI_NOTICE = 5;
    public static final int PRI_INFORMATIONAL = 6;
    public static final int PRI_DEBUG = 7;
    protected static final int SYSLOG_HOST_OI = 0;
    protected static final int FACILITY_OI = 1;
    private static final String[] SHORT_MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    int syslogFacility = 8;
    int fatalPriority = 0;
    int errorPriority = 3;
    int warnPriority = 4;
    int infoPriority = 5;
    int debugPriority = 7;
    String encoding = "UTF-8";
    SyslogWriter sw;
    String syslogHost;
    String localHostname;

    public SyslogAppender() {
    }

    public SyslogAppender(Layout layout, int syslogFacility) {
        this.layout = layout;
        this.syslogFacility = syslogFacility;
    }

    public SyslogAppender(Layout layout, String syslogHost, int syslogFacility) {
        this(layout, syslogFacility);
        this.setSyslogHost(syslogHost);
    }

    public synchronized void close() {
        this.closed = true;
        this.sw = null;
    }

    public static String getFacilityString(int syslogFacility) {
        switch (syslogFacility) {
            case 0: {
                return "kern";
            }
            case 8: {
                return "user";
            }
            case 16: {
                return "mail";
            }
            case 24: {
                return "daemon";
            }
            case 32: {
                return "auth";
            }
            case 40: {
                return "syslog";
            }
            case 48: {
                return "lpr";
            }
            case 56: {
                return "news";
            }
            case 64: {
                return "uucp";
            }
            case 72: {
                return "cron";
            }
            case 80: {
                return "authpriv";
            }
            case 88: {
                return "ftp";
            }
            case 128: {
                return "local0";
            }
            case 136: {
                return "local1";
            }
            case 144: {
                return "local2";
            }
            case 152: {
                return "local3";
            }
            case 160: {
                return "local4";
            }
            case 168: {
                return "local5";
            }
            case 176: {
                return "local6";
            }
            case 184: {
                return "local7";
            }
        }
        return null;
    }

    public static int getFacility(String facilityName) {
        if (facilityName != null) {
            facilityName = facilityName.trim();
        }
        if ("KERN".equalsIgnoreCase(facilityName)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(facilityName)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(facilityName)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(facilityName)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(facilityName)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(facilityName)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(facilityName)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(facilityName)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(facilityName)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(facilityName)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(facilityName)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(facilityName)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(facilityName)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(facilityName)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(facilityName)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(facilityName)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(facilityName)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(facilityName)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(facilityName)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(facilityName)) {
            return 184;
        }
        return -1;
    }

    int priorityOf(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return this.fatalPriority;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return this.errorPriority;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return this.warnPriority;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return this.infoPriority;
        }
        return this.debugPriority;
    }

    public String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return this.skipDomain(addr.getHostName());
        }
        catch (UnknownHostException uhe) {
            return "UNKNOWN_HOST";
        }
    }

    private String skipDomain(String hostName) {
        int len = hostName.indexOf(46);
        return len > 0 && !Character.isDigit(hostName.charAt(0)) ? hostName.substring(0, len) : hostName;
    }

    public final int getFatalPriority() {
        return this.fatalPriority;
    }

    public final void setFatalPriority(int fatalPriority) {
        this.fatalPriority = fatalPriority;
    }

    public final int getErrorPriority() {
        return this.errorPriority;
    }

    public final void setErrorPriority(int errorPriority) {
        this.errorPriority = errorPriority;
    }

    public final int getWarnPriority() {
        return this.warnPriority;
    }

    public final void setWarnPriority(int warnPriority) {
        this.warnPriority = warnPriority;
    }

    public final int getInfoPriority() {
        return this.infoPriority;
    }

    public final void setInfoPriority(int infoPriority) {
        this.infoPriority = infoPriority;
    }

    public final int getDebugPriority() {
        return this.debugPriority;
    }

    public final void setDebugPriority(int debugPriority) {
        this.debugPriority = debugPriority;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (!this.isAsSevereAsThreshold((Priority)event.getLevel())) {
            return;
        }
        if (this.sw == null) {
            this.errorHandler.error("No syslog host is set for SyslogAppedender named \"" + this.name + "\".");
            return;
        }
        SyslogWriter syslogWriter = this.sw;
        synchronized (syslogWriter) {
            Calendar now = Calendar.getInstance(Locale.ENGLISH);
            int pri = this.syslogFacility + this.priorityOf(event.getLevel());
            this.sw.write('<');
            this.sw.write(String.valueOf(pri));
            this.sw.write('>');
            this.sw.write(SHORT_MONTHS[now.get(2)]);
            this.sw.write(' ');
            this.writeNN(' ', now.get(5));
            this.sw.write(' ');
            this.writeNN('0', now.get(11));
            this.sw.write(':');
            this.writeNN('0', now.get(12));
            this.sw.write(':');
            this.writeNN('0', now.get(13));
            this.sw.write(' ');
            this.sw.write(this.localHostname);
            this.sw.write(' ');
            this.sw.write(this.layout.format(event));
            try {
                this.sw.flush();
            }
            catch (IOException e) {
                this.errorHandler.error("Failed to emit UDP message to " + this.syslogHost, (Exception)e, 1);
                this.sw.reset();
            }
        }
    }

    private void writeNN(char c, int n) {
        if (n < 10) {
            this.sw.write(c);
        }
        this.sw.write(String.valueOf(n));
    }

    public void activateOptions() {
        this.sw = new SyslogWriter(this.syslogHost, this.encoding);
        this.localHostname = this.getLocalHostname();
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setFacility(String facilityName) {
        if (facilityName == null) {
            return;
        }
        this.syslogFacility = SyslogAppender.getFacility(facilityName);
        if (this.syslogFacility == -1) {
            System.err.println("[" + facilityName + "] is an unknown syslog facility. Defaulting to [USER].");
            this.syslogFacility = 8;
        }
    }

    public String getFacility() {
        return SyslogAppender.getFacilityString(this.syslogFacility);
    }
}

