/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.log4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.CodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditMessageFilter
extends Filter {
    private boolean acceptOnMatch = false;
    private String eventIDToMatch;
    private String eventActionCodesToMatch;
    private List<AuditEvent.OutcomeIndicator> outcomeIndicatorsToMatch;
    private String eventTypeCodeToMatch;
    private String userIDToMatch;
    private Boolean userIsRequestorToMatch;
    private String aeTitleToMatch;
    private String roleIDCodeToMatch;
    private String machineNameToMatch;
    private String ipAddressToMatch;

    public int decide(LoggingEvent event) {
        Object msg = event.getMessage();
        if (!(msg instanceof AuditMessage)) {
            return 0;
        }
        AuditMessage auditMsg = (AuditMessage)msg;
        if (this.matchEvent(auditMsg.getAuditEvent()) && this.matchActiveParticipant(auditMsg.getActiveParticipants())) {
            return this.acceptOnMatch ? 1 : -1;
        }
        return 0;
    }

    private boolean matchEvent(AuditEvent auditEvent) {
        AuditEvent.ActionCode code;
        if (this.eventIDToMatch != null && this.eventIDToMatch.length() != 0 && !this.eventIDToMatch.equals(this.codeToString(auditEvent.getEventID()))) {
            return false;
        }
        if (this.eventActionCodesToMatch != null && this.eventActionCodesToMatch.length() != 0 && ((code = auditEvent.getEventActionCode()) == null || this.eventActionCodesToMatch.indexOf(code.toString()) == -1)) {
            return false;
        }
        if (this.outcomeIndicatorsToMatch != null && !this.outcomeIndicatorsToMatch.isEmpty() && this.outcomeIndicatorsToMatch.indexOf(auditEvent.getEventOutcomeIndicator()) == -1) {
            return false;
        }
        return this.eventTypeCodeToMatch == null || this.eventTypeCodeToMatch.length() == 0 || this.matchEventTypeCode(auditEvent.getEventTypeCodes());
    }

    private String codeToString(CodeElement code) {
        String codeSystemName = code.getCodeSystemName();
        return codeSystemName == null ? code.getCode() : code.getCode() + '^' + codeSystemName;
    }

    private boolean matchEventTypeCode(List<AuditEvent.TypeCode> eventTypeCodes) {
        for (AuditEvent.TypeCode typeCode : eventTypeCodes) {
            if (!this.eventTypeCodeToMatch.equals(this.codeToString(typeCode))) continue;
            return true;
        }
        return false;
    }

    private boolean matchActiveParticipant(List<ActiveParticipant> activeParticipants) {
        for (ActiveParticipant participant : activeParticipants) {
            if (!this.matchActiveParticipant(participant)) continue;
            return true;
        }
        return false;
    }

    private boolean matchActiveParticipant(ActiveParticipant participant) {
        if (this.userIDToMatch != null && this.userIDToMatch.length() != 0 && !this.userIDToMatch.equals(participant.getUserID())) {
            return false;
        }
        if (this.aeTitleToMatch != null && this.aeTitleToMatch.length() != 0 && Arrays.asList(AuditMessage.altUserIDToAETs(participant.getAlternativeUserID())).indexOf(this.aeTitleToMatch) == -1) {
            return false;
        }
        if (this.userIsRequestorToMatch != null && this.userIsRequestorToMatch.booleanValue() != participant.isUserIsRequestor()) {
            return false;
        }
        if (this.roleIDCodeToMatch != null && this.roleIDCodeToMatch.length() != 0 && !this.matchRoleIDCode(participant.getRoleIDCodes())) {
            return false;
        }
        String napid = participant.getNetworkAccessPointID();
        ActiveParticipant.NetworkAccessPointTypeCode naptype = participant.getNetworkAccessPointTypeCode();
        if (!(this.machineNameToMatch == null || this.machineNameToMatch.length() == 0 || naptype == ActiveParticipant.NetworkAccessPointTypeCode.MACHINE_NAME && this.machineNameToMatch.equals(napid))) {
            return false;
        }
        return this.ipAddressToMatch == null || this.ipAddressToMatch.length() == 0 || naptype == ActiveParticipant.NetworkAccessPointTypeCode.IP_ADDRESS && this.ipAddressToMatch.equals(napid);
    }

    private boolean matchRoleIDCode(List<ActiveParticipant.RoleIDCode> roleIDCodeIDs) {
        for (ActiveParticipant.RoleIDCode roleIDCode : roleIDCodeIDs) {
            if (!this.roleIDCodeToMatch.equals(this.codeToString(roleIDCode))) continue;
            return true;
        }
        return false;
    }

    public final boolean isAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public final void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public final String getEventIDToMatch() {
        return this.eventIDToMatch;
    }

    public final void setEventIDToMatch(String eventIDToMatch) {
        this.eventIDToMatch = eventIDToMatch;
    }

    public final String getEventActionCodesToMatch() {
        return this.eventActionCodesToMatch;
    }

    public final void setEventActionCodesToMatch(String actionCodes) {
        this.eventActionCodesToMatch = actionCodes.toUpperCase();
    }

    public String getEventOutcomeIndicatorsToMatch() {
        if (this.outcomeIndicatorsToMatch == null || this.outcomeIndicatorsToMatch.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (AuditEvent.OutcomeIndicator outcome : this.outcomeIndicatorsToMatch) {
            sb.append(this.tostr(outcome)).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String tostr(AuditEvent.OutcomeIndicator indicator) {
        if (indicator == AuditEvent.OutcomeIndicator.SUCCESS) {
            return "SUCCESS";
        }
        if (indicator == AuditEvent.OutcomeIndicator.MINOR_FAILURE) {
            return "WARN";
        }
        if (indicator == AuditEvent.OutcomeIndicator.SERIOUS_FAILURE) {
            return "ERROR";
        }
        if (indicator == AuditEvent.OutcomeIndicator.MAJOR_FAILURE) {
            return "FATAL";
        }
        throw new Error("Unexpected AuditEvent.OutcomeIndicator(" + indicator + ")");
    }

    public final void setEventOutcomeIndicatorsToMatch(String value) {
        StringTokenizer stk = new StringTokenizer(value, ",; \t");
        if (!stk.hasMoreTokens()) {
            this.outcomeIndicatorsToMatch = null;
        } else {
            this.outcomeIndicatorsToMatch = new ArrayList<AuditEvent.OutcomeIndicator>(stk.countTokens());
            do {
                try {
                    this.outcomeIndicatorsToMatch.add(this.toOutcomeIndicator(stk.nextToken()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            } while (stk.hasMoreTokens());
        }
    }

    private AuditEvent.OutcomeIndicator toOutcomeIndicator(String value) {
        if ("SUCCESS".equalsIgnoreCase(value)) {
            return AuditEvent.OutcomeIndicator.SUCCESS;
        }
        if ("WARN".equalsIgnoreCase(value)) {
            return AuditEvent.OutcomeIndicator.MINOR_FAILURE;
        }
        if ("ERROR".equalsIgnoreCase(value)) {
            return AuditEvent.OutcomeIndicator.SERIOUS_FAILURE;
        }
        if ("FATAL".equalsIgnoreCase(value)) {
            return AuditEvent.OutcomeIndicator.MAJOR_FAILURE;
        }
        throw new IllegalArgumentException(value);
    }

    public final String getEventTypeCodeToMatch() {
        return this.eventTypeCodeToMatch;
    }

    public final void setEventTypeCodeToMatch(String eventTypeCode) {
        this.eventTypeCodeToMatch = eventTypeCode;
    }

    public final String getUserIDToMatch() {
        return this.userIDToMatch;
    }

    public final void setUserIDToMatch(String userID) {
        this.userIDToMatch = userID;
    }

    public final String getAETitleToMatch() {
        return this.aeTitleToMatch;
    }

    public final void setAETitlesToMatch(String aeTitleToMatch) {
        this.aeTitleToMatch = aeTitleToMatch;
    }

    public final String getRoleIDCodeToMatch() {
        return this.roleIDCodeToMatch;
    }

    public final void setRoleIDCodeToMatch(String roleIDCodeToMatch) {
        this.roleIDCodeToMatch = roleIDCodeToMatch;
    }

    public final Boolean getUserIsRequestorToMatch() {
        return this.userIsRequestorToMatch;
    }

    public final void setUserIsRequestorToMatch(Boolean userIsRequestor) {
        this.userIsRequestorToMatch = userIsRequestor;
    }

    public final String getMachineNameToMatch() {
        return this.machineNameToMatch;
    }

    public final void setMachineNameToMatch(String machineName) {
        this.machineNameToMatch = machineName;
    }

    public final String getIPAddressToMatch() {
        return this.ipAddressToMatch;
    }

    public final void setIPAddressToMatch(String ipAddressToMatch) {
        this.ipAddressToMatch = ipAddressToMatch;
    }
}

