/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive.authentication;

import org.apache.wicket.security.authentication.LoginException;
import org.apache.wicket.security.hive.authentication.Subject;

public abstract class LoginContext {
    private final int sortOrder;
    private final boolean additionalLoginsPrevented;

    public LoginContext() {
        this(0, false);
    }

    public LoginContext(int sortOrder) {
        this(sortOrder, false);
    }

    public LoginContext(boolean allowAdditionalLogings) {
        this(0, allowAdditionalLogings);
    }

    public LoginContext(int sortOrder, boolean allowAdditionalLogins) {
        if (sortOrder < 0) {
            throw new IllegalArgumentException("0 is the lowest sort order allowed, not " + sortOrder);
        }
        this.sortOrder = sortOrder;
        this.additionalLoginsPrevented = !allowAdditionalLogins;
    }

    public abstract Subject login() throws LoginException;

    protected final int getSortOrder() {
        return this.sortOrder;
    }

    public final int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getClass().getName().hashCode();
        result = 31 * result + this.sortOrder;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        LoginContext other = (LoginContext)obj;
        return this.sortOrder == other.sortOrder;
    }

    public boolean preventsAdditionalLogins() {
        return this.additionalLoginsPrevented;
    }

    public void notifyLogoff(Subject subject) {
    }
}

