/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive.authentication;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.security.hive.authentication.Subject;
import org.apache.wicket.security.hive.authorization.Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSubject
implements Subject {
    private static final long serialVersionUID = 1L;
    private boolean readOnly;
    private Set<Principal> principals = new HashSet<Principal>(100);
    private Set<Principal> readOnlyPrincipals = Collections.unmodifiableSet(this.principals);

    @Override
    public final Set<Principal> getPrincipals() {
        return this.readOnlyPrincipals;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final void setReadOnly() {
        this.readOnly = true;
    }

    public final boolean addPrincipal(Principal principal) {
        if (this.readOnly) {
            return false;
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal can not be null.");
        }
        return this.principals.add(principal);
    }
}

