/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.wicket.security.hive.BasicHive;
import org.apache.wicket.security.hive.authentication.Subject;
import org.apache.wicket.security.hive.authorization.Permission;

public class SimpleCachingHive
extends BasicHive {
    private final WeakHashMap<Subject, Map<Permission, Boolean>> cache = new WeakHashMap(50);

    protected Boolean cacheLookUp(Subject subject, Permission permission) {
        if (subject == null || permission == null) {
            return null;
        }
        Map<Permission, Boolean> result = this.cache.get(subject);
        if (result != null) {
            return result.get(permission);
        }
        return null;
    }

    protected void cacheResult(Subject subject, Permission permission, boolean result) {
        if (subject == null || permission == null) {
            return;
        }
        Map<Permission, Boolean> resultMap = this.cache.get(subject);
        if (resultMap == null) {
            resultMap = new HashMap<Permission, Boolean>();
            resultMap.put(permission, result);
            this.cache.put(subject, resultMap);
        } else {
            resultMap.put(permission, result);
        }
    }
}

