/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtils {
    public static SSLContext getSSLContext(KeyStore keyStore, char[] password, KeyStore trustStore, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(SSLUtils.kmf(keyStore, password).getKeyManagers(), SSLUtils.tmf(trustStore).getTrustManagers(), random);
        return ctx;
    }

    private static KeyManagerFactory kmf(KeyStore ks, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, password);
        return kmf;
    }

    private static TrustManagerFactory tmf(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return tmf;
    }

    public static KeyStore loadKeyStore(String fileName, char[] password, String type) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SSLUtils.loadKeyStore(new File(fileName), password, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(File file, char[] password, String type) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            KeyStore keyStore = SSLUtils.loadKeyStore(in, password, type);
            return keyStore;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static KeyStore loadKeyStore(InputStream in, char[] password, String type) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(type);
        ks.load(in, password);
        return ks;
    }
}

