/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceSorter {
    private LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>> suidMap = new LinkedHashMap();

    public void clear() {
        this.suidMap.clear();
    }

    public Object addInstance(String suid, String cuid, String iuid, Object obj) {
        LinkedHashMap<String, Object> iuidMap;
        LinkedHashMap<String, LinkedHashMap<String, Object>> cuidMap = this.suidMap.get(suid);
        if (cuidMap == null) {
            cuidMap = new LinkedHashMap();
            this.suidMap.put(suid, cuidMap);
        }
        if ((iuidMap = cuidMap.get(cuid)) == null) {
            iuidMap = new LinkedHashMap();
            cuidMap.put(cuid, iuidMap);
        }
        return iuidMap.put(iuid, obj);
    }

    public Set<String> getSUIDs() {
        return Collections.unmodifiableSet(this.suidMap.keySet());
    }

    public Set<String> getCUIDs(String suid) {
        LinkedHashMap<String, LinkedHashMap<String, Object>> cuidMap = this.suidMap.get(suid);
        if (cuidMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(cuidMap.keySet());
    }

    public Set<String> getIUIDs(String suid, String cuid) {
        LinkedHashMap<String, LinkedHashMap<String, Object>> cuidMap = this.suidMap.get(suid);
        if (cuidMap == null) {
            return Collections.emptySet();
        }
        LinkedHashMap<String, Object> iuidMap = cuidMap.get(cuid);
        if (iuidMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(iuidMap.keySet());
    }

    public int countInstances(String suid, String cuid) {
        LinkedHashMap<String, LinkedHashMap<String, Object>> cuidMap = this.suidMap.get(suid);
        if (cuidMap == null) {
            return 0;
        }
        LinkedHashMap<String, Object> iuidMap = cuidMap.get(cuid);
        if (iuidMap == null) {
            return 0;
        }
        return iuidMap.size();
    }

    public Object getInstance(String suid, String cuid, String iuid) {
        LinkedHashMap<String, LinkedHashMap<String, Object>> cuidMap = this.suidMap.get(suid);
        if (cuidMap == null) {
            return null;
        }
        LinkedHashMap<String, Object> iuidMap = cuidMap.get(cuid);
        if (iuidMap == null) {
            return null;
        }
        return iuidMap.get(iuid);
    }
}

