/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.util.List;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;

public class QueryMessage
extends AuditMessage {
    public QueryMessage() {
        super(new AuditEvent(AuditEvent.ID.QUERY, AuditEvent.ActionCode.EXECUTE));
    }

    public ActiveParticipant addSourceProcess(String processID, String[] aets, String processName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor).addRoleIDCode(ActiveParticipant.RoleIDCode.SOURCE));
    }

    public ActiveParticipant addDestinationProcess(String processID, String[] aets, String processName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor).addRoleIDCode(ActiveParticipant.RoleIDCode.DESTINATION));
    }

    public ActiveParticipant addOtherParticipantPerson(String userID, String altUserID, String userName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor));
    }

    public ActiveParticipant addOtherParticipantProcess(String processID, String[] aets, String processName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor));
    }

    public ParticipantObject addQuerySOPClass(String cuid, String tsuid, byte[] query) {
        return this.addParticipantObject(ParticipantObject.createQuerySOPClass(cuid, tsuid, query));
    }

    public void validate() {
        super.validate();
        ActiveParticipant source = null;
        ActiveParticipant dest = null;
        ActiveParticipant requestor = null;
        for (ActiveParticipant ap : this.activeParticipants) {
            List<ActiveParticipant.RoleIDCode> roleIDCodeIDs = ap.getRoleIDCodes();
            if (roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.SOURCE)) {
                if (source != null) {
                    throw new IllegalStateException("Multiple Source identification");
                }
                source = ap;
            } else if (roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.DESTINATION)) {
                if (dest != null) {
                    throw new IllegalStateException("Multiple Destination identification");
                }
                dest = ap;
            }
            if (!ap.isUserIsRequestor()) continue;
            requestor = ap;
        }
        if (source == null) {
            throw new IllegalStateException("No Source identification");
        }
        if (dest == null) {
            throw new IllegalStateException("No Destination identification");
        }
        if (requestor == null) {
            throw new IllegalStateException("No Requesting User");
        }
        ParticipantObject sopClass = null;
        for (ParticipantObject po : this.participantObjects) {
            if (ParticipantObject.TypeCodeRole.REPORT != po.getParticipantObjectTypeCodeRole() || ParticipantObject.IDTypeCode.SOP_CLASS_UID != po.getParticipantObjectIDTypeCode()) continue;
            if (sopClass != null) {
                throw new IllegalStateException("Multiple Query SOP Class identification");
            }
            sopClass = po;
        }
        if (sopClass == null) {
            throw new IllegalStateException("No Query SOP Class identification");
        }
    }
}

