/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che2.audit.message.BaseElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantObjectDescription
extends BaseElement {
    private final ArrayList<BaseElement> mppss = new ArrayList();
    private final ArrayList<BaseElement> accessions = new ArrayList();
    private final ArrayList<SOPClass> sopClasses = new ArrayList();
    private final ArrayList<BaseElement> studies = new ArrayList();

    public ParticipantObjectDescription() {
        super("ParticipantObjectDescription");
    }

    public final boolean isEncrypted() {
        Boolean encrypted = (Boolean)this.getAttribute("Encrypted");
        return encrypted != null && encrypted != false;
    }

    public final ParticipantObjectDescription setEncrypted(boolean encrypted) {
        this.addAttribute("Encrypted", encrypted, false);
        return this;
    }

    public final boolean isAnonymized() {
        Boolean anonymized = (Boolean)this.getAttribute("Anonymized");
        return anonymized != null && anonymized != false;
    }

    public final ParticipantObjectDescription setAnonymized(boolean anonymized) {
        this.addAttribute("Anonymized", anonymized, true);
        return this;
    }

    private static List<String> toStringList(List<BaseElement> elements, String attrName) {
        ArrayList<String> list = new ArrayList<String>(elements.size());
        for (BaseElement el : elements) {
            list.add(el.getAttribute(attrName).toString());
        }
        return list;
    }

    public List<String> getMPPSs() {
        return ParticipantObjectDescription.toStringList(this.mppss, "UID");
    }

    public ParticipantObjectDescription addMPPS(String iuid) {
        this.mppss.add(new BaseElement("MPPS", "UID", iuid));
        return this;
    }

    public List<String> getAccessions() {
        return ParticipantObjectDescription.toStringList(this.accessions, "Number");
    }

    public ParticipantObjectDescription addAccession(String accno) {
        this.accessions.add(new BaseElement("Accession", "Number", accno));
        return this;
    }

    public List<SOPClass> getSOPClasses() {
        return Collections.unmodifiableList(this.sopClasses);
    }

    public ParticipantObjectDescription addSOPClass(SOPClass sopClass) {
        if (sopClass == null) {
            throw new NullPointerException();
        }
        this.sopClasses.add(sopClass);
        return this;
    }

    public ParticipantObjectDescription addStudy(String suid) {
        this.studies.add(new BaseElement("Study", "UID", suid));
        return this;
    }

    @Override
    protected boolean isEmpty() {
        return false;
    }

    @Override
    protected void outputContent(Writer out) throws IOException {
        this.outputChilds(out, this.mppss);
        this.outputChilds(out, this.accessions);
        this.outputChilds(out, this.sopClasses);
        this.outputChilds(out, this.studies);
    }

    public static class SOPClass
    extends BaseElement {
        private final ArrayList<BaseElement> instances = new ArrayList();

        public SOPClass(String uid) {
            super("SOPClass", "UID", uid);
        }

        public SOPClass setNumberOfInstances(int n) {
            this.addAttribute("NumberOfInstances", n > 0 ? new Integer(n) : null, true);
            return this;
        }

        public int getNumberOfInstances() {
            Integer n = (Integer)this.getAttribute("NumberOfInstances");
            return n != null ? n : 0;
        }

        public SOPClass addInstance(String iuid) {
            this.instances.add(new BaseElement("Instance", "UID", iuid));
            return this;
        }

        protected boolean isEmpty() {
            return this.instances.isEmpty();
        }

        protected void outputContent(Writer out) throws IOException {
            this.outputChilds(out, this.instances);
        }
    }
}

