/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.util.List;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;

public class DataExportMessage
extends AuditMessage {
    public DataExportMessage() {
        super(new AuditEvent(AuditEvent.ID.EXPORT, AuditEvent.ActionCode.READ));
    }

    public ActiveParticipant addExporterPerson(String userID, String altUserID, String userName, boolean requestor, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor)).addRoleIDCode(ActiveParticipant.RoleIDCode.SOURCE);
    }

    public ActiveParticipant addExporterProcess(String processID, String[] aets, String processName, boolean requestor, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor).addRoleIDCode(ActiveParticipant.RoleIDCode.SOURCE));
    }

    public ActiveParticipant addDestinationMedia(String mediaID, String mediaUID) {
        return this.addActiveParticipant(ActiveParticipant.createMedia(mediaID, mediaUID).addRoleIDCode(ActiveParticipant.RoleIDCode.DESTINATION_MEDIA));
    }

    public ActiveParticipant addDestinationMedia(String userID, String altUserID, String userName, boolean requestor, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor)).addRoleIDCode(ActiveParticipant.RoleIDCode.DESTINATION_MEDIA);
    }

    public ParticipantObject addPatient(String id, String name) {
        return this.addParticipantObject(ParticipantObject.createPatient(id, name));
    }

    public ParticipantObject addStudy(String uid, ParticipantObjectDescription desc) {
        return this.addParticipantObject(ParticipantObject.createStudy(uid, desc));
    }

    public ParticipantObject addDataRepository(String uri) {
        return this.addParticipantObject(ParticipantObject.createDataRepository(uri));
    }

    public void validate() {
        super.validate();
        ActiveParticipant exporter = null;
        ActiveParticipant dest = null;
        ActiveParticipant requestor = null;
        for (ActiveParticipant ap : this.activeParticipants) {
            List<ActiveParticipant.RoleIDCode> roleIDCodeIDs = ap.getRoleIDCodes();
            if (roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.SOURCE)) {
                exporter = ap;
            } else if (roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.DESTINATION_MEDIA)) {
                if (dest != null) {
                    throw new IllegalStateException("Multiple Destination identification");
                }
                dest = ap;
            }
            if (!ap.isUserIsRequestor()) continue;
            requestor = ap;
        }
        if (exporter == null) {
            throw new IllegalStateException("No Exporter identification");
        }
        if (dest == null) {
            throw new IllegalStateException("No Destination identification");
        }
        if (requestor == null) {
            throw new IllegalStateException("No Requesting User");
        }
    }
}

