/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.BaseElement;

public class CodeElement
extends BaseElement {
    private final boolean readonly;

    protected CodeElement(String name, String code) {
        this(name, code, false);
    }

    protected CodeElement(String name, String code, String codeSystemName, String displayName) {
        this(name, code, true);
        this.addAttribute("codeSystemName", codeSystemName, false);
        this.addAttribute("displayName", displayName, false);
    }

    protected CodeElement(String name, String code, boolean readonly) {
        super(name);
        this.addAttribute("code", code, false);
        this.readonly = readonly;
    }

    private void checkReadOnly() {
        if (this.readonly) {
            throw new IllegalStateException("Cannot modify Code constant");
        }
    }

    public final String getCode() {
        return (String)this.getAttribute("code");
    }

    public final String getCodeSystem() {
        return (String)this.getAttribute("codeSystem");
    }

    public final CodeElement setCodeSystem(String codeSystem) {
        this.checkReadOnly();
        this.addAttribute("codeSystem", codeSystem, true);
        return this;
    }

    public final String getCodeSystemName() {
        return (String)this.getAttribute("codeSystemName");
    }

    public final CodeElement setCodeSystemName(String codeSystemName) {
        this.checkReadOnly();
        this.addAttribute("codeSystemName", codeSystemName, true);
        return this;
    }

    public final String getDisplayName() {
        return (String)this.getAttribute("displayName");
    }

    public final CodeElement setDisplayName(String displayName) {
        this.checkReadOnly();
        this.addAttribute("displayName", displayName, true);
        return this;
    }

    public final String getOriginalText() {
        return (String)this.getAttribute("originalText");
    }

    public final CodeElement setOriginalText(String originalText) {
        this.checkReadOnly();
        this.addAttribute("originalText", originalText, true);
        return this;
    }
}

