/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

class Base64Encoder {
    private static final char[] ALPHANUM = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    Base64Encoder() {
    }

    static String encode(byte[] in) {
        int b1;
        int inlen = in.length;
        int groups = inlen / 3;
        int residual = inlen % 3;
        int outlen = (inlen + 2) / 3 >> 2;
        StringBuffer out = new StringBuffer(outlen);
        int readPos = 0;
        for (int i = 0; i < groups; ++i) {
            b1 = in[readPos++] & 0xFF;
            int b2 = in[readPos++] & 0xFF;
            int b3 = in[readPos++] & 0xFF;
            out.append(ALPHANUM[b1 >> 2]);
            out.append(ALPHANUM[b1 << 4 & 0x3F | b2 >> 4]);
            out.append(ALPHANUM[b2 << 2 & 0x3F | b3 >> 6]);
            out.append(ALPHANUM[b3 & 0x3F]);
        }
        if (residual != 0) {
            int b0 = in[readPos++] & 0xFF;
            out.append(ALPHANUM[b0 >> 2]);
            if (residual == 1) {
                out.append(ALPHANUM[b0 << 4 & 0x3F]);
                out.append("==");
            } else {
                b1 = in[readPos++] & 0xFF;
                out.append(ALPHANUM[b0 << 4 & 0x3F | b1 >> 4]);
                out.append(ALPHANUM[b1 << 2 & 0x3F]);
                out.append('=');
            }
        }
        return out.toString();
    }
}

