/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;

public class AuditMessageSupport
extends AuditMessage {
    public static final AuditEvent.ActionCode CREATE = AuditEvent.ActionCode.CREATE;
    public static final AuditEvent.ActionCode READ = AuditEvent.ActionCode.READ;
    public static final AuditEvent.ActionCode UPDATE = AuditEvent.ActionCode.UPDATE;
    public static final AuditEvent.ActionCode DELETE = AuditEvent.ActionCode.DELETE;

    protected AuditMessageSupport(AuditEvent.ID id, AuditEvent.ActionCode action) {
        super(new AuditEvent(id, AuditMessageSupport.check(action)));
    }

    private static AuditEvent.ActionCode check(AuditEvent.ActionCode action) {
        if (action == AuditEvent.ActionCode.EXECUTE) {
            throw new IllegalArgumentException("action=Execute");
        }
        return action;
    }

    public ActiveParticipant addUserPerson(String userID, String altUserID, String userName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, requestor));
    }

    public ActiveParticipant addUserProcess(String processID, String[] aets, String processName, String hostname, boolean requestor) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, requestor));
    }

    public ParticipantObject addPatient(String id, String name) {
        return this.addParticipantObject(ParticipantObject.createPatient(id, name));
    }

    public void validate() {
        super.validate();
        ActiveParticipant user = this.getRequestingActiveParticipants();
        if (user == null) {
            throw new IllegalStateException("No Requesting User");
        }
        ParticipantObject patient = null;
        for (ParticipantObject po : this.participantObjects) {
            if (ParticipantObject.TypeCodeRole.PATIENT != po.getParticipantObjectTypeCodeRole()) continue;
            if (patient != null) {
                throw new IllegalStateException("Multiple Patient identification");
            }
            patient = po;
        }
        if (patient == null) {
            throw new IllegalStateException("No Patient identification");
        }
    }
}

