/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditSource;
import org.dcm4che2.audit.message.BaseElement;
import org.dcm4che2.audit.message.ParticipantObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditMessage
extends BaseElement {
    private static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int millisPerMinute = 60000;
    private static boolean incXMLDecl = false;
    private static boolean enableDNSLookups = false;
    private static boolean timezonedDateTime = true;
    private static boolean utcDateTime = false;
    private static boolean qualifyHostname = false;
    private static boolean allowMultipleRequestors = false;
    private static InetAddress localHost;
    private static String processID;
    private static String processName;
    private static String[] localAETitles;
    protected final AuditEvent event;
    protected final ArrayList<ActiveParticipant> activeParticipants = new ArrayList(3);
    protected final ArrayList<AuditSource> auditSources = new ArrayList(1);
    protected final ArrayList<ParticipantObject> participantObjects = new ArrayList(3);

    public AuditMessage(AuditEvent event) {
        super("AuditMessage");
        if (event == null) {
            throw new NullPointerException();
        }
        this.event = event;
    }

    public final AuditEvent getAuditEvent() {
        return this.event;
    }

    public void setEventDateTime(Date datetime) {
        this.event.setEventDateTime(datetime);
    }

    public void setOutcomeIndicator(AuditEvent.OutcomeIndicator outcome) {
        this.event.setOutcomeIndicator(outcome);
    }

    public List<AuditSource> getAuditSources() {
        return Collections.unmodifiableList(this.auditSources);
    }

    public AuditSource addAuditSource(AuditSource sourceId) {
        if (sourceId == null) {
            throw new NullPointerException();
        }
        this.auditSources.add(sourceId);
        return sourceId;
    }

    public List<ActiveParticipant> getActiveParticipants() {
        return Collections.unmodifiableList(this.activeParticipants);
    }

    public ActiveParticipant getRequestingActiveParticipants() {
        for (ActiveParticipant ap : this.activeParticipants) {
            if (!ap.isUserIsRequestor()) continue;
            return ap;
        }
        return null;
    }

    public ActiveParticipant addActiveParticipant(ActiveParticipant apart) {
        if (!allowMultipleRequestors && apart.isUserIsRequestor() && this.getRequestingActiveParticipants() != null) {
            throw new IllegalStateException("Message already contains requesting Active Participant");
        }
        this.activeParticipants.add(apart);
        return apart;
    }

    public List<ParticipantObject> getParticipantObjects() {
        return Collections.unmodifiableList(this.participantObjects);
    }

    public ParticipantObject addParticipantObject(ParticipantObject obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        this.participantObjects.add(obj);
        return obj;
    }

    @Override
    protected boolean isEmpty() {
        return false;
    }

    @Override
    public String toString() {
        return this.toString(1024);
    }

    @Override
    public void output(Writer out) throws IOException {
        if (incXMLDecl) {
            out.write(XML_VERSION_1_0_ENCODING_UTF_8);
        }
        super.output(out);
    }

    public void validate() {
        if (this.activeParticipants.isEmpty()) {
            throw new IllegalStateException("No Active Participant");
        }
    }

    @Override
    protected void outputContent(Writer out) throws IOException {
        this.event.output(out);
        this.outputChilds(out, this.activeParticipants);
        if (this.auditSources.isEmpty()) {
            AuditSource.getDefaultAuditSource().output(out);
        } else {
            this.outputChilds(out, this.auditSources);
        }
        this.outputChilds(out, this.participantObjects);
    }

    public static final boolean isIncludeXMLDeclaration() {
        return incXMLDecl;
    }

    public static final void setIncludeXMLDeclaration(boolean incXMLDecl) {
        AuditMessage.incXMLDecl = incXMLDecl;
    }

    public static final boolean isTimezonedDateTime() {
        return timezonedDateTime;
    }

    public static final void setTimezonedDateTime(boolean timezonedDateTime) {
        AuditMessage.timezonedDateTime = timezonedDateTime;
    }

    public static final boolean isUtcDateTime() {
        return utcDateTime;
    }

    public static final void setUtcDateTime(boolean utcDateTime) {
        AuditMessage.utcDateTime = utcDateTime;
    }

    public static final boolean isQualifyHostname() {
        return qualifyHostname;
    }

    public static final void setQualifyHostname(boolean qualifyHostname) {
        AuditMessage.qualifyHostname = qualifyHostname;
    }

    public static String getProcessID() {
        return processID;
    }

    public static String getProcessName() {
        return processName;
    }

    public static void setProcessName(String processName) {
        AuditMessage.processName = processName;
    }

    public static String[] getLocalAETitles() {
        return localAETitles != null ? (String[])localAETitles.clone() : null;
    }

    public static void setLocalAETitles(String[] aets) {
        localAETitles = aets != null ? (String[])aets.clone() : null;
    }

    public static boolean isEnableDNSLookups() {
        return enableDNSLookups;
    }

    public static void setEnableDNSLookups(boolean enableDNSLookups) {
        AuditMessage.enableDNSLookups = enableDNSLookups;
    }

    public static String hostNameOf(InetAddress node) {
        return enableDNSLookups ? AuditMessage.skipDomain(node.getHostName()) : node.getHostAddress();
    }

    public static String nodeIDOf(InetAddress node) {
        if (!enableDNSLookups) {
            return node.getHostAddress();
        }
        String hname = node.getCanonicalHostName();
        if (ActiveParticipant.isIP(hname)) {
            return hname;
        }
        int dotPos = hname.indexOf(46);
        if (dotPos == -1) {
            return hname;
        }
        char[] cs = hname.toCharArray();
        cs[dotPos] = 64;
        return new String(cs);
    }

    public static InetAddress getLocalHost() {
        return localHost;
    }

    public static String getLocalHostName() {
        return AuditMessage.skipDomain(AuditMessage.getLocalHost().getHostName());
    }

    public static String getLocalNodeID() {
        return AuditMessage.nodeIDOf(localHost);
    }

    public static String aetToAltUserID(String aet) {
        if (aet == null || aet.length() == 0) {
            return null;
        }
        return "AETITLES=" + aet;
    }

    public static String aetsToAltUserID(String[] aets) {
        if (aets == null || aets.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("AETITLES=");
        for (int i = 0; i < aets.length; ++i) {
            if (aets[i] == null) {
                throw new NullPointerException("aets[" + i + "]");
            }
            if (aets[i].length() == 0) {
                throw new IllegalArgumentException("aets[" + i + "]=\"\"");
            }
            if (i > 0) {
                sb.append(';');
            }
            sb.append(aets[i]);
        }
        return sb.toString();
    }

    public static String[] altUserIDToAETs(String altUserID) {
        if (altUserID == null || !altUserID.startsWith("AETITLES=")) {
            return new String[0];
        }
        return altUserID.substring(9).split(";");
    }

    public static String toDateTimeStr(Date date) {
        Calendar c = Calendar.getInstance(Locale.ENGLISH);
        c.setTime(date);
        if (utcDateTime) {
            c.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append(c.get(1));
        AuditMessage.appendNNTo('-', c.get(2) + 1, sb);
        AuditMessage.appendNNTo('-', c.get(5), sb);
        AuditMessage.appendNNTo('T', c.get(11), sb);
        AuditMessage.appendNNTo(':', c.get(12), sb);
        AuditMessage.appendNNTo(':', (float)c.get(13) + (float)c.get(14) / 1000.0f, sb);
        if (timezonedDateTime) {
            AuditMessage.appendTZTo(c.get(15) + c.get(16), sb);
        }
        return sb.toString();
    }

    private static void appendNNTo(char c, int i, StringBuffer sb) {
        sb.append(c);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
    }

    private static void appendNNTo(char c, float f, StringBuffer sb) {
        sb.append(c);
        if (f < 10.0f) {
            sb.append('0');
        }
        sb.append(f);
    }

    private static void appendTZTo(int millis, StringBuffer sb) {
        char sign;
        int mm = millis / 60000;
        if (mm == 0) {
            sb.append('Z');
            return;
        }
        if (mm > 0) {
            sign = '+';
        } else {
            sign = '-';
            mm = -mm;
        }
        int hh = mm / 60;
        AuditMessage.appendNNTo(sign, hh, sb);
        AuditMessage.appendNNTo(':', mm -= hh * 60, sb);
    }

    private static String skipDomain(String hostname) {
        if (qualifyHostname) {
            return hostname;
        }
        int dotpos = hostname.indexOf(46);
        return dotpos > 0 && !Character.isDigit(hostname.charAt(0)) ? hostname.substring(0, dotpos) : hostname;
    }

    public static void setAllowMultipleRequestors(boolean allowMultipleRequestors) {
        AuditMessage.allowMultipleRequestors = allowMultipleRequestors;
    }

    public static boolean isAllowMultipleRequestors() {
        return allowMultipleRequestors;
    }

    static {
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            try {
                localHost = InetAddress.getByName(null);
            }
            catch (UnknownHostException e1) {
                throw new RuntimeException(e1);
            }
        }
        processID = System.getProperty("app.pid");
        if (processID == null) {
            String s = ManagementFactory.getRuntimeMXBean().getName();
            int atPos = s.indexOf(64);
            processID = atPos > 0 ? s.substring(0, atPos) : s;
        }
        processName = System.getProperty("app.name");
    }
}

