/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.ParticipantObject;

public class AuditLogUsedMessage
extends AuditMessage {
    public AuditLogUsedMessage() {
        super(new AuditEvent(AuditEvent.ID.AUDIT_LOG_USED, AuditEvent.ActionCode.READ));
    }

    public ActiveParticipant addUserPerson(String userID, String altUserID, String userName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, hostname, true));
    }

    public ActiveParticipant addUserProcess(String processID, String[] aets, String processName, String hostname) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, hostname, true));
    }

    public ParticipantObject addSecurityAuditLog(String uri) {
        ParticipantObject obj = ParticipantObject.createSecurityAuditLog(uri);
        this.addParticipantObject(obj);
        return obj;
    }

    public void validate() {
        super.validate();
        ActiveParticipant user = this.getRequestingActiveParticipants();
        if (user == null) {
            throw new IllegalStateException("No Requesting User");
        }
        ParticipantObject auditLog = null;
        for (ParticipantObject po : this.participantObjects) {
            if (ParticipantObject.TypeCodeRole.SECURITY_RESOURCE != po.getParticipantObjectTypeCodeRole()) continue;
            if (auditLog != null) {
                throw new IllegalStateException("Multiple Audit Log identification");
            }
            auditLog = po;
        }
        if (auditLog == null) {
            throw new IllegalStateException("No Audit Log identification");
        }
    }
}

